/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.DriverStatus;
import org.elasticsearch.compute.operator.OperatorStatus;
import org.elasticsearch.compute.operator.PlanProfile;
import org.elasticsearch.compute.operator.PlanTimeProfile;

public record DriverCompletionInfo(long documentsFound, long valuesLoaded, List<DriverProfile> driverProfiles, List<PlanProfile> planProfiles) implements Writeable
{
    public static final DriverCompletionInfo EMPTY = new DriverCompletionInfo(0L, 0L, List.of(), List.of());
    private static final TransportVersion ESQL_PROFILE_INCLUDE_PLAN = TransportVersion.fromName((String)"esql_profile_include_plan");

    public static DriverCompletionInfo includingProfiles(List<Driver> drivers, String description, String clusterName, String nodeName, String planTree, PlanTimeProfile planTimeProfile) {
        long documentsFound = 0L;
        long valuesLoaded = 0L;
        ArrayList<DriverProfile> collectedProfiles = new ArrayList<DriverProfile>(drivers.size());
        for (Driver d : drivers) {
            DriverProfile p = d.profile();
            for (OperatorStatus o : p.operators()) {
                documentsFound += o.documentsFound();
                valuesLoaded += o.valuesLoaded();
            }
            collectedProfiles.add(p);
        }
        return new DriverCompletionInfo(documentsFound, valuesLoaded, collectedProfiles, List.of(new PlanProfile(description, clusterName, nodeName, planTree, planTimeProfile)));
    }

    public static DriverCompletionInfo excludingProfiles(List<Driver> drivers) {
        long documentsFound = 0L;
        long valuesLoaded = 0L;
        for (Driver d : drivers) {
            DriverStatus s = d.status();
            assert (s.status() == DriverStatus.Status.DONE);
            for (OperatorStatus o : s.completedOperators()) {
                documentsFound += o.documentsFound();
                valuesLoaded += o.valuesLoaded();
            }
        }
        return new DriverCompletionInfo(documentsFound, valuesLoaded, List.of(), List.of());
    }

    public static DriverCompletionInfo readFrom(StreamInput in) throws IOException {
        return new DriverCompletionInfo(in.readVLong(), in.readVLong(), in.readCollectionAsImmutableList(DriverProfile::readFrom), in.getTransportVersion().supports(ESQL_PROFILE_INCLUDE_PLAN) ? in.readCollectionAsImmutableList(PlanProfile::readFrom) : List.of());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.documentsFound);
        out.writeVLong(this.valuesLoaded);
        out.writeCollection(this.driverProfiles);
        if (out.getTransportVersion().supports(ESQL_PROFILE_INCLUDE_PLAN)) {
            out.writeCollection(this.planProfiles);
        }
    }

    public static class AtomicAccumulator {
        private final AtomicLong documentsFound = new AtomicLong();
        private final AtomicLong valuesLoaded = new AtomicLong();
        private final List<DriverProfile> collectedProfiles = Collections.synchronizedList(new ArrayList());
        private final List<PlanProfile> planProfiles = Collections.synchronizedList(new ArrayList());

        public void accumulate(DriverCompletionInfo info) {
            this.documentsFound.addAndGet(info.documentsFound);
            this.valuesLoaded.addAndGet(info.valuesLoaded);
            this.collectedProfiles.addAll(info.driverProfiles);
            this.planProfiles.addAll(info.planProfiles);
        }

        public DriverCompletionInfo finish() {
            return new DriverCompletionInfo(this.documentsFound.get(), this.valuesLoaded.get(), this.collectedProfiles, this.planProfiles);
        }
    }

    public static class Accumulator {
        private long documentsFound;
        private long valuesLoaded;
        private final List<DriverProfile> driverProfiles = new ArrayList<DriverProfile>();
        private final List<PlanProfile> planProfiles = new ArrayList<PlanProfile>();

        public void accumulate(DriverCompletionInfo info) {
            this.documentsFound += info.documentsFound;
            this.valuesLoaded += info.valuesLoaded;
            this.driverProfiles.addAll(info.driverProfiles);
            this.planProfiles.addAll(info.planProfiles);
        }

        public DriverCompletionInfo finish() {
            return new DriverCompletionInfo(this.documentsFound, this.valuesLoaded, this.driverProfiles, this.planProfiles);
        }
    }
}

