/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.GenericNamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.parsing.TDigestParser;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class TDigestHolder
implements GenericNamedWriteable {
    private static final TDigestHolder EMPTY;
    private static final TransportVersion ESQL_SERIALIZEABLE_TDIGEST;
    public static final NamedWriteableRegistry.Entry ENTRY;
    private final double min;
    private final double max;
    private final double sum;
    private final long valueCount;
    private final BytesRef encodedDigest;

    public TDigestHolder(BytesRef encodedDigest, double min, double max, double sum, long valueCount) {
        this.encodedDigest = encodedDigest;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.valueCount = valueCount;
    }

    public TDigestHolder(TDigestState rawTDigest, double min, double max, double sum, long valueCount) {
        try {
            this.encodedDigest = TDigestHolder.encodeCentroidsAndCounts(rawTDigest);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding TDigest", e);
        }
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.valueCount = valueCount;
    }

    public TDigestHolder(TDigestParser.ParsedTDigest parsed) throws IOException {
        this(parsed.centroids(), parsed.counts(), parsed.min(), parsed.max(), parsed.sum(), parsed.count());
    }

    public TDigestHolder(List<Double> centroids, List<Long> counts, double min, double max, double sum, long valueCount) throws IOException {
        this(TDigestHolder.encodeCentroidsAndCounts(centroids, counts), min, max, sum, valueCount);
    }

    public static TDigestHolder empty() {
        return EMPTY;
    }

    public TDigestHolder(StreamInput in) throws IOException {
        this.encodedDigest = in.readBytesRef();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.sum = in.readDouble();
        this.valueCount = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesRef(this.encodedDigest);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.sum);
        out.writeVLong(this.valueCount);
    }

    public boolean equals(Object o) {
        if (o instanceof TDigestHolder) {
            TDigestHolder that = (TDigestHolder)o;
            return Double.compare(this.min, that.min) == 0 && Double.compare(this.max, that.max) == 0 && Double.compare(this.sum, that.sum) == 0 && this.valueCount == that.valueCount && Objects.equals(this.encodedDigest, that.encodedDigest);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.sum, this.valueCount, this.encodedDigest);
    }

    private static BytesRef encodeCentroidsAndCounts(List<Double> centroids, List<Long> counts) throws IOException {
        BytesStreamOutput streamOutput = new BytesStreamOutput();
        for (int i = 0; i < centroids.size(); ++i) {
            long count = counts.get(i);
            assert (count >= 0L);
            if (count <= 0L) continue;
            streamOutput.writeVLong(count);
            streamOutput.writeDouble(centroids.get(i).doubleValue());
        }
        BytesRef docValue = streamOutput.bytes().toBytesRef();
        return docValue;
    }

    private static BytesRef encodeCentroidsAndCounts(TDigestState rawTDigest) throws IOException {
        BytesStreamOutput streamOutput = new BytesStreamOutput();
        Iterator it = rawTDigest.uniqueCentroids();
        while (it.hasNext()) {
            Centroid centroid = (Centroid)it.next();
            if (centroid.count() <= 0L) continue;
            streamOutput.writeVLong(centroid.count());
            streamOutput.writeDouble(centroid.mean());
        }
        BytesRef docValue = streamOutput.bytes().toBytesRef();
        return docValue;
    }

    public void addTo(TDigestState state) {
        try {
            ByteArrayStreamInput values = new ByteArrayStreamInput();
            values.reset(this.encodedDigest.bytes, this.encodedDigest.offset, this.encodedDigest.length);
            while (values.available() > 0) {
                long count = values.readVLong();
                double centroid = values.readDouble();
                state.add(centroid, count);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Malformed TDigest bytes", e);
        }
    }

    public BytesRef getEncodedDigest() {
        return this.encodedDigest;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getSum() {
        return this.sum;
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public String toString() {
        String string;
        block14: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.startObject();
                if (!Double.isNaN(this.getMin())) {
                    builder.field("min", this.getMin());
                }
                if (!Double.isNaN(this.getMax())) {
                    builder.field("max", this.getMax());
                }
                if (!Double.isNaN(this.getSum())) {
                    builder.field("sum", this.getSum());
                }
                ByteArrayStreamInput values = new ByteArrayStreamInput();
                values.reset(this.encodedDigest.bytes, this.encodedDigest.offset, this.encodedDigest.length);
                ArrayList<Double> centroids = new ArrayList<Double>();
                ArrayList<Long> counts = new ArrayList<Long>();
                while (values.available() > 0) {
                    counts.add(values.readVLong());
                    centroids.add(values.readDouble());
                }
                builder.startArray("centroids");
                for (Double centroid : centroids) {
                    builder.value(centroid.doubleValue());
                }
                builder.endArray();
                builder.startArray("counts");
                for (Long count : counts) {
                    builder.value(count.longValue());
                }
                builder.endArray();
                builder.endObject();
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("error rendering TDigest", e);
                }
            }
            builder.close();
        }
        return string;
    }

    public String getWriteableName() {
        return "TDigestHolder";
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ESQL_SERIALIZEABLE_TDIGEST;
    }

    static {
        try {
            EMPTY = new TDigestHolder(TDigestHolder.encodeCentroidsAndCounts(List.of(), List.of()), Double.NaN, Double.NaN, Double.NaN, 0L);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        ESQL_SERIALIZEABLE_TDIGEST = TransportVersion.fromName((String)"esql_serializeable_tdigest");
        ENTRY = new NamedWriteableRegistry.Entry(GenericNamedWriteable.class, "TDigestHolder", TDigestHolder::new);
    }
}

