/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.TDigestArrayBlock;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;

public final class TDigestBlockBuilder
implements TDigestBlock.Builder {
    private final BytesRefBlock.Builder encodedDigestsBuilder;
    private final DoubleBlock.Builder minimaBuilder;
    private final DoubleBlock.Builder maximaBuilder;
    private final DoubleBlock.Builder sumsBuilder;
    private final LongBlock.Builder valueCountsBuilder;
    private final BytesRef scratch = new BytesRef();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TDigestBlockBuilder(int size, BlockFactory blockFactory) {
        BytesRefBlock.Builder encodedDigestsBuilder = null;
        DoubleBlock.Builder minimaBuilder = null;
        DoubleBlock.Builder maximaBuilder = null;
        DoubleBlock.Builder sumsBuilder = null;
        LongBlock.Builder valueCountsBuilder = null;
        boolean success = false;
        try {
            encodedDigestsBuilder = blockFactory.newBytesRefBlockBuilder(size);
            minimaBuilder = blockFactory.newDoubleBlockBuilder(size);
            maximaBuilder = blockFactory.newDoubleBlockBuilder(size);
            sumsBuilder = blockFactory.newDoubleBlockBuilder(size);
            valueCountsBuilder = blockFactory.newLongBlockBuilder(size);
            this.encodedDigestsBuilder = encodedDigestsBuilder;
            this.minimaBuilder = minimaBuilder;
            this.maximaBuilder = maximaBuilder;
            this.sumsBuilder = sumsBuilder;
            this.valueCountsBuilder = valueCountsBuilder;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            Releasables.close((Releasable[])new Releasable[]{encodedDigestsBuilder, minimaBuilder, maximaBuilder, sumsBuilder, valueCountsBuilder});
            throw throwable;
        }
    }

    @Override
    public TDigestBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int i = beginInclusive; i < endExclusive; ++i) {
                this.appendNull();
            }
        } else {
            TDigestArrayBlock digestBlock = (TDigestArrayBlock)block;
            digestBlock.copyInto(this.encodedDigestsBuilder, this.minimaBuilder, this.maximaBuilder, this.sumsBuilder, this.valueCountsBuilder, beginInclusive, endExclusive);
        }
        return this;
    }

    @Override
    public TDigestBlock.Builder copyFrom(TDigestBlock block, int position) {
        this.copyFrom(block, position, position + 1);
        return this;
    }

    @Override
    public Block.Builder appendNull() {
        this.encodedDigestsBuilder.appendNull();
        this.minimaBuilder.appendNull();
        this.maximaBuilder.appendNull();
        this.sumsBuilder.appendNull();
        this.valueCountsBuilder.appendNull();
        return this;
    }

    @Override
    public Block.Builder beginPositionEntry() {
        throw new UnsupportedOperationException("TDigest Blocks do not support multi-values");
    }

    @Override
    public Block.Builder endPositionEntry() {
        throw new UnsupportedOperationException("TDigest Blocks do not support multi-values");
    }

    @Override
    public Block.Builder mvOrdering(Block.MvOrdering mvOrdering) {
        assert (mvOrdering == Block.MvOrdering.UNORDERED) : "TDigests don't have a natural order, so it doesn't make sense to call this";
        return this;
    }

    @Override
    public long estimatedBytes() {
        return this.encodedDigestsBuilder.estimatedBytes() + this.minimaBuilder.estimatedBytes() + this.maximaBuilder.estimatedBytes() + this.sumsBuilder.estimatedBytes() + this.valueCountsBuilder.estimatedBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TDigestBlock build() {
        TDigestArrayBlock tDigestArrayBlock;
        block3: {
            DoubleBlock minima = null;
            DoubleBlock maxima = null;
            DoubleBlock sums = null;
            LongBlock valueCounts = null;
            BytesRefBlock encodedDigests = null;
            boolean success = false;
            try {
                minima = this.minimaBuilder.build();
                maxima = this.maximaBuilder.build();
                sums = this.sumsBuilder.build();
                valueCounts = this.valueCountsBuilder.build();
                encodedDigests = this.encodedDigestsBuilder.build();
                success = true;
                tDigestArrayBlock = new TDigestArrayBlock(encodedDigests, minima, maxima, sums, valueCounts);
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, encodedDigests});
                }
                throw throwable;
            }
            Releasables.close((Releasable[])new Releasable[]{minima, maxima, sums, valueCounts, encodedDigests});
        }
        return tDigestArrayBlock;
    }

    public BlockLoader.DoubleBuilder minima() {
        return this.minimaBuilder;
    }

    public BlockLoader.DoubleBuilder maxima() {
        return this.maximaBuilder;
    }

    public BlockLoader.DoubleBuilder sums() {
        return this.sumsBuilder;
    }

    public BlockLoader.LongBuilder valueCounts() {
        return this.valueCountsBuilder;
    }

    public BlockLoader.BytesRefBuilder encodedDigests() {
        return this.encodedDigestsBuilder;
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.encodedDigestsBuilder, this.minimaBuilder, this.maximaBuilder, this.sumsBuilder, this.valueCountsBuilder});
    }

    public void appendTDigest(TDigestHolder val) {
        this.encodedDigestsBuilder.appendBytesRef(val.getEncodedDigest());
        if (Double.isNaN(val.getMin())) {
            this.minimaBuilder.appendNull();
        } else {
            this.minimaBuilder.appendDouble(val.getMin());
        }
        if (Double.isNaN(val.getMax())) {
            this.maximaBuilder.appendNull();
        } else {
            this.maximaBuilder.appendDouble(val.getMax());
        }
        if (Double.isNaN(val.getSum())) {
            this.sumsBuilder.appendNull();
        } else {
            this.sumsBuilder.appendDouble(val.getSum());
        }
        this.valueCountsBuilder.appendLong(val.getValueCount());
    }

    public void deserializeAndAppend(TDigestBlock.SerializedTDigestInput input) {
        long valueCount = input.readLong();
        this.valueCountsBuilder.appendLong(valueCount);
        if (valueCount > 0L) {
            this.sumsBuilder.appendDouble(input.readDouble());
            this.minimaBuilder.appendDouble(input.readDouble());
            this.maximaBuilder.appendDouble(input.readDouble());
        } else {
            this.sumsBuilder.appendNull();
            this.minimaBuilder.appendNull();
            this.maximaBuilder.appendNull();
        }
        this.encodedDigestsBuilder.appendBytesRef(input.readBytesRef(this.scratch));
    }
}

