/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ConstantIntVector;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class DocVector
extends AbstractVector
implements Vector {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DocVector.class);
    public static final int SHARD_SEGMENT_DOC_MAP_PER_ROW_OVERHEAD = 8;
    private final IntVector shards;
    private final IntVector segments;
    private final IntVector docs;
    private Boolean singleSegmentNonDecreasing;
    private int[] shardSegmentDocMapForwards;
    private int[] shardSegmentDocMapBackwards;
    private final IndexedByShardId<? extends RefCounted> refCounteds;

    public RefCounted shardRefCounted(int position) {
        return this.refCounteds.get(this.shards.getInt(position));
    }

    public DocVector(IndexedByShardId<? extends RefCounted> refCounteds, IntVector shards, IntVector segments, IntVector docs, Boolean singleSegmentNonDecreasing) {
        this(refCounteds, shards, segments, docs, singleSegmentNonDecreasing, true);
    }

    public static DocVector withoutIncrementingShardRefCounts(IndexedByShardId<? extends RefCounted> refCounteds, IntVector shards, IntVector segments, IntVector docs) {
        return new DocVector(refCounteds, shards, segments, docs, null, false);
    }

    private DocVector(IndexedByShardId<? extends RefCounted> refCounteds, IntVector shards, IntVector segments, IntVector docs, Boolean singleSegmentNonDecreasing, boolean incrementShardRefCounts) {
        super(shards.getPositionCount(), shards.blockFactory());
        this.refCounteds = refCounteds;
        this.shards = shards;
        this.segments = segments;
        this.docs = docs;
        this.singleSegmentNonDecreasing = singleSegmentNonDecreasing;
        if (shards.getPositionCount() != segments.getPositionCount()) {
            throw new IllegalArgumentException("invalid position count [" + shards.getPositionCount() + " != " + segments.getPositionCount() + "]");
        }
        if (shards.getPositionCount() != docs.getPositionCount()) {
            throw new IllegalArgumentException("invalid position count [" + shards.getPositionCount() + " != " + docs.getPositionCount() + "]");
        }
        this.blockFactory().adjustBreaker(BASE_RAM_BYTES_USED);
        if (incrementShardRefCounts) {
            this.forEachShardRefCounter(RefCounted::mustIncRef);
        }
    }

    public DocVector(IndexedByShardId<? extends RefCounted> refCounteds, IntVector shards, IntVector segments, IntVector docs, int[] docMapForwards, int[] docMapBackwards) {
        this(refCounteds, shards, segments, docs, null);
        this.shardSegmentDocMapForwards = docMapForwards;
        this.shardSegmentDocMapBackwards = docMapBackwards;
    }

    public IntVector shards() {
        return this.shards;
    }

    public IntVector segments() {
        return this.segments;
    }

    public IntVector docs() {
        return this.docs;
    }

    public boolean singleSegment() {
        return this.shards.isConstant() && this.segments.isConstant();
    }

    public boolean singleSegmentNonDecreasing() {
        if (this.singleSegmentNonDecreasing == null) {
            this.singleSegmentNonDecreasing = this.checkIfSingleSegmentNonDecreasing();
        }
        return this.singleSegmentNonDecreasing;
    }

    private boolean checkIfSingleSegmentNonDecreasing() {
        if (this.getPositionCount() < 2) {
            return true;
        }
        if (!this.singleSegment()) {
            return false;
        }
        int prev = this.docs.getInt(0);
        int p = 1;
        while (p < this.getPositionCount()) {
            int v;
            if (prev > (v = this.docs.getInt(p++))) {
                return false;
            }
            prev = v;
        }
        return true;
    }

    public int[] shardSegmentDocMapForwards() {
        this.buildShardSegmentDocMapIfMissing();
        return this.shardSegmentDocMapForwards;
    }

    public int[] shardSegmentDocMapBackwards() {
        this.buildShardSegmentDocMapIfMissing();
        return this.shardSegmentDocMapBackwards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildShardSegmentDocMapIfMissing() {
        if (this.shardSegmentDocMapForwards != null) {
            return;
        }
        boolean success = false;
        long estimatedSize = this.sizeOfSegmentDocMap();
        this.blockFactory().adjustBreaker(estimatedSize);
        try {
            final int[] forwards = new int[this.shards.getPositionCount()];
            for (int p = 0; p < forwards.length; ++p) {
                forwards[p] = p;
            }
            if (this.singleSegment()) {
                new IntroSorter(){
                    int pivot;

                    protected void setPivot(int i) {
                        this.pivot = forwards[i];
                    }

                    protected int comparePivot(int j) {
                        return Integer.compare(DocVector.this.docs.getInt(this.pivot), DocVector.this.docs.getInt(forwards[j]));
                    }

                    protected void swap(int i, int j) {
                        int tmp = forwards[i];
                        forwards[i] = forwards[j];
                        forwards[j] = tmp;
                    }
                }.sort(0, forwards.length);
            } else {
                new IntroSorter(){
                    int pivot;

                    protected void setPivot(int i) {
                        this.pivot = forwards[i];
                    }

                    protected int comparePivot(int j) {
                        int cmp = Integer.compare(DocVector.this.shards.getInt(this.pivot), DocVector.this.shards.getInt(forwards[j]));
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = Integer.compare(DocVector.this.segments.getInt(this.pivot), DocVector.this.segments.getInt(forwards[j]));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return Integer.compare(DocVector.this.docs.getInt(this.pivot), DocVector.this.docs.getInt(forwards[j]));
                    }

                    protected void swap(int i, int j) {
                        int tmp = forwards[i];
                        forwards[i] = forwards[j];
                        forwards[j] = tmp;
                    }
                }.sort(0, forwards.length);
            }
            int[] backwards = new int[forwards.length];
            for (int p = 0; p < forwards.length; ++p) {
                backwards[forwards[p]] = p;
            }
            success = true;
            this.shardSegmentDocMapForwards = forwards;
            this.shardSegmentDocMapBackwards = backwards;
        }
        finally {
            if (!success) {
                this.blockFactory().adjustBreaker(-estimatedSize);
            }
        }
    }

    public static long sizeOfSegmentDocMap(int positionCount) {
        return 2L * ((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 4L * (long)positionCount);
    }

    private long sizeOfSegmentDocMap() {
        return DocVector.sizeOfSegmentDocMap(this.getPositionCount());
    }

    @Override
    public DocBlock asBlock() {
        return new DocBlock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocVector filter(int ... positions) {
        DocVector docVector;
        block3: {
            IntVector filteredShards = null;
            IntVector filteredSegments = null;
            IntVector filteredDocs = null;
            DocVector result = null;
            try {
                filteredShards = this.shards.filter(positions);
                filteredSegments = this.segments.filter(positions);
                filteredDocs = this.docs.filter(positions);
                docVector = result = new DocVector(this.refCounteds, filteredShards, filteredSegments, filteredDocs, null);
                if (result != null) break block3;
            }
            catch (Throwable throwable) {
                if (result == null) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{filteredShards, filteredSegments, filteredDocs});
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{filteredShards, filteredSegments, filteredDocs});
        }
        return docVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocVector deepCopy(BlockFactory blockFactory) {
        DocVector docVector;
        block3: {
            IntVector filteredShards = null;
            IntVector filteredSegments = null;
            IntVector filteredDocs = null;
            DocVector result = null;
            try {
                filteredShards = this.shards.deepCopy(blockFactory);
                filteredSegments = this.segments.deepCopy(blockFactory);
                filteredDocs = this.docs.deepCopy(blockFactory);
                docVector = result = new DocVector(this.refCounteds, filteredShards, filteredSegments, filteredDocs, null);
                if (result != null) break block3;
            }
            catch (Throwable throwable) {
                if (result == null) {
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{filteredShards, filteredSegments, filteredDocs});
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{filteredShards, filteredSegments, filteredDocs});
        }
        return docVector;
    }

    @Override
    public DocBlock keepMask(BooleanVector mask) {
        throw new UnsupportedOperationException("can't mask DocVector because it can't contain nulls");
    }

    @Override
    public ReleasableIterator<? extends Block> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("can't lookup values from DocVector");
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOC;
    }

    @Override
    public boolean isConstant() {
        return this.shards.isConstant() && this.segments.isConstant() && this.docs.isConstant();
    }

    public int hashCode() {
        return Objects.hash(this.shards, this.segments, this.docs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocVector)) {
            return false;
        }
        DocVector other = (DocVector)obj;
        return this.shards.equals(other.shards) && this.segments.equals(other.segments) && this.docs.equals(other.docs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DocVector[");
        sb.append("shards=").append(this.shards);
        sb.append(", segments=").append(this.segments);
        sb.append(", docs=").append(this.docs);
        sb.append(']');
        return sb.toString();
    }

    private static long ramBytesOrZero(int[] array) {
        return array == null ? 0L : RamUsageEstimator.shallowSizeOf((int[])array);
    }

    public static long ramBytesEstimated(IntVector shards, IntVector segments, IntVector docs, int[] shardSegmentDocMapForwards, int[] shardSegmentDocMapBackwards) {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((Accountable)shards) + RamUsageEstimator.sizeOf((Accountable)segments) + RamUsageEstimator.sizeOf((Accountable)docs) + DocVector.ramBytesOrZero(shardSegmentDocMapForwards) + DocVector.ramBytesOrZero(shardSegmentDocMapBackwards);
    }

    public long ramBytesUsed() {
        return DocVector.ramBytesEstimated(this.shards, this.segments, this.docs, this.shardSegmentDocMapForwards, this.shardSegmentDocMapBackwards);
    }

    @Override
    public void allowPassingToDifferentDriver() {
        super.allowPassingToDifferentDriver();
        this.shards.allowPassingToDifferentDriver();
        this.segments.allowPassingToDifferentDriver();
        this.docs.allowPassingToDifferentDriver();
    }

    @Override
    public void closeInternal() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> this.blockFactory().adjustBreaker(-BASE_RAM_BYTES_USED - (this.shardSegmentDocMapForwards == null ? 0L : this.sizeOfSegmentDocMap())), this.shards, this.segments, this.docs});
        this.forEachShardRefCounter(RefCounted::decRef);
    }

    private void forEachShardRefCounter(Consumer<RefCounted> consumer) {
        IntVector intVector = this.shards;
        Objects.requireNonNull(intVector);
        IntVector intVector2 = intVector;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantIntVector.class, ConstantNullVector.class}, (Object)intVector2, n)) {
            case 0: {
                ConstantIntVector constantIntVector = (ConstantIntVector)intVector2;
                consumer.accept(this.refCounteds.get(constantIntVector.getInt(0)));
                break;
            }
            case 1: {
                ConstantNullVector ignored = (ConstantNullVector)intVector2;
                break;
            }
            default: {
                for (int i = 0; i < this.shards.getPositionCount(); ++i) {
                    consumer.accept(this.refCounteds.get(this.shards.getInt(i)));
                }
            }
        }
    }
}

