/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentCartesianShapeSourceValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentCartesianShapeSourceValuesAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("minX", ElementType.INT), new IntermediateStateDesc("maxX", ElementType.INT), new IntermediateStateDesc("maxY", ElementType.INT), new IntermediateStateDesc("minY", ElementType.INT));
    private final DriverContext driverContext;
    private final SpatialExtentState state;
    private final List<Integer> channels;

    public SpatialExtentCartesianShapeSourceValuesAggregatorFunction(DriverContext driverContext, List<Integer> channels, SpatialExtentState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static SpatialExtentCartesianShapeSourceValuesAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new SpatialExtentCartesianShapeSourceValuesAggregatorFunction(driverContext, channels, SpatialExtentCartesianShapeSourceValuesAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        BytesRefBlock bytesBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector bytesVector = bytesBlock.asVector();
        if (bytesVector == null) {
            this.addRawBlock(bytesBlock, mask);
            return;
        }
        this.addRawVector(bytesVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        BytesRefBlock bytesBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        BytesRefVector bytesVector = bytesBlock.asVector();
        if (bytesVector == null) {
            this.addRawBlock(bytesBlock);
            return;
        }
        this.addRawVector(bytesVector);
    }

    private void addRawVector(BytesRefVector bytesVector) {
        BytesRef bytesScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < bytesVector.getPositionCount(); ++valuesPosition) {
            BytesRef bytesValue = bytesVector.getBytesRef(valuesPosition, bytesScratch);
            SpatialExtentCartesianShapeSourceValuesAggregator.combine(this.state, bytesValue);
        }
    }

    private void addRawVector(BytesRefVector bytesVector, BooleanVector mask) {
        BytesRef bytesScratch = new BytesRef();
        for (int valuesPosition = 0; valuesPosition < bytesVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            BytesRef bytesValue = bytesVector.getBytesRef(valuesPosition, bytesScratch);
            SpatialExtentCartesianShapeSourceValuesAggregator.combine(this.state, bytesValue);
        }
    }

    private void addRawBlock(BytesRefBlock bytesBlock) {
        BytesRef bytesScratch = new BytesRef();
        for (int p = 0; p < bytesBlock.getPositionCount(); ++p) {
            int bytesValueCount = bytesBlock.getValueCount(p);
            if (bytesValueCount == 0) continue;
            int bytesStart = bytesBlock.getFirstValueIndex(p);
            int bytesEnd = bytesStart + bytesValueCount;
            for (int bytesOffset = bytesStart; bytesOffset < bytesEnd; ++bytesOffset) {
                BytesRef bytesValue = bytesBlock.getBytesRef(bytesOffset, bytesScratch);
                SpatialExtentCartesianShapeSourceValuesAggregator.combine(this.state, bytesValue);
            }
        }
    }

    private void addRawBlock(BytesRefBlock bytesBlock, BooleanVector mask) {
        BytesRef bytesScratch = new BytesRef();
        for (int p = 0; p < bytesBlock.getPositionCount(); ++p) {
            int bytesValueCount;
            if (!mask.getBoolean(p) || (bytesValueCount = bytesBlock.getValueCount(p)) == 0) continue;
            int bytesStart = bytesBlock.getFirstValueIndex(p);
            int bytesEnd = bytesStart + bytesValueCount;
            for (int bytesOffset = bytesStart; bytesOffset < bytesEnd; ++bytesOffset) {
                BytesRef bytesValue = bytesBlock.getBytesRef(bytesOffset, bytesScratch);
                SpatialExtentCartesianShapeSourceValuesAggregator.combine(this.state, bytesValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + SpatialExtentCartesianShapeSourceValuesAggregatorFunction.intermediateStateDesc().size());
        Object minXUncast = page.getBlock(this.channels.get(0));
        if (minXUncast.areAllValuesNull()) {
            return;
        }
        IntVector minX = ((IntBlock)minXUncast).asVector();
        assert (minX.getPositionCount() == 1);
        Object maxXUncast = page.getBlock(this.channels.get(1));
        if (maxXUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxX = ((IntBlock)maxXUncast).asVector();
        assert (maxX.getPositionCount() == 1);
        Object maxYUncast = page.getBlock(this.channels.get(2));
        if (maxYUncast.areAllValuesNull()) {
            return;
        }
        IntVector maxY = ((IntBlock)maxYUncast).asVector();
        assert (maxY.getPositionCount() == 1);
        Object minYUncast = page.getBlock(this.channels.get(3));
        if (minYUncast.areAllValuesNull()) {
            return;
        }
        IntVector minY = ((IntBlock)minYUncast).asVector();
        assert (minY.getPositionCount() == 1);
        SpatialExtentCartesianShapeSourceValuesAggregator.combineIntermediate(this.state, minX.getInt(0), maxX.getInt(0), maxY.getInt(0), minY.getInt(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = SpatialExtentCartesianShapeSourceValuesAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

