/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopFloatFloatAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopFloatFloatAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.FLOAT), new IntermediateStateDesc("output", ElementType.FLOAT));
    private final DriverContext driverContext;
    private final TopFloatFloatAggregator.SingleState state;
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopFloatFloatAggregatorFunction(DriverContext driverContext, List<Integer> channels, TopFloatFloatAggregator.SingleState state, int limit, boolean ascending) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
        this.limit = limit;
        this.ascending = ascending;
    }

    public static TopFloatFloatAggregatorFunction create(DriverContext driverContext, List<Integer> channels, int limit, boolean ascending) {
        return new TopFloatFloatAggregatorFunction(driverContext, channels, TopFloatFloatAggregator.initSingle(driverContext.bigArrays(), limit, ascending), limit, ascending);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        FloatBlock vBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatBlock outputValueBlock = (FloatBlock)page.getBlock(this.channels.get(1));
        FloatVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, outputValueBlock, mask);
            return;
        }
        FloatVector outputValueVector = outputValueBlock.asVector();
        if (outputValueVector == null) {
            this.addRawBlock(vBlock, outputValueBlock, mask);
            return;
        }
        this.addRawVector(vVector, outputValueVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        FloatBlock vBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatBlock outputValueBlock = (FloatBlock)page.getBlock(this.channels.get(1));
        FloatVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, outputValueBlock);
            return;
        }
        FloatVector outputValueVector = outputValueBlock.asVector();
        if (outputValueVector == null) {
            this.addRawBlock(vBlock, outputValueBlock);
            return;
        }
        this.addRawVector(vVector, outputValueVector);
    }

    private void addRawVector(FloatVector vVector, FloatVector outputValueVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            float vValue = vVector.getFloat(valuesPosition);
            float outputValueValue = outputValueVector.getFloat(valuesPosition);
            TopFloatFloatAggregator.combine(this.state, vValue, outputValueValue);
        }
    }

    private void addRawVector(FloatVector vVector, FloatVector outputValueVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            float vValue = vVector.getFloat(valuesPosition);
            float outputValueValue = outputValueVector.getFloat(valuesPosition);
            TopFloatFloatAggregator.combine(this.state, vValue, outputValueValue);
        }
    }

    private void addRawBlock(FloatBlock vBlock, FloatBlock outputValueBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int outputValueValueCount;
            int vValueCount = vBlock.getValueCount(p);
            if (vValueCount == 0 || (outputValueValueCount = outputValueBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                float vValue = vBlock.getFloat(vOffset);
                int outputValueStart = outputValueBlock.getFirstValueIndex(p);
                int outputValueEnd = outputValueStart + outputValueValueCount;
                for (int outputValueOffset = outputValueStart; outputValueOffset < outputValueEnd; ++outputValueOffset) {
                    float outputValueValue = outputValueBlock.getFloat(outputValueOffset);
                    TopFloatFloatAggregator.combine(this.state, vValue, outputValueValue);
                }
            }
        }
    }

    private void addRawBlock(FloatBlock vBlock, FloatBlock outputValueBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int outputValueValueCount;
            int vValueCount;
            if (!mask.getBoolean(p) || (vValueCount = vBlock.getValueCount(p)) == 0 || (outputValueValueCount = outputValueBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                float vValue = vBlock.getFloat(vOffset);
                int outputValueStart = outputValueBlock.getFirstValueIndex(p);
                int outputValueEnd = outputValueStart + outputValueValueCount;
                for (int outputValueOffset = outputValueStart; outputValueOffset < outputValueEnd; ++outputValueOffset) {
                    float outputValueValue = outputValueBlock.getFloat(outputValueOffset);
                    TopFloatFloatAggregator.combine(this.state, vValue, outputValueValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + TopFloatFloatAggregatorFunction.intermediateStateDesc().size());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        FloatBlock top = (FloatBlock)topUncast;
        assert (top.getPositionCount() == 1);
        Object outputUncast = page.getBlock(this.channels.get(1));
        if (outputUncast.areAllValuesNull()) {
            return;
        }
        FloatBlock output = (FloatBlock)outputUncast;
        assert (output.getPositionCount() == 1);
        TopFloatFloatAggregator.combineIntermediate(this.state, top, output);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = TopFloatFloatAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

