/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.function.DoubleBinaryOperator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.aggregation.AggregatorState;
import org.elasticsearch.compute.aggregation.GroupingAggregatorState;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.TDigestBlockBuilder;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;

public final class TDigestStates {
    private static final TDigestExecutionHint EXECUTION_HINT = TDigestExecutionHint.DEFAULT;
    public static final double COMPRESSION = 100.0;

    private TDigestStates() {
    }

    private static double nanAwareAgg(double v1, double v2, DoubleBinaryOperator op) {
        if (Double.isNaN(v1)) {
            return v2;
        }
        if (Double.isNaN(v2)) {
            return v1;
        }
        return op.applyAsDouble(v1, v2);
    }

    static final class GroupingState
    implements GroupingAggregatorState {
        private ObjectArray<TDigestState> states;
        private DoubleArray minima;
        private DoubleArray maxima;
        private DoubleArray sums;
        private LongArray counts;
        private final CircuitBreaker breaker;
        private final BigArrays bigArrays;

        GroupingState(BigArrays bigArrays, CircuitBreaker breaker) {
            this.states = bigArrays.newObjectArray(1L);
            this.minima = bigArrays.newDoubleArray(1L);
            this.maxima = bigArrays.newDoubleArray(1L);
            this.sums = bigArrays.newDoubleArray(1L);
            this.counts = bigArrays.newLongArray(1L);
            this.bigArrays = bigArrays;
            this.breaker = breaker;
        }

        TDigestState getOrNull(int position) {
            if ((long)position < this.states.size()) {
                return (TDigestState)this.states.get((long)position);
            }
            return null;
        }

        public void add(int groupId, TDigestHolder histogram) {
            long count;
            double sum;
            double max;
            double min;
            if (histogram == null) {
                return;
            }
            this.ensureCapacity(groupId);
            TDigestState state = (TDigestState)this.states.get((long)groupId);
            if (state == null) {
                state = TDigestState.create((CircuitBreaker)this.breaker, (double)100.0, (TDigestExecutionHint)EXECUTION_HINT);
                this.states.set((long)groupId, (Object)state);
                min = Double.NaN;
                max = Double.NaN;
                sum = Double.NaN;
                count = 0L;
            } else {
                min = this.minima.get((long)groupId);
                max = this.maxima.get((long)groupId);
                sum = this.sums.get((long)groupId);
                count = this.counts.get((long)groupId);
            }
            histogram.addTo(state);
            this.minima.set((long)groupId, TDigestStates.nanAwareAgg(min, histogram.getMin(), Double::min));
            this.maxima.set((long)groupId, TDigestStates.nanAwareAgg(max, histogram.getMax(), Double::max));
            this.sums.set((long)groupId, TDigestStates.nanAwareAgg(sum, histogram.getSum(), Double::sum));
            this.counts.set((long)groupId, count + histogram.getValueCount());
        }

        private void ensureCapacity(int groupId) {
            this.states = this.bigArrays.grow(this.states, (long)(groupId + 1));
            this.minima = this.bigArrays.grow(this.minima, (long)(groupId + 1));
            this.maxima = this.bigArrays.grow(this.maxima, (long)(groupId + 1));
            this.sums = this.bigArrays.grow(this.sums, (long)(groupId + 1));
            this.counts = this.bigArrays.grow(this.counts, (long)(groupId + 1));
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            assert (blocks.length >= offset + 2) : "blocks=" + blocks.length + ",offset=" + offset;
            try (TDigestBlockBuilder histoBuilder = driverContext.blockFactory().newTDigestBlockBuilder(selected.getPositionCount());
                 BooleanBlock.Builder seenBuilder = driverContext.blockFactory().newBooleanBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    TDigestState state = this.getOrNull(groupId);
                    if (state != null) {
                        seenBuilder.appendBoolean(true);
                        histoBuilder.appendTDigest(new TDigestHolder(state, this.minima.get((long)groupId), this.maxima.get((long)groupId), this.sums.get((long)groupId), this.counts.get((long)groupId)));
                        continue;
                    }
                    seenBuilder.appendBoolean(false);
                    histoBuilder.appendTDigest(TDigestHolder.empty());
                }
                blocks[offset] = histoBuilder.build();
                blocks[offset + 1] = seenBuilder.build();
            }
        }

        public Block evaluateFinal(IntVector selected, DriverContext driverContext) {
            try (TDigestBlockBuilder histoBuilder = driverContext.blockFactory().newTDigestBlockBuilder(selected.getPositionCount());){
                for (int i = 0; i < selected.getPositionCount(); ++i) {
                    int groupId = selected.getInt(i);
                    TDigestState state = this.getOrNull(groupId);
                    if (state != null) {
                        histoBuilder.appendTDigest(new TDigestHolder(state, this.minima.get((long)groupId), this.maxima.get((long)groupId), this.sums.get((long)groupId), this.counts.get((long)groupId)));
                        continue;
                    }
                    histoBuilder.appendNull();
                }
                TDigestBlock tDigestBlock = histoBuilder.build();
                return tDigestBlock;
            }
        }

        public void close() {
            int i = 0;
            while ((long)i < this.states.size()) {
                Releasables.close((Releasable)((Releasable)this.states.get((long)i)));
                ++i;
            }
            Releasables.close((Releasable[])new Releasable[]{this.states, this.minima, this.maxima, this.sums, this.counts});
            this.states = null;
        }

        @Override
        public void enableGroupIdTracking(SeenGroupIds seenGroupIds) {
        }
    }

    static final class SingleState
    implements AggregatorState {
        private final CircuitBreaker breaker;
        private TDigestState merger;
        double sum = Double.NaN;
        double min = Double.NaN;
        double max = Double.NaN;
        long count = 0L;

        SingleState(CircuitBreaker breaker) {
            this.breaker = breaker;
        }

        public void add(TDigestHolder histogram) {
            if (histogram == null) {
                return;
            }
            if (this.merger == null) {
                this.merger = TDigestState.create((CircuitBreaker)this.breaker, (double)100.0, (TDigestExecutionHint)EXECUTION_HINT);
            }
            histogram.addTo(this.merger);
            this.sum = TDigestStates.nanAwareAgg(histogram.getSum(), this.sum, Double::sum);
            this.count += histogram.getValueCount();
            this.min = TDigestStates.nanAwareAgg(histogram.getMin(), this.min, Double::min);
            this.max = TDigestStates.nanAwareAgg(histogram.getMax(), this.max, Double::max);
        }

        @Override
        public void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            assert (blocks.length >= offset + 2);
            BlockFactory blockFactory = driverContext.blockFactory();
            if (this.merger == null) {
                blocks[offset] = blockFactory.newConstantTDigestBlock(TDigestHolder.empty(), 1);
                blocks[offset + 1] = blockFactory.newConstantBooleanBlockWith(false, 1);
            } else {
                TDigestHolder resultHolder = new TDigestHolder(this.merger, this.min, this.max, this.sum, this.count);
                blocks[offset] = blockFactory.newConstantTDigestBlock(resultHolder, 1);
                blocks[offset + 1] = blockFactory.newConstantBooleanBlockWith(true, 1);
            }
        }

        public void close() {
            Releasables.close((Releasable)this.merger);
            this.merger = null;
        }

        public Block evaluateFinal(DriverContext driverContext) {
            BlockFactory blockFactory = driverContext.blockFactory();
            if (this.merger == null) {
                return blockFactory.newConstantNullBlock(1);
            }
            TDigestHolder resultHolder = new TDigestHolder(this.merger, this.min, this.max, this.sum, this.count);
            return blockFactory.newConstantTDigestBlock(resultHolder, 1);
        }
    }
}

