/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.BooleanState;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.MaxBooleanAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MaxBooleanAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("max", ElementType.BOOLEAN), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final BooleanState state;
    private final List<Integer> channels;

    public MaxBooleanAggregatorFunction(DriverContext driverContext, List<Integer> channels, BooleanState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MaxBooleanAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MaxBooleanAggregatorFunction(driverContext, channels, new BooleanState(MaxBooleanAggregator.init()));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        BooleanBlock vBlock = (BooleanBlock)page.getBlock(this.channels.get(0));
        BooleanVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, mask);
            return;
        }
        this.addRawVector(vVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        BooleanBlock vBlock = (BooleanBlock)page.getBlock(this.channels.get(0));
        BooleanVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock);
            return;
        }
        this.addRawVector(vVector);
    }

    private void addRawVector(BooleanVector vVector) {
        this.state.seen(true);
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            boolean vValue = vVector.getBoolean(valuesPosition);
            this.state.booleanValue(MaxBooleanAggregator.combine(this.state.booleanValue(), vValue));
        }
    }

    private void addRawVector(BooleanVector vVector, BooleanVector mask) {
        this.state.seen(true);
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            boolean vValue = vVector.getBoolean(valuesPosition);
            this.state.booleanValue(MaxBooleanAggregator.combine(this.state.booleanValue(), vValue));
        }
    }

    private void addRawBlock(BooleanBlock vBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount = vBlock.getValueCount(p);
            if (vValueCount == 0) continue;
            this.state.seen(true);
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                boolean vValue = vBlock.getBoolean(vOffset);
                this.state.booleanValue(MaxBooleanAggregator.combine(this.state.booleanValue(), vValue));
            }
        }
    }

    private void addRawBlock(BooleanBlock vBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount;
            if (!mask.getBoolean(p) || (vValueCount = vBlock.getValueCount(p)) == 0) continue;
            this.state.seen(true);
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                boolean vValue = vBlock.getBoolean(vOffset);
                this.state.booleanValue(MaxBooleanAggregator.combine(this.state.booleanValue(), vValue));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MaxBooleanAggregatorFunction.intermediateStateDesc().size());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector max = ((BooleanBlock)maxUncast).asVector();
        assert (max.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        if (seen.getBoolean(0)) {
            this.state.booleanValue(MaxBooleanAggregator.combine(this.state.booleanValue(), max.getBoolean(0)));
            this.state.seen(true);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = driverContext.blockFactory().newConstantBooleanBlockWith(this.state.booleanValue(), 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

