/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.HistogramMergeTDigestAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.TDigestStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.compute.operator.DriverContext;

public final class HistogramMergeTDigestGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("value", ElementType.TDIGEST), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final TDigestStates.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public HistogramMergeTDigestGroupingAggregatorFunction(List<Integer> channels, TDigestStates.GroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static HistogramMergeTDigestGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new HistogramMergeTDigestGroupingAggregatorFunction(channels, HistogramMergeTDigestAggregator.initGrouping(driverContext.bigArrays(), driverContext), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final TDigestBlock valueBlock = (TDigestBlock)page.getBlock(this.channels.get(0));
        this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock);
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                HistogramMergeTDigestGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                HistogramMergeTDigestGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                HistogramMergeTDigestGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, TDigestBlock valueBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    TDigestHolder valueValue = valueBlock.getTDigestHolder(valueOffset);
                    HistogramMergeTDigestAggregator.combine(this.state, groupId, valueValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        TDigestBlock value = (TDigestBlock)valueUncast;
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (value.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                HistogramMergeTDigestAggregator.combineIntermediate(this.state, groupId, value.getTDigestHolder(value.getFirstValueIndex(valuesPosition)), seen.getBoolean(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, TDigestBlock valueBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    TDigestHolder valueValue = valueBlock.getTDigestHolder(valueOffset);
                    HistogramMergeTDigestAggregator.combine(this.state, groupId, valueValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        TDigestBlock value = (TDigestBlock)valueUncast;
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (value.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                HistogramMergeTDigestAggregator.combineIntermediate(this.state, groupId, value.getTDigestHolder(value.getFirstValueIndex(valuesPosition)), seen.getBoolean(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, TDigestBlock valueBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (valueBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
            int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                TDigestHolder valueValue = valueBlock.getTDigestHolder(valueOffset);
                HistogramMergeTDigestAggregator.combine(this.state, groupId, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        TDigestBlock value = (TDigestBlock)valueUncast;
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (value.getPositionCount() == seen.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            HistogramMergeTDigestAggregator.combineIntermediate(this.state, groupId, value.getTDigestHolder(value.getFirstValueIndex(valuesPosition)), seen.getBoolean(valuesPosition));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, TDigestBlock valueBlock) {
        if (valueBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = HistogramMergeTDigestAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

