/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.HistogramMergeTDigestAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TDigestStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.TDigestBlock;
import org.elasticsearch.compute.data.TDigestHolder;
import org.elasticsearch.compute.operator.DriverContext;

public final class HistogramMergeTDigestAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("value", ElementType.TDIGEST), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final TDigestStates.SingleState state;
    private final List<Integer> channels;

    public HistogramMergeTDigestAggregatorFunction(DriverContext driverContext, List<Integer> channels, TDigestStates.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static HistogramMergeTDigestAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new HistogramMergeTDigestAggregatorFunction(driverContext, channels, HistogramMergeTDigestAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        TDigestBlock valueBlock = (TDigestBlock)page.getBlock(this.channels.get(0));
        this.addRawBlock(valueBlock, mask);
    }

    private void addRawInputNotMasked(Page page) {
        TDigestBlock valueBlock = (TDigestBlock)page.getBlock(this.channels.get(0));
        this.addRawBlock(valueBlock);
    }

    private void addRawBlock(TDigestBlock valueBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int valueValueCount = valueBlock.getValueCount(p);
            if (valueValueCount == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                TDigestHolder valueValue = valueBlock.getTDigestHolder(valueOffset);
                HistogramMergeTDigestAggregator.combine(this.state, valueValue);
            }
        }
    }

    private void addRawBlock(TDigestBlock valueBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            int valueValueCount;
            if (!mask.getBoolean(p) || (valueValueCount = valueBlock.getValueCount(p)) == 0) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueValueCount;
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                TDigestHolder valueValue = valueBlock.getTDigestHolder(valueOffset);
                HistogramMergeTDigestAggregator.combine(this.state, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + HistogramMergeTDigestAggregatorFunction.intermediateStateDesc().size());
        Object valueUncast = page.getBlock(this.channels.get(0));
        if (valueUncast.areAllValuesNull()) {
            return;
        }
        TDigestBlock value = (TDigestBlock)valueUncast;
        assert (value.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        HistogramMergeTDigestAggregator.combineIntermediate(this.state, value.getTDigestHolder(value.getFirstValueIndex(0)), seen.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = HistogramMergeTDigestAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

