/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AllLastDoubleByTimestampAggregator;
import org.elasticsearch.compute.aggregation.AllLongDoubleState;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class AllLastDoubleByTimestampAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.DOUBLE), new IntermediateStateDesc("seen", ElementType.BOOLEAN), new IntermediateStateDesc("hasValue", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final AllLongDoubleState state;
    private final List<Integer> channels;

    public AllLastDoubleByTimestampAggregatorFunction(DriverContext driverContext, List<Integer> channels, AllLongDoubleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static AllLastDoubleByTimestampAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new AllLastDoubleByTimestampAggregatorFunction(driverContext, channels, AllLastDoubleByTimestampAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        DoubleBlock valueBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        this.addRawBlock(valueBlock, timestampBlock, mask);
    }

    private void addRawInputNotMasked(Page page) {
        DoubleBlock valueBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        this.addRawBlock(valueBlock, timestampBlock);
    }

    private void addRawBlock(DoubleBlock valueBlock, LongBlock timestampBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            AllLastDoubleByTimestampAggregator.combine(this.state, p, valueBlock, timestampBlock);
        }
    }

    private void addRawBlock(DoubleBlock valueBlock, LongBlock timestampBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p)) continue;
            AllLastDoubleByTimestampAggregator.combine(this.state, p, valueBlock, timestampBlock);
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + AllLastDoubleByTimestampAggregatorFunction.intermediateStateDesc().size());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongVector timestamps = ((LongBlock)timestampsUncast).asVector();
        assert (timestamps.getPositionCount() == 1);
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector values = ((DoubleBlock)valuesUncast).asVector();
        assert (values.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(2));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        Object hasValueUncast = page.getBlock(this.channels.get(3));
        if (hasValueUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector hasValue = ((BooleanBlock)hasValueUncast).asVector();
        assert (hasValue.getPositionCount() == 1);
        AllLastDoubleByTimestampAggregator.combineIntermediate(this.state, timestamps.getLong(0), values.getDouble(0), seen.getBoolean(0), hasValue.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = AllLastDoubleByTimestampAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

