/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.Weight;

public abstract class DenseVectorQuery
extends Query {
    protected final String field;

    public DenseVectorQuery(String field) {
        this.field = field;
    }

    public void visit(QueryVisitor queryVisitor) {
        queryVisitor.visitLeaf((Query)this);
    }

    static class DenseVectorScorer
    extends Scorer {
        private final VectorScorer vectorScorer;
        private final DocIdSetIterator iterator;
        private final float boost;

        DenseVectorScorer(VectorScorer vectorScorer, float boost) {
            this.vectorScorer = vectorScorer;
            this.iterator = vectorScorer.iterator();
            this.boost = boost;
        }

        public DocIdSetIterator iterator() {
            return this.vectorScorer.iterator();
        }

        public float getMaxScore(int i) throws IOException {
            return Float.POSITIVE_INFINITY;
        }

        public float score() throws IOException {
            assert (this.iterator.docID() != -1);
            return this.vectorScorer.score() * this.boost;
        }

        public int docID() {
            return this.iterator.docID();
        }
    }

    public static class Bytes
    extends DenseVectorQuery {
        private final byte[] query;

        public Bytes(byte[] query, String field) {
            super(field);
            this.query = query;
        }

        public String toString(String field) {
            return "DenseVectorQuery.Bytes";
        }

        public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            return new DenseVectorWeight(this, boost){

                @Override
                VectorScorer vectorScorer(LeafReaderContext leafReaderContext) throws IOException {
                    ByteVectorValues vectorValues = leafReaderContext.reader().getByteVectorValues(field);
                    if (vectorValues == null) {
                        return null;
                    }
                    return vectorValues.scorer(query);
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Bytes bytes = (Bytes)((Object)o);
            return Objects.equals(this.field, bytes.field) && Objects.deepEquals(this.query, bytes.query);
        }

        public int hashCode() {
            return Objects.hash(this.field, Arrays.hashCode(this.query));
        }
    }

    public static class Floats
    extends DenseVectorQuery {
        private final float[] query;

        public Floats(float[] query, String field) {
            super(field);
            this.query = query;
        }

        public float[] getQuery() {
            return this.query;
        }

        public String toString(String field) {
            return "DenseVectorQuery.Floats";
        }

        public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
            return new DenseVectorWeight(this, boost){

                @Override
                VectorScorer vectorScorer(LeafReaderContext leafReaderContext) throws IOException {
                    FloatVectorValues vectorValues = leafReaderContext.reader().getFloatVectorValues(field);
                    if (vectorValues == null) {
                        return null;
                    }
                    return vectorValues.scorer(query);
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Floats floats = (Floats)((Object)o);
            return Objects.equals(this.field, floats.field) && Objects.deepEquals(this.query, floats.query);
        }

        public int hashCode() {
            return Objects.hash(this.field, Arrays.hashCode(this.query));
        }
    }

    static abstract class DenseVectorWeight
    extends Weight {
        private final String field;
        private final float boost;

        protected DenseVectorWeight(DenseVectorQuery query, float boost) {
            super((Query)query);
            this.field = query.field;
            this.boost = boost;
        }

        abstract VectorScorer vectorScorer(LeafReaderContext var1) throws IOException;

        public Explanation explain(LeafReaderContext leafReaderContext, int i) throws IOException {
            VectorScorer vectorScorer = this.vectorScorer(leafReaderContext);
            if (vectorScorer == null) {
                return Explanation.noMatch((String)("No vector values found for field: " + this.field), (Explanation[])new Explanation[0]);
            }
            DocIdSetIterator iterator = vectorScorer.iterator();
            iterator.advance(i);
            if (iterator.docID() == i) {
                float score = vectorScorer.score();
                return Explanation.match((Number)Float.valueOf(vectorScorer.score() * this.boost), (String)("found vector with calculated similarity: " + score), (Explanation[])new Explanation[0]);
            }
            return Explanation.noMatch((String)("Document not found in vector values for field: " + this.field), (Explanation[])new Explanation[0]);
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            VectorScorer vectorScorer = this.vectorScorer(context);
            if (vectorScorer == null) {
                return null;
            }
            return new Weight.DefaultScorerSupplier((Scorer)new DenseVectorScorer(vectorScorer, this.boost));
        }

        public boolean isCacheable(LeafReaderContext leafReaderContext) {
            return true;
        }
    }
}

