/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.slice;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.slice.DocIdSliceQuery;
import org.elasticsearch.search.slice.DocValuesSliceQuery;
import org.elasticsearch.search.slice.TermsSliceQuery;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SliceBuilder
implements Writeable,
ToXContentObject {
    private static final MatchNoDocsQuery NOT_PART_OF_SLICE = new MatchNoDocsQuery("this shard is not part of the slice");
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField ID_FIELD = new ParseField("id", new String[0]);
    private static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ObjectParser<SliceBuilder, Void> PARSER = new ObjectParser("slice", SliceBuilder::new);
    @Nullable
    private String field;
    private int id = -1;
    private int max = -1;

    private SliceBuilder() {
    }

    public SliceBuilder(int id, int max) {
        this(null, id, max);
    }

    public SliceBuilder(String field, int id, int max) {
        this.setField(field);
        this.setId(id);
        this.setMax(max);
    }

    public SliceBuilder(StreamInput in) throws IOException {
        this.field = in.readOptionalString();
        this.id = in.readVInt();
        this.max = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.field);
        out.writeVInt(this.id);
        out.writeVInt(this.max);
    }

    private SliceBuilder setField(String field) {
        this.field = field;
        return this;
    }

    public String getField() {
        return this.field;
    }

    private SliceBuilder setId(int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be greater than or equal to 0");
        }
        if (this.max != -1 && id >= this.max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    private SliceBuilder setMax(int max) {
        if (max <= 1) {
            throw new IllegalArgumentException("max must be greater than 1");
        }
        if (this.id != -1 && this.id >= max) {
            throw new IllegalArgumentException("max must be greater than id");
        }
        this.max = max;
        return this;
    }

    public int getMax() {
        return this.max;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.innerToXContent(builder);
        builder.endObject();
        return builder;
    }

    void innerToXContent(XContentBuilder builder) throws IOException {
        if (this.field != null) {
            builder.field(FIELD_FIELD.getPreferredName(), this.field);
        }
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.field(MAX_FIELD.getPreferredName(), this.max);
    }

    public static SliceBuilder fromXContent(XContentParser parser) throws IOException {
        SliceBuilder builder = (SliceBuilder)PARSER.parse(parser, (Object)new SliceBuilder(), null);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliceBuilder that = (SliceBuilder)o;
        return this.id == that.id && this.max == that.max && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.id, this.max);
    }

    public Query toFilter(ShardSearchRequest request, SearchExecutionContext context) {
        boolean isScroll;
        int shardIndex = request.shardRequestIndex() != -1 ? request.shardRequestIndex() : request.shardId().id();
        int numShards = request.shardRequestIndex() != -1 ? request.numberOfShards() : context.getIndexSettings().getNumberOfShards();
        boolean bl = isScroll = request.scroll() != null;
        if (numShards == 1) {
            return this.createSliceQuery(this.id, this.max, context, isScroll);
        }
        if (this.max >= numShards) {
            int targetShard = this.id % numShards;
            if (targetShard != shardIndex) {
                return NOT_PART_OF_SLICE;
            }
            int numSlicesInShard = this.max / numShards;
            int rest = this.max % numShards;
            if (rest > targetShard) {
                ++numSlicesInShard;
            }
            if (numSlicesInShard == 1) {
                return Queries.ALL_DOCS_INSTANCE;
            }
            int shardSlice = this.id / numShards;
            return this.createSliceQuery(shardSlice, numSlicesInShard, context, isScroll);
        }
        int targetSlice = shardIndex % this.max;
        if (this.id != targetSlice) {
            return NOT_PART_OF_SLICE;
        }
        return Queries.ALL_DOCS_INSTANCE;
    }

    private Query createSliceQuery(int id, int max, SearchExecutionContext context, boolean isScroll) {
        if (this.field == null) {
            return isScroll ? new TermsSliceQuery("_id", id, max) : new DocIdSliceQuery(id, max);
        }
        if ("_id".equals(this.field)) {
            if (!isScroll) {
                throw new IllegalArgumentException("cannot slice on [_id] when using [point-in-time]");
            }
            return new TermsSliceQuery("_id", id, max);
        }
        MappedFieldType type = context.getFieldType(this.field);
        if (type == null) {
            throw new IllegalArgumentException("field " + this.field + " not found");
        }
        if (!type.hasDocValues()) {
            throw new IllegalArgumentException("cannot load numeric doc values on " + this.field);
        }
        Object ifm = context.getForField(type, MappedFieldType.FielddataOperation.SEARCH);
        if (!(ifm instanceof IndexNumericFieldData)) {
            throw new IllegalArgumentException("cannot load numeric doc values on " + this.field);
        }
        return new DocValuesSliceQuery(this.field, id, max);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    static {
        PARSER.declareString(SliceBuilder::setField, FIELD_FIELD);
        PARSER.declareInt(SliceBuilder::setId, ID_FIELD);
        PARSER.declareInt(SliceBuilder::setMax, MAX_FIELD);
    }
}

