/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.diversification;

import org.elasticsearch.search.diversification.ResultDiversification;
import org.elasticsearch.search.diversification.ResultDiversificationContext;
import org.elasticsearch.search.diversification.ResultDiversificationType;
import org.elasticsearch.search.diversification.mmr.MMRResultDiversification;
import org.elasticsearch.search.diversification.mmr.MMRResultDiversificationContext;

public final class ResultDiversificationFactory {
    public static ResultDiversification<?> getDiversifier(ResultDiversificationType diversificationType, ResultDiversificationContext diversificationContext) {
        if (diversificationType == null) {
            throw new IllegalArgumentException("diversification type cannot be null");
        }
        if (diversificationType == ResultDiversificationType.MMR) {
            if (diversificationContext instanceof MMRResultDiversificationContext) {
                MMRResultDiversificationContext mmrResultDiversificationContext = (MMRResultDiversificationContext)diversificationContext;
                return new MMRResultDiversification(mmrResultDiversificationContext);
            }
            throw new IllegalArgumentException("context must be an MMRResultDiversificationContext if using MMR");
        }
        throw new IllegalArgumentException("unsupported diversification type [" + String.valueOf((Object)diversificationType) + "]");
    }
}

