/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramBuilder;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramMerger;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramQuantile;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;
import org.elasticsearch.tdigest.Centroid;

public class ExponentialHistogramState
implements Releasable,
Accountable {
    static final int MAX_HISTOGRAM_BUCKETS = 320;
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ExponentialHistogramState.class);
    private static final byte EMPTY_HISTOGRAM_MARKER_SCALE = -128;
    private boolean closed = false;
    private final CircuitBreaker circuitBreaker;
    private ReleasableExponentialHistogram deserializedHistogram;
    private ExponentialHistogramMerger mergedHistograms;

    public static ExponentialHistogramState create(CircuitBreaker circuitBreaker) {
        return ExponentialHistogramState.create(circuitBreaker, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ExponentialHistogramState create(CircuitBreaker circuitBreaker, ReleasableExponentialHistogram deserializedHistogram) {
        boolean success = false;
        try {
            circuitBreaker.addEstimateBytesAndMaybeBreak(SHALLOW_SIZE, "exponential-histogram-state");
            success = true;
            ExponentialHistogramState exponentialHistogramState = new ExponentialHistogramState(circuitBreaker, deserializedHistogram);
            return exponentialHistogramState;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)deserializedHistogram);
            }
        }
    }

    private ExponentialHistogramState(CircuitBreaker circuitBreaker, ReleasableExponentialHistogram deserializedHistogram) {
        this.circuitBreaker = circuitBreaker;
        this.deserializedHistogram = deserializedHistogram;
    }

    ExponentialHistogram histogram() {
        if (this.mergedHistograms != null) {
            return this.mergedHistograms.get();
        }
        if (this.deserializedHistogram != null) {
            return this.deserializedHistogram;
        }
        return ExponentialHistogram.empty();
    }

    public boolean isEmpty() {
        return this.mergedHistograms == null && this.deserializedHistogram == null;
    }

    public void add(ExponentialHistogram histogram) {
        if (this.mergedHistograms == null) {
            if (this.deserializedHistogram == null) {
                this.mergedHistograms = ExponentialHistogramMerger.create((int)320, (ExponentialHistogramCircuitBreaker)new ElasticCircuitBreakerWrapper(this.circuitBreaker));
            } else {
                this.mergedHistograms = ExponentialHistogramMerger.createWithMaxScale((int)320, (int)this.deserializedHistogram.scale(), (ExponentialHistogramCircuitBreaker)new ElasticCircuitBreakerWrapper(this.circuitBreaker));
                this.mergedHistograms.add((ExponentialHistogram)this.deserializedHistogram);
                this.deserializedHistogram.close();
                this.deserializedHistogram = null;
            }
        }
        this.mergedHistograms.add(histogram);
    }

    public long size() {
        return this.histogram().valueCount();
    }

    public double cdf(double x) {
        ExponentialHistogram histogram = this.histogram();
        long numValuesLess = ExponentialHistogramQuantile.estimateRank((ExponentialHistogram)histogram, (double)x, (boolean)false);
        long numValuesLessOrEqual = ExponentialHistogramQuantile.estimateRank((ExponentialHistogram)histogram, (double)x, (boolean)true);
        long numValuesEqual = numValuesLessOrEqual - numValuesLess;
        return ((double)numValuesLess + (double)numValuesEqual / 2.0) / (double)histogram.valueCount();
    }

    public double quantile(double q) {
        return ExponentialHistogramQuantile.getQuantile((ExponentialHistogram)this.histogram(), (double)q);
    }

    public Collection<Centroid> centroids() {
        ArrayList<Centroid> centroids = new ArrayList<Centroid>(this.centroidCount());
        this.addBucketCentersAsCentroids(centroids, (BucketIterator)this.histogram().negativeBuckets().iterator(), -1);
        Collections.reverse(centroids);
        if (this.histogram().zeroBucket().count() > 0L) {
            centroids.add(new Centroid(0.0, this.histogram().zeroBucket().count()));
        }
        this.addBucketCentersAsCentroids(centroids, (BucketIterator)this.histogram().positiveBuckets().iterator(), 1);
        return centroids;
    }

    private void addBucketCentersAsCentroids(List<Centroid> result, BucketIterator buckets, int sign) {
        while (buckets.hasNext()) {
            double center = (double)sign * ExponentialScaleUtils.getPointOfLeastRelativeError((long)buckets.peekIndex(), (int)buckets.scale());
            long count = buckets.peekCount();
            result.add(new Centroid(center, count));
            buckets.advance();
        }
    }

    public int centroidCount() {
        ExponentialHistogram histo = this.histogram();
        int count = histo.zeroBucket().count() > 0L ? 1 : 0;
        count += histo.negativeBuckets().bucketCount();
        return count += histo.positiveBuckets().bucketCount();
    }

    public double getMin() {
        double min = this.histogram().min();
        return Double.isNaN(min) ? Double.POSITIVE_INFINITY : min;
    }

    public double getMax() {
        double max = this.histogram().max();
        return Double.isNaN(max) ? Double.NEGATIVE_INFINITY : max;
    }

    public void write(StreamOutput out) throws IOException {
        if (this.isEmpty()) {
            out.writeByte((byte)-128);
        } else {
            ExponentialHistogram histogram = this.histogram();
            out.writeByte((byte)histogram.scale());
            out.writeDouble(histogram.min());
            out.writeDouble(histogram.max());
            out.writeDouble(histogram.sum());
            ExponentialHistogramState.writeZeroBucket(out, histogram.zeroBucket());
            out.writeVInt(histogram.negativeBuckets().bucketCount());
            out.writeVInt(histogram.positiveBuckets().bucketCount());
            ExponentialHistogramState.writeBuckets(out, histogram.negativeBuckets());
            ExponentialHistogramState.writeBuckets(out, histogram.positiveBuckets());
        }
    }

    private static void writeZeroBucket(StreamOutput out, ZeroBucket zb) throws IOException {
        out.writeVLong(zb.count());
        boolean zeroThresholdIndexBased = zb.isIndexBased();
        out.writeBoolean(zeroThresholdIndexBased);
        if (zeroThresholdIndexBased) {
            out.writeByte((byte)zb.scale());
            out.writeZLong(zb.index());
        } else {
            out.writeDouble(zb.zeroThreshold());
        }
    }

    private static void writeBuckets(StreamOutput out, ExponentialHistogram.Buckets buckets) throws IOException {
        CopyableBucketIterator bucketIterator = buckets.iterator();
        if (bucketIterator.hasNext()) {
            long index = bucketIterator.peekIndex();
            out.writeZLong(index);
            out.writeVLong(bucketIterator.peekCount());
            bucketIterator.advance();
            long previousIndex = index;
            while (bucketIterator.hasNext()) {
                index = bucketIterator.peekIndex();
                long delta = index - previousIndex;
                assert (delta > 0L);
                if (delta > 1L) {
                    out.writeZLong(-delta);
                }
                out.writeZLong(bucketIterator.peekCount());
                previousIndex = index;
                bucketIterator.advance();
            }
        }
    }

    public static ExponentialHistogramState read(CircuitBreaker breaker, StreamInput in) throws IOException {
        ElasticCircuitBreakerWrapper histoBreaker = new ElasticCircuitBreakerWrapper(breaker);
        byte scale = in.readByte();
        if (scale == -128) {
            return ExponentialHistogramState.create(breaker);
        }
        try (ExponentialHistogramBuilder builder = ExponentialHistogram.builder((int)scale, (ExponentialHistogramCircuitBreaker)histoBreaker);){
            builder.min(in.readDouble());
            builder.max(in.readDouble());
            builder.sum(in.readDouble());
            builder.zeroBucket(ExponentialHistogramState.readZeroBucket(in));
            int negativeBucketCount = in.readVInt();
            int positiveBucketCount = in.readVInt();
            builder.estimatedBucketCount(negativeBucketCount + positiveBucketCount);
            ExponentialHistogramState.readBuckets(in, negativeBucketCount, false, builder);
            ExponentialHistogramState.readBuckets(in, positiveBucketCount, true, builder);
            ExponentialHistogramState exponentialHistogramState = ExponentialHistogramState.create(breaker, builder.build());
            return exponentialHistogramState;
        }
    }

    private static void readBuckets(StreamInput in, int bucketCount, boolean positive, ExponentialHistogramBuilder builder) throws IOException {
        if (bucketCount > 0) {
            long index = in.readZLong();
            long count = in.readVLong();
            if (positive) {
                builder.setPositiveBucket(index, count);
            } else {
                builder.setNegativeBucket(index, count);
            }
            for (int i = 1; i < bucketCount; ++i) {
                long deltaOrCount = in.readZLong();
                if (deltaOrCount < 0L) {
                    index += -deltaOrCount;
                    count = in.readZLong();
                } else {
                    ++index;
                    count = deltaOrCount;
                }
                if (positive) {
                    builder.setPositiveBucket(index, count);
                    continue;
                }
                builder.setNegativeBucket(index, count);
            }
        }
    }

    private static ZeroBucket readZeroBucket(StreamInput in) throws IOException {
        long count = in.readVLong();
        boolean zeroThresholdIndexBased = in.readBoolean();
        if (zeroThresholdIndexBased) {
            byte scale = in.readByte();
            long index = in.readZLong();
            return ZeroBucket.create((long)index, (int)scale, (long)count);
        }
        double zeroThreshold = in.readDouble();
        return ZeroBucket.create((double)zeroThreshold, (long)count);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExponentialHistogramState)) {
            return false;
        }
        ExponentialHistogramState that = (ExponentialHistogramState)obj;
        if (this == that) {
            return true;
        }
        return this.histogram().equals((Object)that.histogram());
    }

    public int hashCode() {
        return this.histogram().hashCode();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.circuitBreaker.addWithoutBreaking(-SHALLOW_SIZE);
            Releasables.close((Releasable[])new Releasable[]{this.mergedHistograms, this.deserializedHistogram});
        }
    }

    public long ramBytesUsed() {
        long bytes = SHALLOW_SIZE;
        if (this.mergedHistograms != null) {
            bytes += this.mergedHistograms.ramBytesUsed();
        }
        if (this.deserializedHistogram != null) {
            bytes += this.deserializedHistogram.ramBytesUsed();
        }
        return bytes;
    }

    private static class ElasticCircuitBreakerWrapper
    implements ExponentialHistogramCircuitBreaker {
        private final CircuitBreaker breaker;

        ElasticCircuitBreakerWrapper(CircuitBreaker breaker) {
            this.breaker = breaker;
        }

        public void adjustBreaker(long bytesAllocated) {
            if (bytesAllocated > 0L) {
                this.breaker.addEstimateBytesAndMaybeBreak(bytesAllocated, "exponential-histogram");
            } else {
                this.breaker.addWithoutBreaking(bytesAllocated);
            }
        }
    }
}

