/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.packed.PackedLongValues;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;

public class BestBucketsDeferringCollector
extends DeferringBucketCollector {
    private final Query topLevelQuery;
    private final IndexSearcher searcher;
    private final boolean isGlobal;
    private List<Entry> entries = new ArrayList<Entry>();
    private BucketCollector collector;
    private AggregationExecutionContext aggCtx;
    private PackedLongValues.Builder docDeltasBuilder;
    private PackedLongValues.Builder bucketsBuilder;
    private LongHash selectedBuckets;
    private boolean finished = false;

    public BestBucketsDeferringCollector(Query topLevelQuery, IndexSearcher searcher, boolean isGlobal) {
        this.topLevelQuery = topLevelQuery;
        this.searcher = searcher;
        this.isGlobal = isGlobal;
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.collector == null) {
            throw new IllegalStateException();
        }
        return this.collector.scoreMode();
    }

    @Override
    public void setDeferredCollector(Iterable<BucketCollector> deferredCollectors) {
        this.collector = MultiBucketCollector.wrap(true, deferredCollectors);
    }

    private void finishLeaf() {
        if (this.aggCtx != null) {
            assert (this.docDeltasBuilder != null && this.bucketsBuilder != null);
            assert (this.docDeltasBuilder.size() > 0L);
            this.entries.add(new Entry(this.aggCtx, this.docDeltasBuilder.build(), this.bucketsBuilder.build()));
            this.clearLeaf();
        }
    }

    private void clearLeaf() {
        this.aggCtx = null;
        this.docDeltasBuilder = null;
        this.bucketsBuilder = null;
    }

    @Override
    public LeafBucketCollector getLeafCollector(final AggregationExecutionContext context) throws IOException {
        this.finishLeaf();
        return new LeafBucketCollector(){
            int lastDoc = 0;

            @Override
            public void collect(int doc, long bucket) {
                if (BestBucketsDeferringCollector.this.aggCtx == null) {
                    BestBucketsDeferringCollector.this.aggCtx = context;
                    BestBucketsDeferringCollector.this.docDeltasBuilder = PackedLongValues.packedBuilder((float)0.25f);
                    BestBucketsDeferringCollector.this.bucketsBuilder = PackedLongValues.packedBuilder((float)0.25f);
                }
                BestBucketsDeferringCollector.this.docDeltasBuilder.add((long)(doc - this.lastDoc));
                BestBucketsDeferringCollector.this.bucketsBuilder.add(bucket);
                this.lastDoc = doc;
            }
        };
    }

    @Override
    public void preCollection() throws IOException {
        this.collector.preCollection();
    }

    @Override
    public void postCollection() throws IOException {
        this.finishLeaf();
        this.finished = true;
    }

    @Override
    public void prepareSelectedBuckets(LongArray selectedBuckets) throws IOException {
        if (!this.finished) {
            throw new IllegalStateException("Cannot replay yet, collection is not finished: postCollect() has not been called");
        }
        if (this.selectedBuckets != null) {
            throw new IllegalStateException("Already been replayed");
        }
        this.selectedBuckets = new LongHash(selectedBuckets.size(), BigArrays.NON_RECYCLING_INSTANCE);
        for (long i = 0L; i < selectedBuckets.size(); ++i) {
            this.selectedBuckets.add(selectedBuckets.get(i));
        }
        boolean needsScores = this.scoreMode().needsScores();
        Weight weight = null;
        if (needsScores) {
            MatchAllDocsQuery query = this.isGlobal ? Queries.ALL_DOCS_INSTANCE : this.topLevelQuery;
            weight = this.searcher.createWeight(this.searcher.rewrite((Query)query), ScoreMode.COMPLETE, 1.0f);
        }
        for (Entry entry : this.entries) {
            assert (entry.docDeltas.size() > 0L) : "segment should have at least one document to replay, got 0";
            try {
                LeafBucketCollector leafCollector = this.collector.getLeafCollector(entry.aggCtx);
                DocIdSetIterator scoreIt = null;
                if (needsScores) {
                    Scorer scorer = weight.scorer(entry.aggCtx.getLeafReaderContext());
                    if (scorer == null) {
                        BestBucketsDeferringCollector.failInCaseOfBadScorer("no scores are available");
                    }
                    scoreIt = scorer.iterator();
                    leafCollector.setScorer((Scorable)scorer);
                }
                PackedLongValues.Iterator docDeltaIterator = entry.docDeltas.iterator();
                PackedLongValues.Iterator buckets = entry.buckets.iterator();
                int doc = 0;
                long end = entry.docDeltas.size();
                for (long i = 0L; i < end; ++i) {
                    doc += (int)docDeltaIterator.next();
                    long bucket = buckets.next();
                    long rebasedBucket = this.selectedBuckets.find(bucket);
                    if (rebasedBucket == -1L) continue;
                    if (needsScores) {
                        if (scoreIt.docID() < doc) {
                            scoreIt.advance(doc);
                        }
                        if (scoreIt.docID() != doc) {
                            BestBucketsDeferringCollector.failInCaseOfBadScorer("score for different docid");
                        }
                    }
                    leafCollector.collect(doc, rebasedBucket);
                }
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
                // empty catch block
            }
            entry.buckets = null;
            entry.docDeltas = null;
        }
        this.collector.postCollection();
    }

    private static void failInCaseOfBadScorer(String message) {
        String likelyExplanation = "nesting an aggregation under a children aggregation and terms aggregation with collect mode breadth_first isn't possible";
        throw new RuntimeException(message + ", " + likelyExplanation);
    }

    @Override
    public Aggregator wrap(final Aggregator in, final BigArrays bigArrays) {
        return new DeferringBucketCollector.WrappedAggregator(in){

            @Override
            public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
                if (BestBucketsDeferringCollector.this.selectedBuckets == null) {
                    throw new IllegalStateException("Collection has not been replayed yet.");
                }
                try (LongArray rebasedOrds = bigArrays.newLongArray(owningBucketOrds.size());){
                    for (long ordIdx = 0L; ordIdx < owningBucketOrds.size(); ++ordIdx) {
                        rebasedOrds.set(ordIdx, BestBucketsDeferringCollector.this.selectedBuckets.find(owningBucketOrds.get(ordIdx)));
                        if (rebasedOrds.get(ordIdx) != -1L) continue;
                        throw new IllegalStateException("Cannot build for a bucket which has not been collected");
                    }
                    InternalAggregation[] internalAggregationArray = in.buildAggregations(rebasedOrds);
                    return internalAggregationArray;
                }
            }
        };
    }

    public void rewriteBuckets(LongUnaryOperator howToRewrite) {
        PackedLongValues.Builder newBuckets;
        PackedLongValues.Iterator docDeltasItr;
        ArrayList<Entry> newEntries = new ArrayList<Entry>(this.entries.size());
        for (Entry sourceEntry : this.entries) {
            PackedLongValues.Builder newDocDeltas = PackedLongValues.packedBuilder((float)0.25f);
            newBuckets = BestBucketsDeferringCollector.merge(howToRewrite, newDocDeltas, docDeltasItr = sourceEntry.docDeltas.iterator(), sourceEntry.buckets);
            if (newBuckets.size() <= 0L) continue;
            assert (newDocDeltas.size() > 0L) : "docDeltas was empty but we had buckets";
            newEntries.add(new Entry(sourceEntry.aggCtx, newDocDeltas.build(), newBuckets.build()));
        }
        this.entries = newEntries;
        if (this.bucketsBuilder != null && this.bucketsBuilder.size() > 0L) {
            PackedLongValues currentBuckets = this.bucketsBuilder.build();
            PackedLongValues.Builder newDocDeltas = PackedLongValues.packedBuilder((float)0.25f);
            PackedLongValues currentDeltas = this.docDeltasBuilder.build();
            docDeltasItr = currentDeltas.iterator();
            newBuckets = BestBucketsDeferringCollector.merge(howToRewrite, newDocDeltas, docDeltasItr, currentBuckets);
            if (newDocDeltas.size() == 0L) {
                this.clearLeaf();
            } else {
                this.docDeltasBuilder = newDocDeltas;
                this.bucketsBuilder = newBuckets;
            }
        }
    }

    private static PackedLongValues.Builder merge(LongUnaryOperator howToRewrite, PackedLongValues.Builder newDocDeltas, PackedLongValues.Iterator docDeltasItr, PackedLongValues currentBuckets) {
        PackedLongValues.Builder newBuckets = PackedLongValues.packedBuilder((float)0.25f);
        long lastGoodDelta = 0L;
        for (long bucket : currentBuckets) {
            assert (docDeltasItr.hasNext());
            long delta = docDeltasItr.next();
            long ordinal = howToRewrite.applyAsLong(bucket);
            if (ordinal != -1L) {
                newBuckets.add(ordinal);
                newDocDeltas.add(delta + lastGoodDelta);
                lastGoodDelta = 0L;
                continue;
            }
            lastGoodDelta += delta;
        }
        return newBuckets;
    }

    private static class Entry {
        AggregationExecutionContext aggCtx;
        PackedLongValues docDeltas;
        PackedLongValues buckets;

        Entry(AggregationExecutionContext aggCtx, PackedLongValues docDeltas, PackedLongValues buckets) {
            this.aggCtx = Objects.requireNonNull(aggCtx);
            this.docDeltas = Objects.requireNonNull(docDeltas);
            this.buckets = Objects.requireNonNull(buckets);
        }
    }
}

