/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Iterator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.codec.vectors.BFloat16;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.RankVectorsScriptDocValues;
import org.elasticsearch.script.field.vectors.FloatRankVectors;
import org.elasticsearch.script.field.vectors.RankVectors;
import org.elasticsearch.script.field.vectors.RankVectorsDocValuesField;
import org.elasticsearch.script.field.vectors.VectorIterator;

public class BFloat16RankVectorsDocValuesField
extends RankVectorsDocValuesField {
    private final BinaryDocValues input;
    private final BinaryDocValues magnitudes;
    private boolean decoded;
    private final int dims;
    private BytesRef value;
    private BytesRef magnitudesValue;
    private BFloat16VectorIterator vectorValues;
    private int numVectors;
    private float[] buffer;

    public BFloat16RankVectorsDocValuesField(BinaryDocValues input, BinaryDocValues magnitudes, String name, DenseVectorFieldMapper.ElementType elementType, int dims) {
        super(name, elementType);
        this.input = input;
        this.magnitudes = magnitudes;
        this.dims = dims;
        this.buffer = new float[dims];
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        this.decoded = false;
        if (this.input.advanceExact(docId)) {
            boolean magnitudesFound = this.magnitudes.advanceExact(docId);
            assert (magnitudesFound);
            this.value = this.input.binaryValue();
            assert (this.value.length % (2 * this.dims) == 0);
            this.numVectors = this.value.length / (2 * this.dims);
            this.magnitudesValue = this.magnitudes.binaryValue();
            assert (this.magnitudesValue.length == 4 * this.numVectors);
        } else {
            this.value = null;
            this.magnitudesValue = null;
            this.numVectors = 0;
        }
    }

    @Override
    public RankVectorsScriptDocValues toScriptDocValues() {
        return new RankVectorsScriptDocValues(this, this.dims);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public RankVectors get() {
        if (this.isEmpty()) {
            return RankVectors.EMPTY;
        }
        this.decodeVectorIfNecessary();
        return new FloatRankVectors(this.vectorValues, this.magnitudesValue, this.numVectors, this.dims);
    }

    @Override
    public RankVectors get(RankVectors defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        this.decodeVectorIfNecessary();
        return new FloatRankVectors(this.vectorValues, this.magnitudesValue, this.numVectors, this.dims);
    }

    @Override
    public RankVectors getInternal() {
        return this.get(null);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : this.value.length / (2 * this.dims);
    }

    private void decodeVectorIfNecessary() {
        if (!this.decoded && this.value != null) {
            this.vectorValues = new BFloat16VectorIterator(this.value, this.buffer, this.numVectors);
            this.decoded = true;
        }
    }

    public static class BFloat16VectorIterator
    implements VectorIterator<float[]> {
        private final float[] buffer;
        private final ShortBuffer vectorValues;
        private final BytesRef vectorValueBytesRef;
        private final int size;
        private int idx = 0;

        public BFloat16VectorIterator(BytesRef vectorValues, float[] buffer, int size) {
            assert (vectorValues.length == buffer.length * 2 * size);
            this.vectorValueBytesRef = vectorValues;
            this.vectorValues = ByteBuffer.wrap(vectorValues.bytes, vectorValues.offset, vectorValues.length).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.size;
        }

        @Override
        public float[] next() {
            if (!this.hasNext()) {
                throw new IllegalArgumentException("No more elements in the iterator");
            }
            BFloat16.bFloat16ToFloat(this.vectorValues, this.buffer);
            ++this.idx;
            return this.buffer;
        }

        @Override
        public Iterator<float[]> copy() {
            return new BFloat16VectorIterator(this.vectorValueBytesRef, new float[this.buffer.length], this.size);
        }

        @Override
        public void reset() {
            this.idx = 0;
            this.vectorValues.rewind();
        }
    }
}

