/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.MultiValuedSortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.StringFieldScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class SortedBinaryDocValuesStringFieldScript
extends StringFieldScript {
    private final SortedBinaryDocValues sortedBinaryDocValues;
    boolean hasValue = false;

    public SortedBinaryDocValuesStringFieldScript(String fieldName, SearchLookup searchLookup, LeafReaderContext ctx) {
        super(fieldName, Map.of(), searchLookup, OnScriptError.FAIL, ctx);
        try {
            BinaryDocValues binaryDocValues = DocValues.getBinary((LeafReader)ctx.reader(), (String)fieldName);
            this.sortedBinaryDocValues = new MultiValuedSortedBinaryDocValues(binaryDocValues);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public void setDocument(int docID) {
        try {
            this.hasValue = this.sortedBinaryDocValues.advanceExact(docID);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public void execute() {
        try {
            if (this.hasValue) {
                for (int i = 0; i < this.sortedBinaryDocValues.docValueCount(); ++i) {
                    BytesRef bytesRef = this.sortedBinaryDocValues.nextValue();
                    this.emit(bytesRef.utf8ToString());
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }
}

