/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public record ReservedStateVersion(Long version, BuildVersion buildVersion) implements Writeable
{
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField COMPATIBILITY = new ParseField("compatibility", new String[0]);
    private static final ConstructingObjectParser<ReservedStateVersion, Void> PARSER = new ConstructingObjectParser("reserved_cluster_state_version_metadata", a -> {
        Long updateId = Long.parseLong((String)a[0]);
        BuildVersion minCompatVersion = BuildVersion.fromString((String)a[1]);
        return new ReservedStateVersion(updateId, minCompatVersion);
    });

    public static ReservedStateVersion parse(XContentParser parser) {
        return (ReservedStateVersion)PARSER.apply(parser, null);
    }

    public static ReservedStateVersion readFrom(StreamInput input) throws IOException {
        return new ReservedStateVersion(input.readLong(), BuildVersion.fromStream(input));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        this.buildVersion.writeTo(out);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), COMPATIBILITY);
    }
}

