/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.queries;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.blockloader.docvalues.CustomBinaryDocValuesReader;

public final class SlowCustomBinaryDocValuesTermQuery
extends Query {
    private final String fieldName;
    private final BytesRef term;

    public SlowCustomBinaryDocValuesTermQuery(String fieldName, BytesRef term) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.term = Objects.requireNonNull(term);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final BinaryDocValues values = context.reader().getBinaryDocValues(SlowCustomBinaryDocValuesTermQuery.this.fieldName);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)values){
                    final CustomBinaryDocValuesReader reader;
                    {
                        super(arg0);
                        this.reader = new CustomBinaryDocValuesReader();
                    }

                    public boolean matches() throws IOException {
                        BytesRef binaryValue = values.binaryValue();
                        return this.reader.match(binaryValue, arg_0 -> ((BytesRef)SlowCustomBinaryDocValuesTermQuery.this.term).equals(arg_0));
                    }

                    public float matchCost() {
                        return 10.0f;
                    }
                };
                return new Weight.DefaultScorerSupplier((Scorer)new ConstantScoreScorer(this.score(), scoreMode, iterator));
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{SlowCustomBinaryDocValuesTermQuery.this.fieldName});
            }
        };
    }

    public String toString(String field) {
        return "SlowCustomBinaryDocValuesTermQuery(fieldName=" + field + ",term=" + this.term.utf8ToString() + ")";
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.sameClassAs(o)) {
            return false;
        }
        SlowCustomBinaryDocValuesTermQuery that = (SlowCustomBinaryDocValuesTermQuery)((Object)o);
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.term, that.term);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.fieldName, this.term);
    }
}

