/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestPipelineFieldAccessPattern;
import org.elasticsearch.ingest.IngestPipelineMetric;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;

public class Pipeline {
    public static final String DESCRIPTION_KEY = "description";
    public static final String PROCESSORS_KEY = "processors";
    public static final String VERSION_KEY = "version";
    public static final String ON_FAILURE_KEY = "on_failure";
    public static final String META_KEY = "_meta";
    public static final String FIELD_ACCESS_PATTERN = "field_access_pattern";
    public static final String DEPRECATED_KEY = "deprecated";
    public static final String CREATED_DATE_MILLIS = "created_date_millis";
    public static final String CREATED_DATE = "created_date";
    public static final String MODIFIED_DATE_MILLIS = "modified_date_millis";
    public static final String MODIFIED_DATE = "modified_date";
    private final String id;
    @Nullable
    private final String description;
    @Nullable
    private final Integer version;
    @Nullable
    private final Map<String, Object> metadata;
    private final CompoundProcessor compoundProcessor;
    private final IngestPipelineMetric metrics;
    private final LongSupplier relativeTimeProvider;
    private final IngestPipelineFieldAccessPattern fieldAccessPattern;
    @Nullable
    private final Boolean deprecated;
    @Nullable
    private final Long createdDateMillis;
    @Nullable
    private final Long modifiedDateMillis;

    public Pipeline(String id, @Nullable String description, @Nullable Integer version, @Nullable Map<String, Object> metadata, CompoundProcessor compoundProcessor) {
        this(id, description, version, metadata, compoundProcessor, IngestPipelineFieldAccessPattern.CLASSIC, null, null, null);
    }

    public Pipeline(String id, @Nullable String description, @Nullable Integer version, @Nullable Map<String, Object> metadata, CompoundProcessor compoundProcessor, IngestPipelineFieldAccessPattern fieldAccessPattern, @Nullable Boolean deprecated, @Nullable Long createdDateMillis, @Nullable Long modifiedDateMillis) {
        this(id, description, version, metadata, compoundProcessor, System::nanoTime, fieldAccessPattern, deprecated, createdDateMillis, modifiedDateMillis);
    }

    Pipeline(String id, @Nullable String description, @Nullable Integer version, @Nullable Map<String, Object> metadata, CompoundProcessor compoundProcessor, LongSupplier relativeTimeProvider, IngestPipelineFieldAccessPattern fieldAccessPattern, @Nullable Boolean deprecated, @Nullable Long createdDateMillis, @Nullable Long modifiedDateMillis) {
        this.id = id;
        this.description = description;
        this.metadata = metadata;
        this.compoundProcessor = compoundProcessor;
        this.version = version;
        this.metrics = new IngestPipelineMetric();
        this.relativeTimeProvider = relativeTimeProvider;
        this.fieldAccessPattern = fieldAccessPattern;
        this.deprecated = deprecated;
        this.createdDateMillis = createdDateMillis;
        this.modifiedDateMillis = modifiedDateMillis;
    }

    @Deprecated
    public static Pipeline create(String id, Map<String, Object> config, Map<String, Processor.Factory> processorFactories, ScriptService scriptService, ProjectId projectId) throws Exception {
        return Pipeline.create(id, config, processorFactories, scriptService, projectId, IngestService::locallySupportedIngestFeature);
    }

    public static Pipeline create(String id, Map<String, Object> config, Map<String, Processor.Factory> processorFactories, ScriptService scriptService, ProjectId projectId, Predicate<NodeFeature> hasFeature) throws Exception {
        String description = ConfigurationUtils.readOptionalStringProperty(null, null, config, DESCRIPTION_KEY);
        Integer version = ConfigurationUtils.readIntProperty(null, null, config, VERSION_KEY, null);
        Map<String, Object> metadata = ConfigurationUtils.readOptionalMap(null, null, config, META_KEY);
        Boolean deprecated = ConfigurationUtils.readOptionalBooleanProperty(null, null, config, DEPRECATED_KEY);
        String fieldAccessPatternRaw = ConfigurationUtils.readOptionalStringProperty(null, null, config, FIELD_ACCESS_PATTERN);
        if (fieldAccessPatternRaw != null && !hasFeature.test(IngestService.FIELD_ACCESS_PATTERN)) {
            throw new ElasticsearchParseException("pipeline [" + id + "] doesn't support one or more provided configuration parameters [field_access_pattern]", new Object[0]);
        }
        if (fieldAccessPatternRaw != null && !IngestPipelineFieldAccessPattern.isValidAccessPattern(fieldAccessPatternRaw)) {
            throw new ElasticsearchParseException("pipeline [" + id + "] doesn't support value of [" + fieldAccessPatternRaw + "] for parameter [field_access_pattern]", new Object[0]);
        }
        IngestPipelineFieldAccessPattern accessPattern = fieldAccessPatternRaw == null ? IngestPipelineFieldAccessPattern.CLASSIC : IngestPipelineFieldAccessPattern.getAccessPattern(fieldAccessPatternRaw);
        List<Map<String, Object>> processorConfigs = ConfigurationUtils.readList(null, null, config, PROCESSORS_KEY);
        List<Processor> processors = ConfigurationUtils.readProcessorConfigs(processorConfigs, scriptService, processorFactories, projectId);
        List<Map<String, Object>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, ON_FAILURE_KEY);
        List<Processor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, scriptService, processorFactories, projectId);
        String createdDate = ConfigurationUtils.readOptionalStringOrLongProperty(null, null, config, CREATED_DATE_MILLIS);
        String modifiedDate = ConfigurationUtils.readOptionalStringOrLongProperty(null, null, config, MODIFIED_DATE_MILLIS);
        if (!config.isEmpty()) {
            throw new ElasticsearchParseException("pipeline [" + id + "] doesn't support one or more provided configuration parameters " + Arrays.toString(config.keySet().toArray()), new Object[0]);
        }
        if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
            throw new ElasticsearchParseException("pipeline [" + id + "] cannot have an empty on_failure option defined", new Object[0]);
        }
        CompoundProcessor compoundProcessor = new CompoundProcessor(false, processors, onFailureProcessors);
        Long createdDateMillis = createdDate == null ? null : Long.valueOf(createdDate);
        Long modifiedDateMillis = modifiedDate == null ? null : Long.valueOf(modifiedDate);
        return new Pipeline(id, description, version, metadata, compoundProcessor, accessPattern, deprecated, createdDateMillis, modifiedDateMillis);
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        long startTimeInNanos = this.relativeTimeProvider.getAsLong();
        this.metrics.preIngest();
        this.compoundProcessor.execute(ingestDocument, (result, e) -> {
            long ingestTimeInNanos = this.relativeTimeProvider.getAsLong() - startTimeInNanos;
            this.metrics.postIngest(ingestTimeInNanos);
            if (e != null) {
                this.metrics.ingestFailed();
            }
            ingestDocument.resetTerminate();
            handler.accept((IngestDocument)result, (Exception)e);
        });
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public CompoundProcessor getCompoundProcessor() {
        return this.compoundProcessor;
    }

    public List<Processor> getProcessors() {
        return this.compoundProcessor.getProcessors();
    }

    public List<Processor> getOnFailureProcessors() {
        return this.compoundProcessor.getOnFailureProcessors();
    }

    public List<Processor> flattenAllProcessors() {
        return this.compoundProcessor.flattenProcessors();
    }

    public IngestPipelineMetric getMetrics() {
        return this.metrics;
    }

    public IngestPipelineFieldAccessPattern getFieldAccessPattern() {
        return this.fieldAccessPattern;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    public Optional<Long> getCreatedDateMillis() {
        return Optional.ofNullable(this.createdDateMillis);
    }

    public Optional<Long> getModifiedDateMillis() {
        return Optional.ofNullable(this.modifiedDateMillis);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Pipeline{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", version=").append(this.version);
        sb.append(", metadata=").append(this.metadata);
        sb.append(", compoundProcessor=").append(this.compoundProcessor);
        sb.append(", metrics=").append(this.metrics);
        sb.append(", relativeTimeProvider=").append(this.relativeTimeProvider);
        sb.append(", fieldAccessPattern=").append((Object)this.fieldAccessPattern);
        sb.append(", deprecated=").append(this.deprecated);
        sb.append(", createdDateMillis='").append(this.createdDateMillis).append('\'');
        sb.append(", modifiedDateMillis='").append(this.modifiedDateMillis).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

