/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.QueryRewriteAsyncAction;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;

public abstract class QueryRewriteRemoteAsyncAction<T, U extends QueryRewriteRemoteAsyncAction<T, U>>
extends QueryRewriteAsyncAction<T, U> {
    private final String clusterAlias;

    public QueryRewriteRemoteAsyncAction(String clusterAlias) {
        this.clusterAlias = Objects.requireNonNull(clusterAlias);
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    @Override
    protected final void execute(Client client, ActionListener<T> listener) {
        ThreadPool threadPool = client.threadPool();
        RemoteClusterClient remoteClient = client.getRemoteClusterClient(this.clusterAlias, threadPool.executor("search_coordination"), RemoteClusterService.DisconnectedStrategy.RECONNECT_UNLESS_SKIP_UNAVAILABLE);
        ThreadContext threadContext = threadPool.getThreadContext();
        this.execute(remoteClient, threadContext, listener);
    }

    protected abstract void execute(RemoteClusterClient var1, ThreadContext var2, ActionListener<T> var3);

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clusterAlias);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            QueryRewriteRemoteAsyncAction other = (QueryRewriteRemoteAsyncAction)obj;
            equals = Objects.equals(this.clusterAlias, other.clusterAlias);
        }
        return equals;
    }
}

