/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;

public abstract class AbstractBytesRefsFromOrdsBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    protected final String fieldName;

    public AbstractBytesRefsFromOrdsBlockLoader(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public final BlockLoader.BytesRefBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.bytesRefs(expectedCount);
    }

    @Override
    public final BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        SortedSetDocValues docValues = context.reader().getSortedSetDocValues(this.fieldName);
        if (docValues != null) {
            SortedDocValues singleton = DocValues.unwrapSingleton((SortedSetDocValues)docValues);
            if (singleton != null) {
                return this.singletonReader(singleton);
            }
            return this.sortedSetReader(docValues);
        }
        SortedDocValues singleton = context.reader().getSortedDocValues(this.fieldName);
        if (singleton != null) {
            return this.singletonReader(singleton);
        }
        return new BlockLoader.ConstantNullsReader();
    }

    protected abstract BlockLoader.AllReader singletonReader(SortedDocValues var1);

    protected abstract BlockLoader.AllReader sortedSetReader(SortedSetDocValues var1);

    protected static class SortedSet
    extends BlockDocValuesReader {
        private final SortedSetDocValues ordinals;

        SortedSet(SortedSetDocValues ordinals) {
            this.ordinals = ordinals;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            if (docs.count() - offset == 1) {
                return this.readSingleDoc(factory, docs.get(offset));
            }
            try (BlockLoader.SortedSetOrdinalsBuilder builder = factory.sortedSetOrdinalsBuilder(this.ordinals, docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (doc < this.ordinals.docID()) {
                        throw new IllegalStateException("docs within same block must be in order");
                    }
                    if (!this.ordinals.advanceExact(doc)) {
                        builder.appendNull();
                        continue;
                    }
                    int count = this.ordinals.docValueCount();
                    if (count == 1) {
                        builder.appendOrd(Math.toIntExact(this.ordinals.nextOrd()));
                        continue;
                    }
                    builder.beginPositionEntry();
                    for (int c = 0; c < count; ++c) {
                        builder.appendOrd(Math.toIntExact(this.ordinals.nextOrd()));
                    }
                    builder.endPositionEntry();
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.BytesRefBuilder)builder);
        }

        private BlockLoader.Block readSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                return factory.constantNulls(1);
            }
            int count = this.ordinals.docValueCount();
            if (count == 1) {
                BytesRef v = this.ordinals.lookupOrd(this.ordinals.nextOrd());
                return factory.constantBytes(BytesRef.deepCopyOf((BytesRef)v), 1);
            }
            try (BlockLoader.BytesRefBuilder builder = factory.bytesRefsFromDocValues(count);){
                builder.beginPositionEntry();
                for (int c = 0; c < count; ++c) {
                    BytesRef v = this.ordinals.lookupOrd(this.ordinals.nextOrd());
                    builder.appendBytesRef(v);
                }
                builder.endPositionEntry();
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        private void read(int docId, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.ordinals.advanceExact(docId)) {
                builder.appendNull();
                return;
            }
            int count = this.ordinals.docValueCount();
            if (count == 1) {
                builder.appendBytesRef(this.ordinals.lookupOrd(this.ordinals.nextOrd()));
                return;
            }
            builder.beginPositionEntry();
            for (int v = 0; v < count; ++v) {
                builder.appendBytesRef(this.ordinals.lookupOrd(this.ordinals.nextOrd()));
            }
            builder.endPositionEntry();
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "BytesRefsFromOrds.SortedSet";
        }
    }

    protected static class Singleton
    extends BlockDocValuesReader {
        private final SortedDocValues ordinals;

        public Singleton(SortedDocValues ordinals) {
            this.ordinals = ordinals;
        }

        private BlockLoader.Block readSingleDoc(BlockLoader.BlockFactory factory, int docId) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                BytesRef v = this.ordinals.lookupOrd(this.ordinals.ordValue());
                return factory.constantBytes(BytesRef.deepCopyOf((BytesRef)v), 1);
            }
            return factory.constantNulls(1);
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            BlockLoader.OptionalColumnAtATimeReader direct;
            BlockLoader.Block block;
            if (docs.count() - offset == 1) {
                return this.readSingleDoc(factory, docs.get(offset));
            }
            SortedDocValues sortedDocValues = this.ordinals;
            if (sortedDocValues instanceof BlockLoader.OptionalColumnAtATimeReader && (block = (direct = (BlockLoader.OptionalColumnAtATimeReader)sortedDocValues).tryRead(factory, docs, offset, nullsFiltered, null, false, false)) != null) {
                return block;
            }
            try (BlockLoader.SingletonOrdinalsBuilder builder = factory.singletonOrdinalsBuilder(this.ordinals, docs.count() - offset, false);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    if (this.ordinals.advanceExact(doc)) {
                        builder.appendOrd(this.ordinals.ordValue());
                        continue;
                    }
                    builder.appendNull();
                }
                BlockLoader.Block block2 = builder.build();
                return block2;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            if (this.ordinals.advanceExact(docId)) {
                ((BlockLoader.BytesRefBuilder)builder).appendBytesRef(this.ordinals.lookupOrd(this.ordinals.ordValue()));
            } else {
                builder.appendNull();
            }
        }

        @Override
        public int docId() {
            return this.ordinals.docID();
        }

        @Override
        public String toString() {
            return "BytesRefsFromOrds.Singleton";
        }
    }
}

