/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.time.ZoneId;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.fielddata.DoubleScriptFieldData;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DoubleScriptBlockDocValuesReader;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.field.DoubleDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.runtime.DoubleScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.DoubleScriptFieldRangeQuery;
import org.elasticsearch.search.runtime.DoubleScriptFieldTermQuery;
import org.elasticsearch.search.runtime.DoubleScriptFieldTermsQuery;

public final class DoubleScriptFieldType
extends AbstractScriptFieldType<DoubleFieldScript.LeafFactory> {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(Builder::new);

    public static RuntimeField sourceOnly(String name) {
        return new Builder(name).createRuntimeField(DoubleFieldScript.PARSE_FROM_SOURCE);
    }

    DoubleScriptFieldType(String name, DoubleFieldScript.Factory scriptFactory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
        super(name, searchLookup -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup, onScriptError), script, scriptFactory.isResultDeterministic(), meta, scriptFactory.isParsedFromSource());
    }

    @Override
    public String typeName() {
        return NumberFieldMapper.NumberType.DOUBLE.typeName();
    }

    @Override
    public Object valueForDisplay(Object value) {
        return value;
    }

    @Override
    public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
        this.checkNoTimeZone(timeZone);
        if (format == null) {
            return DocValueFormat.RAW;
        }
        return new DocValueFormat.Decimal(format);
    }

    @Override
    public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
        FallbackSyntheticSourceBlockLoader fallbackSyntheticSourceBlockLoader = this.numericFallbackSyntheticSourceBlockLoader(blContext, NumberFieldMapper.NumberType.DOUBLE, BlockLoader.BlockFactory::doubles, (values, blockBuilder) -> {
            BlockLoader.DoubleBuilder builder = (BlockLoader.DoubleBuilder)blockBuilder;
            for (Number value : values) {
                builder.appendDouble(value.doubleValue());
            }
        });
        if (fallbackSyntheticSourceBlockLoader != null) {
            return fallbackSyntheticSourceBlockLoader;
        }
        return new DoubleScriptBlockDocValuesReader.DoubleScriptBlockLoader((DoubleFieldScript.LeafFactory)this.leafFactory(blContext.lookup()));
    }

    @Override
    public DoubleScriptFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        return new DoubleScriptFieldData.Builder(this.name(), (DoubleFieldScript.LeafFactory)this.leafFactory(fieldDataContext.lookupSupplier().get()), DoubleDocValuesField::new);
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new DoubleScriptFieldExistsQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name());
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        this.applyScriptContext(context);
        return NumberFieldMapper.NumberType.doubleRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> new DoubleScriptFieldRangeQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name(), (double)l, (double)u));
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new DoubleScriptFieldTermQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name(), NumberFieldMapper.NumberType.objectToDouble(value));
    }

    @Override
    public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
        if (values.isEmpty()) {
            return Queries.ALL_DOCS_INSTANCE;
        }
        HashSet<Long> terms = Sets.newHashSetWithExpectedSize(values.size());
        for (Object value : values) {
            terms.add(Double.doubleToLongBits(NumberFieldMapper.NumberType.objectToDouble(value)));
        }
        this.applyScriptContext(context);
        return new DoubleScriptFieldTermsQuery(this.script, (DoubleFieldScript.LeafFactory)this.leafFactory(context), this.name(), terms);
    }

    private static class Builder
    extends AbstractScriptFieldType.Builder<DoubleFieldScript.Factory> {
        Builder(String name) {
            super(name, DoubleFieldScript.CONTEXT);
        }

        @Override
        protected AbstractScriptFieldType<?> createFieldType(String name, DoubleFieldScript.Factory factory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
            return new DoubleScriptFieldType(name, factory, script, meta, onScriptError);
        }

        @Override
        protected DoubleFieldScript.Factory getParseFromSourceFactory() {
            return DoubleFieldScript.PARSE_FROM_SOURCE;
        }

        @Override
        protected DoubleFieldScript.Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
            return DoubleFieldScript.leafAdapter(parentScriptFactory);
        }
    }
}

