/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.MultiValuedSortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.xcontent.XContentBuilder;

public final class BinaryDocValuesSyntheticFieldLoaderLayer
implements CompositeSyntheticFieldLoader.DocValuesLayer {
    private final String name;
    private SortedBinaryDocValues bytesValues;
    private boolean hasValue;

    public BinaryDocValuesSyntheticFieldLoaderLayer(String name) {
        this.name = name;
    }

    @Override
    public long valueCount() {
        return this.hasValue ? (long)this.bytesValues.docValueCount() : 0L;
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        BinaryDocValues docValues = leafReader.getBinaryDocValues(this.name);
        if (docValues == null) {
            this.bytesValues = null;
            this.hasValue = false;
            return null;
        }
        this.bytesValues = new MultiValuedSortedBinaryDocValues(docValues);
        return docId -> {
            this.hasValue = this.bytesValues.advanceExact(docId);
            return this.hasValue;
        };
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        if (!this.hasValue) {
            return;
        }
        for (int i = 0; i < this.bytesValues.docValueCount(); ++i) {
            BytesRef value = this.bytesValues.nextValue();
            b.utf8Value(value.bytes, value.offset, value.length);
        }
    }

    @Override
    public String fieldName() {
        return this.name;
    }
}

