/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.flush;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class FlushStats
implements Writeable,
ToXContentFragment {
    private long total;
    private long periodic;
    private long totalTimeInMillis;
    private long totalTimeExcludingWaitingOnLockInMillis;

    public FlushStats() {
    }

    public FlushStats(StreamInput in) throws IOException {
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
        this.periodic = in.readVLong();
        this.totalTimeExcludingWaitingOnLockInMillis = in.readVLong();
    }

    public FlushStats(long total, long periodic, long totalTimeInMillis, long totalTimeExcludingWaitingOnLockInMillis) {
        this.total = total;
        this.periodic = periodic;
        this.totalTimeInMillis = totalTimeInMillis;
        this.totalTimeExcludingWaitingOnLockInMillis = totalTimeExcludingWaitingOnLockInMillis;
    }

    public void add(long total, long periodic, long totalTimeInMillis, long totalTimeWithoutWaitingInMillis) {
        this.total += total;
        this.periodic += periodic;
        this.totalTimeInMillis += totalTimeInMillis;
        this.totalTimeExcludingWaitingOnLockInMillis += totalTimeWithoutWaitingInMillis;
    }

    public void add(FlushStats flushStats) {
        this.addTotals(flushStats);
    }

    public void addTotals(FlushStats flushStats) {
        if (flushStats == null) {
            return;
        }
        this.total += flushStats.total;
        this.periodic += flushStats.periodic;
        this.totalTimeInMillis += flushStats.totalTimeInMillis;
        this.totalTimeExcludingWaitingOnLockInMillis += flushStats.totalTimeExcludingWaitingOnLockInMillis;
    }

    public long getTotal() {
        return this.total;
    }

    public long getPeriodic() {
        return this.periodic;
    }

    public long getTotalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue getTotalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    public long getTotalTimeExcludingWaitingOnLockMillis() {
        return this.totalTimeExcludingWaitingOnLockInMillis;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("flush");
        builder.field("total", this.total);
        builder.field("periodic", this.periodic);
        builder.humanReadableField("total_time_in_millis", "total_time", (Object)this.getTotalTime());
        builder.humanReadableField("total_time_excluding_waiting_on_lock_in_millis", "total_time_excluding_waiting", (Object)new TimeValue(this.getTotalTimeExcludingWaitingOnLockMillis()));
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
        out.writeVLong(this.periodic);
        out.writeVLong(this.totalTimeExcludingWaitingOnLockInMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlushStats that = (FlushStats)o;
        return this.total == that.total && this.totalTimeInMillis == that.totalTimeInMillis && this.periodic == that.periodic && this.totalTimeExcludingWaitingOnLockInMillis == that.totalTimeExcludingWaitingOnLockInMillis;
    }

    public int hashCode() {
        return Objects.hash(this.total, this.totalTimeInMillis, this.periodic, this.totalTimeExcludingWaitingOnLockInMillis);
    }

    static final class Fields {
        static final String FLUSH = "flush";
        static final String TOTAL = "total";
        static final String PERIODIC = "periodic";
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";
        static final String TOTAL_TIME_EXCLUDING_WAITING = "total_time_excluding_waiting";
        static final String TOTAL_TIME_EXCLUDING_WAITING_ON_LOCK_IN_MILLIS = "total_time_excluding_waiting_on_lock_in_millis";

        Fields() {
        }
    }
}

