/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public class MultiValuedSortedBinaryDocValues
extends SortedBinaryDocValues {
    BinaryDocValues values;
    int count;
    final ByteArrayStreamInput in = new ByteArrayStreamInput();
    final BytesRef scratch = new BytesRef();

    public MultiValuedSortedBinaryDocValues(BinaryDocValues values) {
        this.values = values;
    }

    @Override
    public boolean advanceExact(int doc) throws IOException {
        if (this.values.advanceExact(doc)) {
            BytesRef bytes = this.values.binaryValue();
            assert (bytes.length > 0);
            this.in.reset(bytes.bytes, bytes.offset, bytes.length);
            this.count = this.in.readVInt();
            this.scratch.bytes = bytes.bytes;
            return true;
        }
        this.count = 0;
        return false;
    }

    @Override
    public int docValueCount() {
        return this.count;
    }

    @Override
    public BytesRef nextValue() throws IOException {
        this.scratch.length = this.in.readVInt();
        this.scratch.offset = this.in.getPosition();
        this.in.setPosition(this.scratch.offset + this.scratch.length);
        return this.scratch;
    }
}

