/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.fieldvisitor.FieldNamesProvidingStoredFieldsVisitor;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

final class TranslogDirectoryReader
extends DirectoryReader {
    private final LeafReader leafReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryReader create(ShardId shardId, Translog.Index operation, MappingLookup mappingLookup, DocumentParser documentParser, EngineConfig engineConfig, Runnable onSegmentCreated, boolean forceSynthetic) throws IOException {
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        boolean success = false;
        try {
            LeafReader leafReader;
            if (mappingLookup.isSourceSynthetic() || forceSynthetic) {
                onSegmentCreated.run();
                leafReader = TranslogDirectoryReader.createInMemoryReader(shardId, engineConfig, (Directory)directory, documentParser, mappingLookup, false, operation);
            } else {
                leafReader = new TranslogLeafReader(shardId, operation, mappingLookup, documentParser, engineConfig, (Directory)directory, onSegmentCreated);
            }
            ElasticsearchDirectoryReader directoryReader = ElasticsearchDirectoryReader.wrap(new TranslogDirectoryReader((Directory)directory, leafReader), shardId);
            success = true;
            ElasticsearchDirectoryReader elasticsearchDirectoryReader = directoryReader;
            return elasticsearchDirectoryReader;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)directory);
            }
        }
    }

    private TranslogDirectoryReader(Directory directory, LeafReader leafReader) throws IOException {
        super(directory, new LeafReader[]{leafReader}, null);
        this.leafReader = leafReader;
    }

    private static UnsupportedOperationException unsupported() {
        assert (false) : "unsupported operation";
        return new UnsupportedOperationException();
    }

    protected DirectoryReader doOpenIfChanged() {
        throw TranslogDirectoryReader.unsupported();
    }

    protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
        throw TranslogDirectoryReader.unsupported();
    }

    protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
        throw TranslogDirectoryReader.unsupported();
    }

    public long getVersion() {
        throw TranslogDirectoryReader.unsupported();
    }

    public boolean isCurrent() {
        throw TranslogDirectoryReader.unsupported();
    }

    public IndexCommit getIndexCommit() {
        throw TranslogDirectoryReader.unsupported();
    }

    protected void doClose() throws IOException {
        this.leafReader.close();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.leafReader.getReaderCacheHelper();
    }

    private static LeafReader createInMemoryReader(ShardId shardId, EngineConfig engineConfig, final Directory directory, DocumentParser documentParser, MappingLookup mappingLookup, boolean rootDocOnly, Translog.Index operation) {
        SequentialStoredFieldsLeafReader sequentialStoredFieldsLeafReader;
        String id = Uid.decodeId(operation.uid());
        ParsedDocument parsedDocs = documentParser.parseDocument(new SourceToParse(id, operation.source(), XContentHelper.xContentType(operation.source()), operation.routing()), mappingLookup);
        parsedDocs.updateSeqID(operation.seqNo(), operation.primaryTerm());
        parsedDocs.version().setLongValue(operation.version());
        IndexWriterConfig writeConfig = new IndexWriterConfig(engineConfig.getAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE).setCodec(engineConfig.getCodec());
        IndexWriter writer = new IndexWriter(directory, writeConfig);
        try {
            int numDocs;
            if (rootDocOnly) {
                numDocs = 1;
                writer.addDocument((Iterable)parsedDocs.rootDoc());
            } else {
                numDocs = parsedDocs.docs().size();
                writer.addDocuments(parsedDocs.docs());
            }
            DirectoryReader reader = TranslogDirectoryReader.open((IndexWriter)writer);
            if (reader.leaves().size() != 1 || ((LeafReaderContext)reader.leaves().get(0)).reader().numDocs() != numDocs) {
                reader.close();
                throw new IllegalStateException("Expected a single segment with " + numDocs + " documents, but [" + reader.leaves().size() + " segments with " + ((LeafReaderContext)reader.leaves().get(0)).reader().numDocs() + " documents");
            }
            final LeafReader leafReader = ((LeafReaderContext)reader.leaves().get(0)).reader();
            sequentialStoredFieldsLeafReader = new SequentialStoredFieldsLeafReader(leafReader){

                protected void doClose() throws IOException {
                    IOUtils.close((Closeable[])new Closeable[]{() -> super.doClose(), directory});
                }

                public IndexReader.CacheHelper getCoreCacheHelper() {
                    return leafReader.getCoreCacheHelper();
                }

                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return leafReader.getReaderCacheHelper();
                }

                @Override
                public StoredFieldsReader getSequentialStoredFieldsReader() {
                    return Lucene.segmentReader(leafReader).getFieldsReader().getMergeInstance();
                }

                @Override
                protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
                    return reader;
                }
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new EngineException(shardId, "failed to create an in-memory segment for get [" + id + "]", e, new Object[0]);
            }
        }
        writer.close();
        return sequentialStoredFieldsLeafReader;
    }

    private static class TranslogLeafReader
    extends LeafReader {
        private static final FieldInfo FAKE_SOURCE_FIELD = new FieldInfo("_source", 1, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
        private static final FieldInfo FAKE_ROUTING_FIELD = new FieldInfo("_routing", 2, false, false, false, IndexOptions.NONE, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
        private static final FieldInfo FAKE_ID_FIELD = new FieldInfo("_id", 3, false, false, false, IndexOptions.DOCS, DocValuesType.NONE, DocValuesSkipIndexType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, 0, VectorEncoding.FLOAT32, VectorSimilarityFunction.EUCLIDEAN, false, false);
        private static final Set<String> TRANSLOG_FIELD_NAMES = Set.of("_source", "_routing", "_id");
        private final ShardId shardId;
        private final Translog.Index operation;
        private final MappingLookup mappingLookup;
        private final DocumentParser documentParser;
        private final EngineConfig engineConfig;
        private final Directory directory;
        private final Runnable onSegmentCreated;
        private final AtomicReference<LeafReader> delegate = new AtomicReference();
        private final BytesRef uid;

        TranslogLeafReader(ShardId shardId, Translog.Index operation, MappingLookup mappingLookup, DocumentParser documentParser, EngineConfig engineConfig, Directory directory, Runnable onSegmentCreated) {
            this.shardId = shardId;
            this.operation = operation;
            this.mappingLookup = mappingLookup;
            this.documentParser = documentParser;
            this.engineConfig = engineConfig;
            this.onSegmentCreated = onSegmentCreated;
            this.directory = directory;
            this.uid = operation.uid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LeafReader getDelegate() {
            this.ensureOpen();
            LeafReader reader = this.delegate.get();
            if (reader == null) {
                TranslogLeafReader translogLeafReader = this;
                synchronized (translogLeafReader) {
                    this.ensureOpen();
                    reader = this.delegate.get();
                    if (reader == null) {
                        LeafReader indexReader = TranslogDirectoryReader.createInMemoryReader(this.shardId, this.engineConfig, this.directory, this.documentParser, this.mappingLookup, true, this.operation);
                        reader = ((LeafReaderContext)indexReader.leaves().get(0)).reader();
                        LeafReader existing = this.delegate.getAndSet(reader);
                        assert (existing == null);
                        this.onSegmentCreated.run();
                    }
                }
            }
            return reader;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.getDelegate().getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        public Terms terms(String field) throws IOException {
            if (this.delegate.get() == null && field.equals("_id")) {
                return new FakeTerms(this.uid);
            }
            return this.getDelegate().terms(field);
        }

        public NumericDocValues getNumericDocValues(String field) throws IOException {
            if (this.delegate.get() == null) {
                if (field.equals("_version")) {
                    return new FakeNumericDocValues(this.operation.version());
                }
                if (field.equals("_seq_no")) {
                    return new FakeNumericDocValues(this.operation.seqNo());
                }
                if (field.equals("_primary_term")) {
                    return new FakeNumericDocValues(this.operation.primaryTerm());
                }
            }
            return this.getDelegate().getNumericDocValues(field);
        }

        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return this.getDelegate().getBinaryDocValues(field);
        }

        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return this.getDelegate().getSortedDocValues(field);
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            return this.getDelegate().getSortedNumericDocValues(field);
        }

        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            return this.getDelegate().getSortedSetDocValues(field);
        }

        public NumericDocValues getNormValues(String field) throws IOException {
            return this.getDelegate().getNormValues(field);
        }

        public DocValuesSkipper getDocValuesSkipper(String field) throws IOException {
            return this.getDelegate().getDocValuesSkipper(field);
        }

        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.getDelegate().getFloatVectorValues(field);
        }

        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.getDelegate().getByteVectorValues(field);
        }

        public void searchNearestVectors(String field, float[] target, KnnCollector collector, AcceptDocs acceptDocs) throws IOException {
            this.getDelegate().searchNearestVectors(field, target, collector, acceptDocs);
        }

        public void searchNearestVectors(String field, byte[] target, KnnCollector collector, AcceptDocs acceptDocs) throws IOException {
            this.getDelegate().searchNearestVectors(field, target, collector, acceptDocs);
        }

        public FieldInfos getFieldInfos() {
            return this.getDelegate().getFieldInfos();
        }

        public Bits getLiveDocs() {
            return null;
        }

        public PointValues getPointValues(String field) throws IOException {
            return this.getDelegate().getPointValues(field);
        }

        public void checkIntegrity() throws IOException {
        }

        public LeafMetaData getMetaData() {
            return this.getDelegate().getMetaData();
        }

        public TermVectors termVectors() throws IOException {
            return this.getDelegate().termVectors();
        }

        public StoredFields storedFields() throws IOException {
            return new StoredFields(){

                public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                    assert (docID == 0);
                    if (delegate.get() == null && visitor instanceof FieldNamesProvidingStoredFieldsVisitor && TRANSLOG_FIELD_NAMES.containsAll(((FieldNamesProvidingStoredFieldsVisitor)visitor).getFieldNames())) {
                        this.readStoredFieldsDirectly(visitor);
                        return;
                    }
                    this.getDelegate().storedFields().document(docID, visitor);
                }
            };
        }

        public int numDocs() {
            return 1;
        }

        public int maxDoc() {
            return 1;
        }

        private void readStoredFieldsDirectly(StoredFieldVisitor visitor) throws IOException {
            if (visitor.needsField(FAKE_SOURCE_FIELD) == StoredFieldVisitor.Status.YES) {
                BytesReference sourceBytes = this.operation.source();
                assert (BytesReference.toBytes(sourceBytes) == sourceBytes.toBytesRef().bytes);
                SourceFieldMapper mapper = this.mappingLookup.getMapping().getMetadataMapperByClass(SourceFieldMapper.class);
                if (mapper != null) {
                    try {
                        sourceBytes = mapper.applyFilters(this.mappingLookup, sourceBytes, null, true);
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to reapply filters after reading from translog", e);
                    }
                }
                if (sourceBytes != null) {
                    visitor.binaryField(FAKE_SOURCE_FIELD, BytesReference.toBytes(sourceBytes));
                }
            }
            if (this.operation.routing() != null && visitor.needsField(FAKE_ROUTING_FIELD) == StoredFieldVisitor.Status.YES) {
                visitor.stringField(FAKE_ROUTING_FIELD, this.operation.routing());
            }
            if (visitor.needsField(FAKE_ID_FIELD) == StoredFieldVisitor.Status.YES) {
                byte[] id = new byte[this.uid.length];
                System.arraycopy(this.uid.bytes, this.uid.offset, id, 0, this.uid.length);
                visitor.binaryField(FAKE_ID_FIELD, id);
            }
        }

        protected synchronized void doClose() throws IOException {
            LeafReader leaf = this.delegate.get();
            if (leaf != null) {
                leaf.close();
            } else {
                this.directory.close();
            }
        }
    }

    private static class FakeNumericDocValues
    extends NumericDocValues {
        private final long value;
        private final DocIdSetIterator disi = DocIdSetIterator.all((int)1);

        FakeNumericDocValues(long value) {
            this.value = value;
        }

        public long longValue() {
            return this.value;
        }

        public boolean advanceExact(int target) throws IOException {
            return this.disi.advance(target) == target;
        }

        public int docID() {
            return this.disi.docID();
        }

        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        public long cost() {
            return this.disi.cost();
        }
    }

    private static class FakePostingsEnum
    extends PostingsEnum {
        private final BytesRef term;
        private int iter = -1;

        private FakePostingsEnum(BytesRef term) {
            this.term = term;
        }

        public int freq() {
            return 1;
        }

        public int nextPosition() {
            return 0;
        }

        public int startOffset() {
            return 0;
        }

        public int endOffset() {
            return this.term.length;
        }

        public BytesRef getPayload() {
            return null;
        }

        public int docID() {
            return this.iter > 0 ? Integer.MAX_VALUE : this.iter;
        }

        public int nextDoc() {
            return ++this.iter == 0 ? 0 : Integer.MAX_VALUE;
        }

        public int advance(int target) {
            int doc;
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public long cost() {
            return 0L;
        }
    }

    private static class FakeTermsEnum
    extends BaseTermsEnum {
        private final BytesRef term;
        private long position = -1L;

        FakeTermsEnum(BytesRef term) {
            this.term = term;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            int cmp = text.compareTo(this.term);
            if (cmp == 0) {
                this.position = 0L;
                return TermsEnum.SeekStatus.FOUND;
            }
            if (cmp < 0) {
                this.position = 0L;
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            this.position = Long.MAX_VALUE;
            return TermsEnum.SeekStatus.END;
        }

        public void seekExact(long ord) throws IOException {
            this.position = ord;
        }

        public BytesRef term() throws IOException {
            assert (this.position == 0L);
            return this.term;
        }

        public long ord() throws IOException {
            return this.position;
        }

        public int docFreq() throws IOException {
            return 1;
        }

        public long totalTermFreq() throws IOException {
            return 1L;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            return new FakePostingsEnum(this.term);
        }

        public ImpactsEnum impacts(int flags) throws IOException {
            throw TranslogDirectoryReader.unsupported();
        }

        public BytesRef next() throws IOException {
            return ++this.position == 0L ? this.term : null;
        }
    }

    private static class FakeTerms
    extends Terms {
        private final BytesRef uid;

        FakeTerms(BytesRef uid) {
            this.uid = uid;
        }

        public TermsEnum iterator() throws IOException {
            return new FakeTermsEnum(this.uid);
        }

        public long size() throws IOException {
            return 1L;
        }

        public long getSumTotalTermFreq() throws IOException {
            return 1L;
        }

        public long getSumDocFreq() throws IOException {
            return 1L;
        }

        public int getDocCount() throws IOException {
            return 1;
        }

        public boolean hasFreqs() {
            return false;
        }

        public boolean hasOffsets() {
            return false;
        }

        public boolean hasPositions() {
            return false;
        }

        public boolean hasPayloads() {
            return false;
        }
    }
}

