/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb.es819;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.core.SuppressForbidden;

final class DISIAccumulator
implements Closeable {
    private static final int BLOCK_SIZE = 65536;
    private static final int DENSE_BLOCK_LONGS = 1024;
    public static final byte DEFAULT_DENSE_RANK_POWER = 9;
    static final int MAX_ARRAY_LENGTH = 4095;
    final Directory dir;
    final IOContext context;
    final String skipListTempFileName;
    final IndexOutput disiTempOutput;
    final byte denseRankPower;
    final long origo;
    int totalCardinality = 0;
    int blockCardinality = 0;
    final FixedBitSet buffer = new FixedBitSet(65536);
    int[] jumps = new int[ArrayUtil.oversize((int)1, (int)8)];
    int prevBlock = -1;
    int jumpBlockIndex = 0;

    DISIAccumulator(Directory dir, IOContext context, IndexOutput data, byte denseRankPower) throws IOException {
        this.dir = dir;
        this.context = context;
        this.denseRankPower = denseRankPower;
        if ((denseRankPower < 7 || denseRankPower > 15) && denseRankPower != -1) {
            throw new IllegalArgumentException("Acceptable values for denseRankPower are 7-15 (every 128-32768 docIDs). The provided power was " + denseRankPower + " (every " + (int)Math.pow(2.0, denseRankPower) + " docIDs)");
        }
        this.disiTempOutput = dir.createTempOutput(data.getName(), "disi", context);
        this.skipListTempFileName = this.disiTempOutput.getName();
        this.origo = this.disiTempOutput.getFilePointer();
    }

    void addDocId(int doc) throws IOException {
        int block = doc >>> 16;
        if (this.prevBlock != -1 && block != this.prevBlock) {
            this.jumps = DISIAccumulator.addJumps(this.jumps, this.disiTempOutput.getFilePointer() - this.origo, this.totalCardinality, this.jumpBlockIndex, this.prevBlock + 1);
            this.jumpBlockIndex = this.prevBlock + 1;
            DISIAccumulator.flush(this.prevBlock, this.buffer, this.blockCardinality, this.denseRankPower, this.disiTempOutput);
            this.buffer.clear();
            this.totalCardinality += this.blockCardinality;
            this.blockCardinality = 0;
        }
        this.buffer.set(doc & 0xFFFF);
        ++this.blockCardinality;
        this.prevBlock = block;
    }

    short build(IndexOutput data) throws IOException {
        if (this.blockCardinality > 0) {
            this.jumps = DISIAccumulator.addJumps(this.jumps, this.disiTempOutput.getFilePointer() - this.origo, this.totalCardinality, this.jumpBlockIndex, this.prevBlock + 1);
            this.totalCardinality += this.blockCardinality;
            DISIAccumulator.flush(this.prevBlock, this.buffer, this.blockCardinality, this.denseRankPower, this.disiTempOutput);
            this.buffer.clear();
            ++this.prevBlock;
        }
        int lastBlock = this.prevBlock == -1 ? 0 : this.prevBlock;
        this.jumps = DISIAccumulator.addJumps(this.jumps, this.disiTempOutput.getFilePointer() - this.origo, this.totalCardinality, lastBlock, lastBlock + 1);
        this.buffer.set(65535);
        DISIAccumulator.flush(Short.MAX_VALUE, this.buffer, 1, this.denseRankPower, this.disiTempOutput);
        short blockCount = DISIAccumulator.flushBlockJumps(this.jumps, lastBlock + 1, this.disiTempOutput);
        this.disiTempOutput.close();
        try (IndexInput addressDataInput = this.dir.openInput(this.skipListTempFileName, this.context);){
            data.copyBytes((DataInput)addressDataInput, addressDataInput.length());
        }
        return blockCount;
    }

    private static int[] addJumps(int[] jumps, long offset, int index, int startBlock, int endBlock) {
        assert (offset < Integer.MAX_VALUE) : "Logically the offset should not exceed 2^30 but was >= Integer.MAX_VALUE";
        jumps = ArrayUtil.grow((int[])jumps, (int)((endBlock + 1) * 2));
        for (int b = startBlock; b < endBlock; ++b) {
            jumps[b * 2] = index;
            jumps[b * 2 + 1] = (int)offset;
        }
        return jumps;
    }

    private static void flush(int block, FixedBitSet buffer, int cardinality, byte denseRankPower, IndexOutput out) throws IOException {
        block6: {
            block5: {
                assert (block >= 0 && block < 65536);
                out.writeShort((short)block);
                assert (cardinality > 0 && cardinality <= 65536);
                out.writeShort((short)(cardinality - 1));
                if (cardinality <= 4095) break block5;
                if (cardinality == 65536) break block6;
                if (denseRankPower != -1) {
                    byte[] byArray = DISIAccumulator.createRank(buffer, denseRankPower);
                    out.writeBytes(byArray, byArray.length);
                }
                for (long word : buffer.getBits()) {
                    out.writeLong(word);
                }
                break block6;
            }
            BitSetIterator bitSetIterator = new BitSetIterator((BitSet)buffer, (long)cardinality);
            int doc = bitSetIterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                out.writeShort((short)doc);
                doc = bitSetIterator.nextDoc();
            }
        }
    }

    private static short flushBlockJumps(int[] jumps, int blockCount, IndexOutput out) throws IOException {
        if (blockCount == 2) {
            blockCount = 0;
        }
        for (int i = 0; i < blockCount; ++i) {
            out.writeInt(jumps[i * 2]);
            out.writeInt(jumps[i * 2 + 1]);
        }
        return (short)blockCount;
    }

    private static byte[] createRank(FixedBitSet buffer, byte denseRankPower) {
        int longsPerRank = 1 << denseRankPower - 6;
        int rankMark = longsPerRank - 1;
        int rankIndexShift = denseRankPower - 7;
        byte[] rank = new byte[1024 >> rankIndexShift];
        long[] bits = buffer.getBits();
        int bitCount = 0;
        for (int word = 0; word < 1024; ++word) {
            if ((word & rankMark) == 0) {
                rank[word >> rankIndexShift] = (byte)(bitCount >> 8);
                rank[(word >> rankIndexShift) + 1] = (byte)(bitCount & 0xFF);
            }
            bitCount += Long.bitCount(bits[word]);
        }
        return rank;
    }

    @Override
    @SuppressForbidden(reason="require usage of Lucene's IOUtils#deleteFilesIgnoringExceptions(...)")
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.disiTempOutput});
        if (this.skipListTempFileName != null) {
            IOUtils.deleteFilesIgnoringExceptions((Directory)this.dir, (String[])new String[]{this.skipListTempFileName});
        }
    }
}

