/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.index.mapper.TsidExtractingIdFieldMapper;
import org.elasticsearch.index.mapper.Uid;

public class TSDBSyntheticIdFieldsProducer
extends FieldsProducer {
    private static final Set<String> FIELDS_NAMES = Set.of("_id");
    private final DocValuesProducer docValuesProducer;
    private final FieldInfos fieldInfos;
    private final int maxDocs;

    public TSDBSyntheticIdFieldsProducer(SegmentReadState state, DocValuesProducer docValuesProducer) {
        this(state.fieldInfos, docValuesProducer, state.segmentInfo.maxDoc());
    }

    private TSDBSyntheticIdFieldsProducer(FieldInfos fieldInfos, DocValuesProducer docValuesProducer, int maxDocs) {
        assert (TSDBSyntheticIdFieldsProducer.assertFieldInfosExist(fieldInfos, "_id", "@timestamp", "_tsid"));
        this.docValuesProducer = Objects.requireNonNull(docValuesProducer);
        this.fieldInfos = fieldInfos;
        this.maxDocs = maxDocs;
    }

    public int size() {
        return FIELDS_NAMES.size();
    }

    public Iterator<String> iterator() {
        return FIELDS_NAMES.iterator();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable)this.docValuesProducer);
    }

    public void checkIntegrity() throws IOException {
    }

    public FieldsProducer getMergeInstance() {
        return new TSDBSyntheticIdFieldsProducer(this.fieldInfos, this.docValuesProducer, this.maxDocs);
    }

    public Terms terms(String field) throws IOException {
        assert (FIELDS_NAMES.contains(field)) : field;
        return new Terms(){

            public TermsEnum iterator() {
                return new SyntheticIdTermsEnum();
            }

            public int getDocCount() {
                return TSDBSyntheticIdFieldsProducer.this.maxDocs - 1;
            }

            public long size() {
                return -1L;
            }

            public long getSumTotalTermFreq() {
                return 0L;
            }

            public long getSumDocFreq() {
                return 0L;
            }

            public boolean hasFreqs() {
                return false;
            }

            public boolean hasOffsets() {
                return false;
            }

            public boolean hasPositions() {
                return false;
            }

            public boolean hasPayloads() {
                return false;
            }
        };
    }

    private static BytesRef syntheticId(BytesRef tsId, long timestamp, BytesRef routingHashBytes) {
        assert (tsId != null);
        assert (timestamp > 0L);
        assert (routingHashBytes != null);
        String routingHashString = Uid.decodeId(routingHashBytes.bytes, routingHashBytes.offset, routingHashBytes.length);
        int routingHash = TimeSeriesRoutingHashFieldMapper.decode(routingHashString);
        return TsidExtractingIdFieldMapper.createSyntheticIdBytesRef(tsId, timestamp, routingHash);
    }

    private static boolean assertFieldInfosExist(FieldInfos fieldInfos, String ... fieldNames) {
        assert (fieldNames != null && fieldNames.length > 0) : "fieldNames should be > 0";
        for (String fieldName : fieldNames) {
            assert (fieldInfos.fieldInfo(fieldName) != null) : "field [" + fieldName + "] not found";
        }
        return true;
    }

    private static UnsupportedOperationException unsupportedException() {
        String error = "This method should not be called on this enum";
        assert (false) : error;
        return new UnsupportedOperationException(error);
    }

    private class SyntheticIdPostingsEnum
    extends PostingsEnum {
        private final DocValuesHolder docValues;
        private final int termTsIdOrd;
        private final long termTimestamp;
        private final int startDocId;
        private int docID = -1;

        private SyntheticIdPostingsEnum(int docID, int termTsIdOrd, long termTimestamp) {
            this.docValues = new DocValuesHolder(TSDBSyntheticIdFieldsProducer.this.fieldInfos, TSDBSyntheticIdFieldsProducer.this.docValuesProducer);
            this.termTsIdOrd = termTsIdOrd;
            this.termTimestamp = termTimestamp;
            this.startDocId = docID;
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() throws IOException {
            long timestamp;
            int tsIdOrd;
            int nextDocID;
            if (this.docID == Integer.MAX_VALUE) {
                return this.docID;
            }
            int n = nextDocID = this.docID == -1 ? this.startDocId : this.docID + 1;
            if (nextDocID < TSDBSyntheticIdFieldsProducer.this.maxDocs && (tsIdOrd = this.docValues.docTsIdOrdinal(nextDocID)) == this.termTsIdOrd && (timestamp = this.docValues.docTimestamp(nextDocID)) == this.termTimestamp) {
                assert (Objects.equals(this.docValues.docRoutingHash(nextDocID), this.docValues.docRoutingHash(this.docID == -1 ? this.startDocId : this.docID)));
                this.docID = nextDocID;
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return this.docID;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public long cost() {
            return 0L;
        }

        public int freq() throws IOException {
            return 0;
        }

        public int nextPosition() throws IOException {
            return -1;
        }

        public int startOffset() throws IOException {
            return -1;
        }

        public int endOffset() throws IOException {
            return -1;
        }

        public BytesRef getPayload() throws IOException {
            return null;
        }
    }

    private class SyntheticIdTermsEnum
    extends BaseTermsEnum {
        private final DocValuesHolder docValues;
        private int docID;
        @Nullable
        private Integer docTsIdOrd;
        @Nullable
        private Long docTimestamp;

        private SyntheticIdTermsEnum() {
            this.docValues = new DocValuesHolder(TSDBSyntheticIdFieldsProducer.this.fieldInfos, TSDBSyntheticIdFieldsProducer.this.docValuesProducer);
            this.resetDocID(-1);
        }

        private void resetDocID(int docID) {
            this.docID = docID;
            this.docTsIdOrd = null;
            this.docTimestamp = null;
        }

        private void ensurePositioned() {
            if (this.docID == -1 || this.docID == Integer.MAX_VALUE) {
                assert (false);
                throw new IllegalStateException("Method should not be called when unpositioned");
            }
        }

        private boolean assertNoMoreDocs() {
            assert (this.docID == Integer.MAX_VALUE) : this.docID;
            assert (this.docTsIdOrd == null) : this.docTsIdOrd;
            assert (this.docTimestamp == null) : this.docTimestamp;
            return true;
        }

        public BytesRef next() throws IOException {
            if (this.docID == Integer.MAX_VALUE) {
                assert (this.assertNoMoreDocs());
                return null;
            }
            int nextDocID = this.docID + 1;
            if (TSDBSyntheticIdFieldsProducer.this.maxDocs <= nextDocID) {
                this.resetDocID(Integer.MAX_VALUE);
                return null;
            }
            this.resetDocID(nextDocID);
            return this.term();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef id) throws IOException {
            long timestamp;
            assert (id != null);
            assert (12 < id.length) : id.length;
            if (id == null || id.length <= 12) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            BytesRef tsId = TsidExtractingIdFieldMapper.extractTimeSeriesIdFromSyntheticId(id);
            int tsIdOrd = this.docValues.lookupTsIdTerm(tsId);
            if (tsIdOrd < 0) {
                int firstDocID;
                if ((tsIdOrd = -tsIdOrd - 1) < this.docValues.getTsIdValueCount() && (firstDocID = this.docValues.findFirstDocWithTsIdOrdinalEqualOrGreaterThan(tsIdOrd)) != Integer.MAX_VALUE) {
                    this.docID = firstDocID;
                    this.docTsIdOrd = tsIdOrd;
                    this.docTimestamp = null;
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                this.resetDocID(Integer.MAX_VALUE);
                return TermsEnum.SeekStatus.END;
            }
            int firstDocID = this.docValues.findFirstDocWithTsIdOrdinalEqualTo(tsIdOrd);
            assert (firstDocID >= 0) : firstDocID;
            if (firstDocID != Integer.MAX_VALUE && (firstDocID = this.docValues.skipDocIDForTimestamp(timestamp = TsidExtractingIdFieldMapper.extractTimestampFromSyntheticId(id), firstDocID)) != Integer.MAX_VALUE) {
                int nextDocTsIdOrd = tsIdOrd;
                for (int nextDocID = firstDocID; nextDocID < TSDBSyntheticIdFieldsProducer.this.maxDocs; ++nextDocID) {
                    long nextDocTimestamp = this.docValues.docTimestamp(nextDocID);
                    if (firstDocID < nextDocID) {
                        nextDocTsIdOrd = this.docValues.docTsIdOrdinal(nextDocID);
                    }
                    if (nextDocTsIdOrd == tsIdOrd && nextDocTimestamp == timestamp) {
                        this.docID = nextDocID;
                        this.docTsIdOrd = nextDocTsIdOrd;
                        this.docTimestamp = nextDocTimestamp;
                        return TermsEnum.SeekStatus.FOUND;
                    }
                    if (tsIdOrd < nextDocTsIdOrd || nextDocTimestamp < timestamp) break;
                }
            }
            this.resetDocID(Integer.MAX_VALUE);
            return TermsEnum.SeekStatus.END;
        }

        public BytesRef term() throws IOException {
            this.ensurePositioned();
            if (this.docTsIdOrd == null) {
                this.docTsIdOrd = this.docValues.docTsIdOrdinal(this.docID);
            }
            if (this.docTimestamp == null) {
                this.docTimestamp = this.docValues.docTimestamp(this.docID);
            }
            return TSDBSyntheticIdFieldsProducer.syntheticId(this.docValues.lookupTsIdOrd(this.docTsIdOrd), this.docTimestamp, this.docValues.docRoutingHash(this.docID));
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            this.ensurePositioned();
            if (this.docTsIdOrd == null) {
                this.docTsIdOrd = this.docValues.docTsIdOrdinal(this.docID);
            }
            if (this.docTimestamp == null) {
                this.docTimestamp = this.docValues.docTimestamp(this.docID);
            }
            return new SyntheticIdPostingsEnum(this.docID, this.docTsIdOrd, this.docTimestamp);
        }

        public long ord() {
            throw TSDBSyntheticIdFieldsProducer.unsupportedException();
        }

        public void seekExact(long ord) {
            throw TSDBSyntheticIdFieldsProducer.unsupportedException();
        }

        public int docFreq() {
            return 0;
        }

        public long totalTermFreq() {
            return 0L;
        }

        public ImpactsEnum impacts(int flags) {
            return null;
        }
    }

    private static class DocValuesHolder {
        private final FieldInfo tsIdFieldInfo;
        private final FieldInfo timestampFieldInfo;
        private final FieldInfo routingHashFieldInfo;
        private final DocValuesProducer docValuesProducer;
        private SortedNumericDocValues timestampDocValues;
        private SortedDocValues routingHashDocValues;
        private SortedDocValues tsIdDocValues;
        private int cachedTsIdOrd = -1;
        private BytesRef cachedTsId;

        private DocValuesHolder(FieldInfos fieldInfos, DocValuesProducer docValuesProducer) {
            this.tsIdFieldInfo = this.safeFieldInfo(fieldInfos, "_tsid");
            this.timestampFieldInfo = this.safeFieldInfo(fieldInfos, "@timestamp");
            this.routingHashFieldInfo = this.safeFieldInfo(fieldInfos, "_ts_routing_hash");
            this.docValuesProducer = docValuesProducer;
        }

        private FieldInfo safeFieldInfo(FieldInfos fieldInfos, String fieldName) {
            FieldInfo fi = fieldInfos.fieldInfo(fieldName);
            if (fi == null) {
                String message = "Field [" + fieldName + "] does not exist";
                assert (false) : message;
                throw new IllegalArgumentException(message);
            }
            return fi;
        }

        private int docTsIdOrdinal(int docID) throws IOException {
            if (this.tsIdDocValues == null || this.tsIdDocValues.docID() > docID) {
                this.tsIdDocValues = this.docValuesProducer.getSorted(this.tsIdFieldInfo);
                this.cachedTsIdOrd = -1;
                this.cachedTsId = null;
            }
            boolean found = this.tsIdDocValues.advanceExact(docID);
            assert (found) : "No value found for field [" + this.tsIdFieldInfo.getName() + " and docID " + docID;
            return this.tsIdDocValues.ordValue();
        }

        private long docTimestamp(int docID) throws IOException {
            if (this.timestampDocValues == null || this.timestampDocValues.docID() > docID) {
                this.timestampDocValues = this.docValuesProducer.getSortedNumeric(this.timestampFieldInfo);
            }
            boolean found = this.timestampDocValues.advanceExact(docID);
            assert (found) : "No value found for field [" + this.timestampFieldInfo.getName() + " and docID " + docID;
            assert (this.timestampDocValues.docValueCount() == 1);
            return this.timestampDocValues.nextValue();
        }

        private BytesRef docRoutingHash(int docID) throws IOException {
            if (this.routingHashDocValues == null || this.routingHashDocValues.docID() > docID) {
                this.routingHashDocValues = this.docValuesProducer.getSorted(this.routingHashFieldInfo);
            }
            boolean found = this.routingHashDocValues.advanceExact(docID);
            assert (found) : "No value found for field [" + this.routingHashFieldInfo.getName() + " and docID " + docID;
            return this.routingHashDocValues.lookupOrd(this.routingHashDocValues.ordValue());
        }

        private int lookupTsIdTerm(BytesRef tsId) throws IOException {
            int ordinal;
            int compare = Integer.MAX_VALUE;
            if (this.cachedTsId != null && (compare = this.cachedTsId.compareTo(tsId)) == 0) {
                return this.cachedTsIdOrd;
            }
            if (this.tsIdDocValues == null || compare > 0) {
                this.tsIdDocValues = this.docValuesProducer.getSorted(this.tsIdFieldInfo);
                this.cachedTsIdOrd = -1;
                this.cachedTsId = null;
            }
            if (0 <= (ordinal = this.tsIdDocValues.lookupTerm(tsId))) {
                this.cachedTsIdOrd = ordinal;
                this.cachedTsId = tsId;
            }
            return ordinal;
        }

        private BytesRef lookupTsIdOrd(int tsIdOrdinal) throws IOException {
            if (this.cachedTsIdOrd != -1 && this.cachedTsIdOrd == tsIdOrdinal) {
                return this.cachedTsId;
            }
            if (this.tsIdDocValues == null || this.tsIdDocValues.ordValue() > tsIdOrdinal) {
                this.tsIdDocValues = this.docValuesProducer.getSorted(this.tsIdFieldInfo);
                this.cachedTsIdOrd = -1;
                this.cachedTsId = null;
            }
            assert (0 <= tsIdOrdinal) : tsIdOrdinal;
            assert (tsIdOrdinal < this.tsIdDocValues.getValueCount()) : tsIdOrdinal;
            BytesRef tsId = this.tsIdDocValues.lookupOrd(tsIdOrdinal);
            if (tsId != null) {
                this.cachedTsIdOrd = tsIdOrdinal;
                this.cachedTsId = tsId;
            }
            return tsId;
        }

        private int findStartDocIDForTsIdOrd(int tsIdOrd) throws IOException {
            DocValuesSkipper skipper = this.docValuesProducer.getSkipper(this.tsIdFieldInfo);
            assert (skipper != null);
            if (skipper.minValue() > (long)tsIdOrd || (long)tsIdOrd > skipper.maxValue()) {
                return Integer.MAX_VALUE;
            }
            skipper.advance((long)tsIdOrd, Long.MAX_VALUE);
            return skipper.minDocID(0);
        }

        private int findFirstDocWithTsIdOrdinalEqualOrGreaterThan(int tsIdOrd) throws IOException {
            int startDocId = this.findStartDocIDForTsIdOrd(tsIdOrd);
            if (startDocId == Integer.MAX_VALUE) {
                return startDocId;
            }
            if (this.tsIdDocValues == null || this.cachedTsIdOrd != -1 && this.cachedTsIdOrd >= tsIdOrd || this.tsIdDocValues.docID() > startDocId) {
                this.tsIdDocValues = this.docValuesProducer.getSorted(this.tsIdFieldInfo);
                this.cachedTsIdOrd = -1;
                this.cachedTsId = null;
            }
            assert (0 <= tsIdOrd) : tsIdOrd;
            assert (tsIdOrd < this.tsIdDocValues.getValueCount()) : tsIdOrd;
            int docID = startDocId;
            while (docID != Integer.MAX_VALUE) {
                boolean found = this.tsIdDocValues.advanceExact(docID);
                assert (found) : "No value found for field [" + this.tsIdFieldInfo.getName() + " and docID " + docID;
                int ord = this.tsIdDocValues.ordValue();
                if (ord == tsIdOrd || tsIdOrd < ord) {
                    if (ord != this.cachedTsIdOrd) {
                        this.cachedTsId = this.tsIdDocValues.lookupOrd(ord);
                        this.cachedTsIdOrd = ord;
                    }
                    return docID;
                }
                docID = this.tsIdDocValues.nextDoc();
            }
            this.cachedTsIdOrd = -1;
            this.cachedTsId = null;
            return Integer.MAX_VALUE;
        }

        private int findFirstDocWithTsIdOrdinalEqualTo(int tsIdOrd) throws IOException {
            int startDocId = this.findStartDocIDForTsIdOrd(tsIdOrd);
            assert (startDocId != Integer.MAX_VALUE) : startDocId;
            if (this.tsIdDocValues == null || this.cachedTsIdOrd != -1 && this.cachedTsIdOrd >= tsIdOrd || this.tsIdDocValues.docID() > startDocId) {
                this.tsIdDocValues = this.docValuesProducer.getSorted(this.tsIdFieldInfo);
                this.cachedTsIdOrd = -1;
                this.cachedTsId = null;
            }
            assert (0 <= tsIdOrd) : tsIdOrd;
            assert (tsIdOrd < this.tsIdDocValues.getValueCount()) : tsIdOrd;
            int docID = startDocId;
            while (docID != Integer.MAX_VALUE) {
                boolean found = this.tsIdDocValues.advanceExact(docID);
                assert (found) : "No value found for field [" + this.tsIdFieldInfo.getName() + " and docID " + docID;
                int ord = this.tsIdDocValues.ordValue();
                if (ord == tsIdOrd) {
                    if (ord != this.cachedTsIdOrd) {
                        this.cachedTsId = this.tsIdDocValues.lookupOrd(ord);
                        this.cachedTsIdOrd = ord;
                    }
                    return docID;
                }
                if (tsIdOrd < ord) break;
                docID = this.tsIdDocValues.nextDoc();
            }
            this.cachedTsIdOrd = -1;
            this.cachedTsId = null;
            assert (false) : "Method must be called with an existing _tsid ordinal: " + tsIdOrd;
            return Integer.MAX_VALUE;
        }

        private int skipDocIDForTimestamp(long timestamp, int minDocID) throws IOException {
            DocValuesSkipper skipper = this.docValuesProducer.getSkipper(this.timestampFieldInfo);
            assert (skipper != null);
            if (skipper.minValue() > timestamp || timestamp > skipper.maxValue()) {
                return Integer.MAX_VALUE;
            }
            skipper.advance(minDocID);
            skipper.advance(timestamp, Long.MAX_VALUE);
            return Math.max(minDocID, skipper.minDocID(0));
        }

        private int getTsIdValueCount() throws IOException {
            if (this.tsIdDocValues == null) {
                this.tsIdDocValues = this.docValuesProducer.getSorted(this.tsIdFieldInfo);
            }
            return this.tsIdDocValues.getValueCount();
        }
    }
}

