/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.tsdb;

import org.apache.lucene.codecs.compressing.CompressionMode;
import org.elasticsearch.index.codec.zstd.ZstdCompressionMode;

public enum BinaryDVCompressionMode {
    NO_COMPRESS(0, null),
    COMPRESSED_ZSTD_LEVEL_1(1, new ZstdCompressionMode(1));

    public final byte code;
    private final CompressionMode compressionMode;
    private static final BinaryDVCompressionMode[] values;

    private BinaryDVCompressionMode(byte code, CompressionMode compressionMode) {
        this.code = code;
        this.compressionMode = compressionMode;
    }

    public static BinaryDVCompressionMode fromMode(byte code) {
        if (code < 0 || code >= values.length) {
            throw new IllegalStateException("unknown compression mode [" + code + "]");
        }
        return values[code];
    }

    public CompressionMode compressionMode() {
        if (this.compressionMode == null) {
            throw new UnsupportedOperationException("BinaryDVCompressionMode [" + this.code + "] does not support compression");
        }
        return this.compressionMode;
    }

    static {
        values = new BinaryDVCompressionMode[BinaryDVCompressionMode.values().length];
        BinaryDVCompressionMode[] binaryDVCompressionModeArray = BinaryDVCompressionMode.values();
        int n = binaryDVCompressionModeArray.length;
        for (int i = 0; i < n; ++i) {
            BinaryDVCompressionMode mode;
            BinaryDVCompressionMode.values[mode.code] = mode = binaryDVCompressionModeArray[i];
        }
    }

    public record BlockHeader(boolean isCompressed) {
        static final byte IS_COMPRESSED = 1;

        public static BlockHeader fromByte(byte header) {
            boolean isCompressed = (header & 1) != 0;
            return new BlockHeader(isCompressed);
        }

        public byte toByte() {
            byte header = 0;
            if (this.isCompressed) {
                header = (byte)(header | 1);
            }
            return header;
        }
    }
}

