/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.codec.Elasticsearch92Lucene103Codec;
import org.elasticsearch.index.codec.bloomfilter.ES87BloomFilterPostingsFormat;
import org.elasticsearch.index.codec.postings.ES812PostingsFormat;
import org.elasticsearch.index.codec.tsdb.es819.ES819TSDBDocValuesFormat;
import org.elasticsearch.index.codec.vectors.es93.ES93HnswVectorsFormat;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.threadpool.ThreadPool;

public class PerFieldFormatSupplier {
    private static final Set<String> INCLUDE_META_FIELDS;
    private static final Set<String> EXCLUDE_MAPPER_TYPES;
    private static final DocValuesFormat docValuesFormat;
    private final KnnVectorsFormat knnVectorsFormat;
    private static final ES819TSDBDocValuesFormat tsdbDocValuesFormat;
    private static final ES819TSDBDocValuesFormat tsdbDocValuesFormatLargeNumericBlock;
    private static final ES812PostingsFormat es812PostingsFormat;
    private static final PostingsFormat completionPostingsFormat;
    private final ES87BloomFilterPostingsFormat bloomFilterPostingsFormat;
    private final MapperService mapperService;
    private final ThreadPool threadPool;
    private final PostingsFormat defaultPostingsFormat;

    public PerFieldFormatSupplier(MapperService mapperService, BigArrays bigArrays, @Nullable ThreadPool threadPool) {
        this.mapperService = mapperService;
        this.bloomFilterPostingsFormat = new ES87BloomFilterPostingsFormat(bigArrays, this::internalGetPostingsFormatForField);
        this.threadPool = threadPool;
        this.defaultPostingsFormat = PerFieldFormatSupplier.getDefaultPostingsFormat(mapperService);
        this.knnVectorsFormat = PerFieldFormatSupplier.getDefaultKnnVectorsFormat(mapperService, threadPool);
    }

    private static PostingsFormat getDefaultPostingsFormat(MapperService mapperService) {
        if (mapperService != null && mapperService.getIndexSettings().getIndexVersionCreated().onOrAfter(IndexVersions.UPGRADE_TO_LUCENE_10_3_0)) {
            if (IndexSettings.USE_ES_812_POSTINGS_FORMAT.get(mapperService.getIndexSettings().getSettings()).booleanValue()) {
                return es812PostingsFormat;
            }
            return Elasticsearch92Lucene103Codec.DEFAULT_POSTINGS_FORMAT;
        }
        return es812PostingsFormat;
    }

    private static KnnVectorsFormat getDefaultKnnVectorsFormat(MapperService mapperService, ThreadPool threadPool) {
        ExecutorService mergingExecutorService = null;
        int maxMergingWorkers = 1;
        if (threadPool != null && mapperService != null && mapperService.getIndexSettings().isIntraMergeParallelismEnabled() && threadPool.info("merge") != null && (maxMergingWorkers = threadPool.info("merge").getMax()) > 1) {
            mergingExecutorService = threadPool.executor("merge");
        }
        return new ES93HnswVectorsFormat(16, 100, DenseVectorFieldMapper.ElementType.FLOAT, maxMergingWorkers, mergingExecutorService);
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        if (this.useBloomFilter(field)) {
            return this.bloomFilterPostingsFormat;
        }
        return this.internalGetPostingsFormatForField(field);
    }

    private PostingsFormat internalGetPostingsFormatForField(String field) {
        Mapper mapper;
        if (this.mapperService != null && (mapper = this.mapperService.mappingLookup().getMapper(field)) instanceof CompletionFieldMapper) {
            return completionPostingsFormat;
        }
        return this.defaultPostingsFormat;
    }

    boolean useBloomFilter(String field) {
        if (this.mapperService == null) {
            return false;
        }
        IndexSettings indexSettings = this.mapperService.getIndexSettings();
        if (this.mapperService.mappingLookup().isDataStreamTimestampFieldEnabled()) {
            return indexSettings.getMode() == IndexMode.TIME_SERIES && "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
        }
        return "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        Mapper mapper;
        if (this.mapperService != null && (mapper = this.mapperService.mappingLookup().getMapper(field)) instanceof DenseVectorFieldMapper) {
            DenseVectorFieldMapper vectorMapper = (DenseVectorFieldMapper)mapper;
            return vectorMapper.getKnnVectorsFormatForField(this.knnVectorsFormat, this.mapperService.getIndexSettings(), this.threadPool);
        }
        return this.knnVectorsFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        if (this.useTSDBDocValuesFormat(field)) {
            return this.mapperService != null && this.mapperService.getIndexSettings().isUseTimeSeriesDocValuesFormatLargeBlockSize() ? tsdbDocValuesFormatLargeNumericBlock : tsdbDocValuesFormat;
        }
        return docValuesFormat;
    }

    boolean useTSDBDocValuesFormat(String field) {
        if (this.excludeFields(field)) {
            return false;
        }
        if (this.excludeMapperTypes(field)) {
            return false;
        }
        return this.mapperService != null && this.mapperService.getIndexSettings().useTimeSeriesDocValuesFormat() && this.mapperService.getIndexSettings().isES87TSDBCodecEnabled();
    }

    private boolean excludeFields(String fieldName) {
        return fieldName.startsWith("_") && !INCLUDE_META_FIELDS.contains(fieldName);
    }

    private boolean excludeMapperTypes(String fieldName) {
        String typeName = this.getMapperType(fieldName);
        if (typeName == null) {
            return false;
        }
        return EXCLUDE_MAPPER_TYPES.contains(this.getMapperType(fieldName));
    }

    private boolean isTimeSeriesModeIndex() {
        return this.mapperService != null && IndexMode.TIME_SERIES == this.mapperService.getIndexSettings().getMode();
    }

    private boolean isLogsModeIndex() {
        return this.mapperService != null && IndexMode.LOGSDB == this.mapperService.getIndexSettings().getMode();
    }

    String getMapperType(String field) {
        Mapper mapper;
        if (this.mapperService != null && (mapper = this.mapperService.mappingLookup().getMapper(field)) != null) {
            return mapper.typeName();
        }
        return null;
    }

    static {
        HashSet<String> includeMetaField = new HashSet<String>(3);
        includeMetaField.add("_tsid");
        includeMetaField.add("_ts_routing_hash");
        includeMetaField.add("_seq_no");
        INCLUDE_META_FIELDS = Collections.unmodifiableSet(includeMetaField);
        EXCLUDE_MAPPER_TYPES = Set.of("geo_shape");
        docValuesFormat = new Lucene90DocValuesFormat();
        tsdbDocValuesFormat = ES819TSDBDocValuesFormat.getInstance(false);
        tsdbDocValuesFormatLargeNumericBlock = ES819TSDBDocValuesFormat.getInstance(true);
        es812PostingsFormat = new ES812PostingsFormat();
        completionPostingsFormat = PostingsFormat.forName((String)"Completion101");
    }
}

