/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.function.Supplier;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractAsyncTask;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.CloseUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexWarmer;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.MergeMetrics;
import org.elasticsearch.index.engine.ThreadPoolMergeExecutorService;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsAccounting;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperRegistry;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NodeMappingStats;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.SearchIndexNameMatcher;
import org.elasticsearch.index.search.stats.SearchStatsSettings;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.GlobalCheckpointSyncer;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStatsSettings;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.index.shard.ShardNotInPrimaryModeException;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndexRemovalReason;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class IndexService
extends AbstractIndexComponent
implements IndicesClusterStateService.AllocatedIndex<IndexShard> {
    private final IndexEventListener eventListener;
    private final IndexFieldDataService indexFieldData;
    private final BitsetFilterCache bitsetFilterCache;
    private final NodeEnvironment nodeEnv;
    private final ShardStoreDeleter shardStoreDeleter;
    private final IndexStorePlugin.IndexFoldersDeletionListener indexFoldersDeletionListener;
    private final IndexStorePlugin.DirectoryFactory directoryFactory;
    private final IndexStorePlugin.RecoveryStateFactory recoveryStateFactory;
    private final IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier;
    private final CheckedFunction<DirectoryReader, DirectoryReader, IOException> readerWrapper;
    private final Engine.IndexCommitListener indexCommitListener;
    private final IndexCache indexCache;
    private final MapperService mapperService;
    private final XContentParserConfiguration parserConfiguration;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final SimilarityService similarityService;
    private final EngineFactory engineFactory;
    private final IndexWarmer warmer;
    private volatile Map<Integer, IndexShard> shards = Map.of();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean(false);
    private final IndexSettings indexSettings;
    private final IndexAnalyzers indexAnalyzers;
    private final List<SearchOperationListener> searchOperationListeners;
    private final List<IndexingOperationListener> indexingOperationListeners;
    private final BooleanSupplier allowExpensiveQueries;
    private volatile AsyncRefreshTask refreshTask;
    private volatile AsyncTranslogFSync fsyncTask;
    private final AsyncGlobalCheckpointTask globalCheckpointTask;
    private final AsyncRetentionLeaseSyncTask retentionLeaseSyncTask;
    private final String INDEX_TRANSLOG_RETENTION_CHECK_INTERVAL_SETTING = "index.translog.retention.check_interval";
    private final AsyncTrimTranslogTask trimTranslogTask;
    private final ThreadPool threadPool;
    @Nullable
    private final ThreadPoolMergeExecutorService threadPoolMergeExecutorService;
    private final BigArrays bigArrays;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final Client client;
    private final CircuitBreakerService circuitBreakerService;
    private final IndexNameExpressionResolver expressionResolver;
    private final Supplier<Sort> indexSortSupplier;
    private final ValuesSourceRegistry valuesSourceRegistry;
    private final MapperMetrics mapperMetrics;
    private final IndexingStatsSettings indexingStatsSettings;
    private final SearchStatsSettings searchStatsSettings;
    private final MergeMetrics mergeMetrics;
    private final CopyOnWriteArrayList<Consumer<IndexMetadata>> metadataListeners = new CopyOnWriteArrayList();
    public static final Setting<TimeValue> GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.global_checkpoint_sync.interval", new TimeValue(30L, TimeUnit.SECONDS), new TimeValue(0L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> RETENTION_LEASE_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.soft_deletes.retention_lease.sync_interval", new TimeValue(30L, TimeUnit.SECONDS), new TimeValue(0L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);

    public IndexService(IndexSettings indexSettings, IndexCreationContext indexCreationContext, NodeEnvironment nodeEnv, XContentParserConfiguration parserConfiguration, SimilarityService similarityService, ShardStoreDeleter shardStoreDeleter, IndexAnalyzers indexAnalyzers, EngineFactory engineFactory, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, ThreadPool threadPool, ThreadPoolMergeExecutorService threadPoolMergeExecutorService, ScriptService scriptService, ClusterService clusterService, Client client, QueryCache queryCache, IndexStorePlugin.DirectoryFactory directoryFactory, IndexEventListener eventListener, Function<IndexService, CheckedFunction<DirectoryReader, DirectoryReader, IOException>> wrapperFactory, MapperRegistry mapperRegistry, IndicesFieldDataCache indicesFieldDataCache, List<SearchOperationListener> searchOperationListeners, List<IndexingOperationListener> indexingOperationListeners, NamedWriteableRegistry namedWriteableRegistry, IdFieldMapper idFieldMapper, BooleanSupplier allowExpensiveQueries, IndexNameExpressionResolver expressionResolver, ValuesSourceRegistry valuesSourceRegistry, IndexStorePlugin.RecoveryStateFactory recoveryStateFactory, IndexStorePlugin.IndexFoldersDeletionListener indexFoldersDeletionListener, IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier, Engine.IndexCommitListener indexCommitListener, MapperMetrics mapperMetrics, IndexingStatsSettings indexingStatsSettings, SearchStatsSettings searchStatsSettings, MergeMetrics mergeMetrics) {
        super(indexSettings);
        assert (indexCreationContext != IndexCreationContext.RELOAD_ANALYZERS) : "IndexCreationContext.RELOAD_ANALYZERS should only be used when reloading analysers";
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.indexSettings = indexSettings;
        this.parserConfiguration = parserConfiguration;
        this.similarityService = similarityService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.circuitBreakerService = circuitBreakerService;
        this.expressionResolver = expressionResolver;
        this.valuesSourceRegistry = valuesSourceRegistry;
        this.snapshotCommitSupplier = snapshotCommitSupplier;
        this.indexAnalyzers = indexAnalyzers;
        if (IndexService.needsMapperService(indexSettings, indexCreationContext)) {
            assert (indexAnalyzers != null);
            this.bitsetFilterCache = new BitsetFilterCache(indexSettings, new BitsetCacheListener(this));
            this.mapperService = new MapperService(clusterService, indexSettings, indexAnalyzers, parserConfiguration, similarityService, mapperRegistry, () -> this.newSearchExecutionContext(0, 0, null, System::currentTimeMillis, null, Collections.emptyMap()), idFieldMapper, (ScriptCompiler)scriptService, this.bitsetFilterCache::getBitSetProducer, mapperMetrics, null);
            this.indexFieldData = new IndexFieldDataService(indexSettings, indicesFieldDataCache, circuitBreakerService);
            boolean sourceOnly = indexSettings.getSettings().getAsBoolean("index.source_only", false);
            this.indexSortSupplier = indexSettings.getIndexSortConfig().hasIndexSort() && !sourceOnly ? () -> indexSettings.getIndexSortConfig().buildIndexSort(this.mapperService::fieldType, (fieldType, searchLookup) -> this.loadFielddata((MappedFieldType)fieldType, FieldDataContext.noRuntimeFields(indexSettings.getIndex().getName(), "index sort"))) : () -> null;
            this.indexFieldData.setListener(new FieldDataCacheListener(this));
            this.warmer = new IndexWarmer(threadPool, this.indexFieldData, this.bitsetFilterCache.createListener(threadPool));
            this.indexCache = new IndexCache(queryCache, this.bitsetFilterCache);
        } else {
            assert (indexAnalyzers == null);
            this.mapperService = null;
            this.indexFieldData = null;
            this.indexSortSupplier = () -> null;
            this.bitsetFilterCache = null;
            this.warmer = null;
            this.indexCache = null;
        }
        this.shardStoreDeleter = shardStoreDeleter;
        this.indexFoldersDeletionListener = indexFoldersDeletionListener;
        this.bigArrays = bigArrays;
        this.threadPool = threadPool;
        this.threadPoolMergeExecutorService = threadPoolMergeExecutorService;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.client = client;
        this.eventListener = eventListener;
        this.nodeEnv = nodeEnv;
        this.directoryFactory = directoryFactory;
        this.recoveryStateFactory = recoveryStateFactory;
        this.engineFactory = Objects.requireNonNull(engineFactory);
        this.readerWrapper = wrapperFactory.apply(this);
        this.searchOperationListeners = Collections.unmodifiableList(searchOperationListeners);
        this.indexingOperationListeners = Collections.unmodifiableList(indexingOperationListeners);
        this.indexCommitListener = indexCommitListener;
        this.mapperMetrics = mapperMetrics;
        try (ThreadContext.StoredContext ignored = threadPool.getThreadContext().clearTraceContext();){
            this.refreshTask = new AsyncRefreshTask(this);
            this.trimTranslogTask = new AsyncTrimTranslogTask(this, this);
            this.globalCheckpointTask = new AsyncGlobalCheckpointTask(this);
            this.retentionLeaseSyncTask = new AsyncRetentionLeaseSyncTask(this);
        }
        this.indexingStatsSettings = indexingStatsSettings;
        this.searchStatsSettings = searchStatsSettings;
        this.mergeMetrics = mergeMetrics;
        this.updateFsyncTaskIfNecessary();
    }

    static boolean needsMapperService(IndexSettings indexSettings, IndexCreationContext indexCreationContext) {
        return false == (indexSettings.getIndexMetadata().getState() == IndexMetadata.State.CLOSE && indexCreationContext == IndexCreationContext.CREATE_INDEX);
    }

    public int numberOfShards() {
        return this.shards.size();
    }

    public IndexEventListener getIndexEventListener() {
        return this.eventListener;
    }

    @Override
    public Iterator<IndexShard> iterator() {
        return this.shards.values().iterator();
    }

    public boolean hasShard(int shardId) {
        return this.shards.containsKey(shardId);
    }

    @Override
    @Nullable
    public IndexShard getShardOrNull(int shardId) {
        return this.shards.get(shardId);
    }

    public IndexShard getShard(int shardId) {
        IndexShard indexShard = this.getShardOrNull(shardId);
        if (indexShard == null) {
            throw new ShardNotFoundException(new ShardId(this.index(), shardId));
        }
        return indexShard;
    }

    public NodeMappingStats getNodeMappingStats() {
        if (this.mapperService == null) {
            return null;
        }
        long numFields = this.mapperService().mappingLookup().getTotalMapperCount();
        long totalEstimatedOverhead = numFields * 1024L;
        int numLeaves = 0;
        for (IndexShard shard : this.shards.values()) {
            try {
                numLeaves += shard.commitStats().getNumLeaves();
            }
            catch (AlreadyClosedException alreadyClosedException) {}
        }
        return new NodeMappingStats(numFields, totalEstimatedOverhead, numLeaves, (long)numLeaves * numFields);
    }

    public Set<Integer> shardIds() {
        return this.shards.keySet();
    }

    public IndexCache cache() {
        return this.indexCache;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SimilarityService similarityService() {
        return this.similarityService;
    }

    public Supplier<Sort> getIndexSortSupplier() {
        return this.indexSortSupplier;
    }

    public synchronized void close(String reason, boolean delete, Executor shardCloseExecutor, ActionListener<Void> closeListener) {
        if (this.closed.compareAndSet(false, true)) {
            this.deleted.compareAndSet(false, delete);
            try (RefCountingRunnable refs = new RefCountingRunnable(() -> ActionListener.run(closeListener, l -> {
                IOUtils.close((Closeable[])new Closeable[]{this.bitsetFilterCache, this.indexCache, this.indexFieldData, this.indexAnalyzers, this.refreshTask, this.fsyncTask, this.trimTranslogTask, this.globalCheckpointTask, this.retentionLeaseSyncTask});
                l.onResponse(null);
            }));){
                Set<Integer> shardIds = this.shardIds();
                for (int shardId : shardIds) {
                    ActionListener.run(refs.acquireListener().delegateResponse((l, e) -> {
                        this.logger.warn("failed to close shard", (Throwable)e);
                        l.onResponse(null);
                    }), l -> this.removeShard(shardId, reason, shardCloseExecutor, (ActionListener<Void>)l));
                }
            }
        } else {
            closeListener.onResponse(null);
        }
    }

    public synchronized void writeDanglingIndicesInfo() {
        if (this.closed.get()) {
            return;
        }
        try {
            IndexMetadata.FORMAT.writeAndCleanup(this.getMetadata(), this.nodeEnv.indexPaths(this.index()));
        }
        catch (WriteStateException e) {
            this.logger.warn(() -> Strings.format((String)"failed to write dangling indices state for index %s", (Object[])new Object[]{this.index()}), (Throwable)e);
        }
    }

    public synchronized void deleteDanglingIndicesInfo() {
        if (this.closed.get()) {
            return;
        }
        try {
            MetadataStateFormat.deleteMetaState(this.nodeEnv.indexPaths(this.index()));
        }
        catch (IOException e) {
            this.logger.warn(() -> Strings.format((String)"failed to delete dangling indices state for index %s", (Object[])new Object[]{this.index()}), (Throwable)e);
        }
    }

    public String indexUUID() {
        return this.indexSettings.getUUID();
    }

    private long getAvgShardSizeInBytes() throws IOException {
        long sum = 0L;
        int count = 0;
        for (IndexShard indexShard : this) {
            sum += indexShard.store().stats(0L, LongUnaryOperator.identity()).sizeInBytes();
            ++count;
        }
        if (count == 0) {
            return -1L;
        }
        return sum / (long)count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IndexShard createShard(ShardRouting routing, GlobalCheckpointSyncer globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer) throws IOException {
        IndexShard indexShard;
        block14: {
            IndexShard indexShard2;
            Store store;
            ShardId shardId;
            block15: {
                Objects.requireNonNull(retentionLeaseSyncer);
                if (this.closed.get()) {
                    throw new IllegalStateException("Can't create shard " + String.valueOf(routing.shardId()) + ", closed");
                }
                Settings indexSettings = this.indexSettings.getSettings();
                shardId = routing.shardId();
                boolean success = false;
                store = null;
                indexShard2 = null;
                ShardLock lock = null;
                this.eventListener.beforeIndexShardCreated(routing, indexSettings);
                try {
                    ShardPath path;
                    lock = this.nodeEnv.shardLock(shardId, "starting shard");
                    try {
                        path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, this.indexSettings.customDataPath());
                    }
                    catch (IllegalStateException ex) {
                        this.logger.warn("{} failed to load shard path, trying to remove leftover", (Object)shardId);
                        try {
                            ShardPath.deleteLeftoverShardDirectory(this.logger, this.nodeEnv, lock, this.indexSettings, shardPaths -> this.indexFoldersDeletionListener.beforeShardFoldersDeleted(shardId, this.indexSettings, (Path[])shardPaths, IndexRemovalReason.FAILURE));
                            path = ShardPath.loadShardPath(this.logger, this.nodeEnv, shardId, this.indexSettings.customDataPath());
                        }
                        catch (Exception inner) {
                            ex.addSuppressed(inner);
                            throw ex;
                        }
                    }
                    if (path == null) {
                        HashMap<Path, Integer> dataPathToShardCount = new HashMap<Path, Integer>();
                        for (IndexShard shard : this) {
                            Path dataPath = shard.shardPath().getRootStatePath();
                            Integer curCount = (Integer)dataPathToShardCount.get(dataPath);
                            if (curCount == null) {
                                curCount = 0;
                            }
                            dataPathToShardCount.put(dataPath, curCount + 1);
                        }
                        path = ShardPath.selectNewPathForShard(this.nodeEnv, shardId, this.indexSettings, routing.getExpectedShardSize() == -1L ? this.getAvgShardSizeInBytes() : routing.getExpectedShardSize(), dataPathToShardCount);
                        this.logger.debug("{} creating using a new path [{}]", (Object)shardId, (Object)path);
                    } else {
                        this.logger.debug("{} creating using an existing path [{}]", (Object)shardId, (Object)path);
                    }
                    if (this.shards.containsKey(shardId.id())) {
                        throw new IllegalStateException(String.valueOf(shardId) + " already exists");
                    }
                    this.logger.debug("creating shard_id {}", (Object)shardId);
                    Engine.Warmer engineWarmer = reader -> {
                        IndexShard shard = this.getShardOrNull(shardId.getId());
                        if (shard != null) {
                            this.warmer.warm(reader, shard, this.indexSettings);
                        }
                    };
                    Directory directory = this.directoryFactory.newDirectory(this.indexSettings, path, routing);
                    store = new Store(shardId, this.indexSettings, directory, lock, new StoreCloseListener(shardId, () -> this.eventListener.onStoreClosed(shardId)), this.indexSettings.getIndexSortConfig().hasIndexSort());
                    this.eventListener.onStoreCreated(shardId);
                    indexShard2 = new IndexShard(routing, this.indexSettings, path, store, this.indexSortSupplier, this.indexCache, this.mapperService, this.similarityService, this.engineFactory, this.eventListener, this.readerWrapper, this.threadPool, this.threadPoolMergeExecutorService, this.bigArrays, engineWarmer, this.searchOperationListeners, this.indexingOperationListeners, globalCheckpointSyncer, retentionLeaseSyncer, this.circuitBreakerService, this.snapshotCommitSupplier, System::nanoTime, this.indexCommitListener, this.mapperMetrics, this.indexingStatsSettings, this.searchStatsSettings, this.mergeMetrics);
                    this.eventListener.indexShardStateChanged(indexShard2, null, indexShard2.state(), "shard created");
                    this.eventListener.afterIndexShardCreated(indexShard2);
                    this.shards = Maps.copyMapWithAddedEntry(this.shards, shardId.id(), indexShard2);
                    success = true;
                    indexShard = indexShard2;
                    if (success) break block14;
                    if (lock == null) break block15;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (lock != null) {
                            IOUtils.closeWhileHandlingException((Closeable)lock);
                        }
                        Store finalStore = store;
                        IndexShard finalIndexShard = indexShard2;
                        CloseUtils.executeDirectly((CheckedConsumer<ActionListener<Void>, IOException>)((CheckedConsumer)l -> this.closeShard("initialization failed", shardId, finalIndexShard, finalStore, this.eventListener, EsExecutors.DIRECT_EXECUTOR_SERVICE, (ActionListener<Void>)l)));
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable)lock);
            }
            Store finalStore = store;
            IndexShard finalIndexShard = indexShard2;
            CloseUtils.executeDirectly((CheckedConsumer<ActionListener<Void>, IOException>)((CheckedConsumer)l -> this.closeShard("initialization failed", shardId, finalIndexShard, finalStore, this.eventListener, EsExecutors.DIRECT_EXECUTOR_SERVICE, (ActionListener<Void>)l)));
        }
        return indexShard;
    }

    @Override
    public synchronized void removeShard(int shardId, String reason, Executor closeExecutor, ActionListener<Void> closeListener) {
        IndexShard indexShard = this.shards.get(shardId);
        if (indexShard == null) {
            closeListener.onResponse(null);
            return;
        }
        this.logger.debug("[{}] closing... (reason: [{}])", (Object)shardId, (Object)reason);
        ActionListener<Void> wrappedListener = this.logger.isDebugEnabled() ? ActionListener.runBefore(closeListener, () -> this.logger.debug("[{}] closed (reason: [{}])", (Object)shardId, (Object)reason)) : closeListener;
        this.shards = Maps.copyMapWithRemovedEntry(this.shards, shardId);
        this.closeShard(reason, indexShard.shardId(), indexShard, indexShard.store(), indexShard.getIndexEventListener(), closeExecutor, wrappedListener);
        this.logger.debug("[{}] removed (reason: [{}])", (Object)shardId, (Object)reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeShard(String reason, ShardId sId, IndexShard indexShard, Store store, IndexEventListener listener, Executor closeExecutor, ActionListener<Void> closeListener) {
        block17: {
            int shardId = sId.id();
            Settings indexSettings = this.getIndexSettings().getSettings();
            if (store != null) {
                store.beforeClose();
            }
            try {
                boolean flushEngine;
                try {
                    listener.beforeIndexShardClosed(sId, indexShard, indexSettings);
                    if (indexShard == null) {
                        closeListener.onResponse(null);
                        break block17;
                    }
                    boolean bl = flushEngine = !this.deleted.get() && this.closed.get();
                }
                catch (Throwable throwable) {
                    if (indexShard == null) {
                        closeListener.onResponse(null);
                    } else {
                        boolean flushEngine2;
                        boolean bl = flushEngine2 = !this.deleted.get() && this.closed.get();
                        assert (store == null || store.hasReferences()) : "store exists but already closed";
                        boolean hasStoreRef = store != null && store.tryIncRef();
                        ActionListener.run(new ActionListener<Void>(){
                            final /* synthetic */ IndexEventListener val$listener;
                            final /* synthetic */ ShardId val$sId;
                            final /* synthetic */ IndexShard val$indexShard;
                            final /* synthetic */ Settings val$indexSettings;
                            final /* synthetic */ boolean val$hasStoreRef;
                            final /* synthetic */ Store val$store;
                            final /* synthetic */ ActionListener val$closeListener;
                            final /* synthetic */ int val$shardId;
                            {
                                this.val$listener = indexEventListener;
                                this.val$sId = shardId;
                                this.val$indexShard = indexShard;
                                this.val$indexSettings = settings;
                                this.val$hasStoreRef = bl;
                                this.val$store = store;
                                this.val$closeListener = actionListener;
                                this.val$shardId = n;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void onResponse(Void unused) {
                                try {
                                    this.val$listener.afterIndexShardClosed(this.val$sId, this.val$indexShard, this.val$indexSettings);
                                }
                                finally {
                                    try {
                                        if (this.val$hasStoreRef) {
                                            this.val$store.decRef();
                                        }
                                    }
                                    finally {
                                        this.val$closeListener.onResponse(null);
                                    }
                                }
                            }

                            @Override
                            public void onFailure(Exception e) {
                                IndexService.this.logger.debug(() -> "[" + this.val$shardId + "] failed to close index shard", (Throwable)e);
                                this.onResponse(null);
                            }
                        }, l -> indexShard.close(reason, flushEngine2, closeExecutor, (ActionListener<Void>)l));
                        listener.afterIndexShardClosing(sId, indexShard, indexSettings);
                    }
                    throw throwable;
                }
                assert (store == null || store.hasReferences()) : "store exists but already closed";
                boolean hasStoreRef = store != null && store.tryIncRef();
                ActionListener.run(new /* invalid duplicate definition of identical inner class */, l -> indexShard.close(reason, flushEngine2, closeExecutor, (ActionListener<Void>)l));
                listener.afterIndexShardClosing(sId, indexShard, indexSettings);
            }
            finally {
                try {
                    if (store != null) {
                        store.close();
                    } else {
                        this.logger.trace("[{}] store not initialized prior to closing shard, nothing to close", (Object)shardId);
                    }
                }
                catch (Exception e) {
                    this.logger.warn(() -> Strings.format((String)"[%s] failed to close store on shard removal (reason: [%s])", (Object[])new Object[]{shardId, reason}), (Throwable)e);
                }
            }
        }
    }

    private void onShardClose(ShardLock lock) {
        if (this.deleted.get()) {
            try {
                try {
                    this.eventListener.beforeIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                }
                finally {
                    this.shardStoreDeleter.deleteShardStore("delete index", lock, this.indexSettings, IndexRemovalReason.DELETED);
                    this.eventListener.afterIndexShardDeleted(lock.getShardId(), this.indexSettings.getSettings());
                }
            }
            catch (IOException e) {
                this.shardStoreDeleter.addPendingDelete(lock.getShardId(), this.indexSettings, IndexRemovalReason.DELETED);
                this.logger.debug(() -> "[" + lock.getShardId().id() + "] failed to delete shard content - scheduled a retry", (Throwable)e);
            }
        }
    }

    public RecoveryState createRecoveryState(ShardRouting shardRouting, DiscoveryNode targetNode, DiscoveryNode sourceNode) {
        return this.recoveryStateFactory.newRecoveryState(shardRouting, targetNode, sourceNode);
    }

    @Override
    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public SearchExecutionContext newSearchExecutionContext(int shardId, int shardRequestIndex, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Map<String, Object> runtimeMappings) {
        return this.newSearchExecutionContext(shardId, shardRequestIndex, searcher, nowInMillis, clusterAlias, runtimeMappings, null);
    }

    public SearchExecutionContext newSearchExecutionContext(int shardId, int shardRequestIndex, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Map<String, Object> runtimeMappings, Integer requestSize) {
        SearchIndexNameMatcher indexNameMatcher = new SearchIndexNameMatcher(this.index().getName(), clusterAlias, this.clusterService, this.expressionResolver);
        MapperService mapperService = this.mapperService();
        return new SearchExecutionContext(shardId, shardRequestIndex, this.indexSettings, this.indexCache.bitsetFilterCache(), this::loadFielddata, mapperService, mapperService.mappingLookup(), this.similarityService(), this.scriptService, this.parserConfiguration, this.namedWriteableRegistry, this.client, searcher, nowInMillis, clusterAlias, indexNameMatcher, this.allowExpensiveQueries, this.valuesSourceRegistry, runtimeMappings, requestSize, this.mapperMetrics);
    }

    public QueryRewriteContext newQueryRewriteContext(LongSupplier nowInMillis, Map<String, Object> runtimeMappings, String clusterAlias) {
        SearchIndexNameMatcher indexNameMatcher = new SearchIndexNameMatcher(this.index().getName(), clusterAlias, this.clusterService, this.expressionResolver);
        MapperService mapperService = this.mapperService();
        MappingLookup mappingLookup = mapperService.mappingLookup();
        return new QueryRewriteContext(this.parserConfiguration, this.client, nowInMillis, mapperService, mappingLookup, IndexService.parseRuntimeMappings(runtimeMappings, mapperService, this.indexSettings, mappingLookup), this.indexSettings, null, clusterAlias, new Index(RemoteClusterAware.buildRemoteIndexName(clusterAlias, this.indexSettings.getIndex().getName()), this.indexSettings.getIndex().getUUID()), indexNameMatcher, this.namedWriteableRegistry, this.valuesSourceRegistry, this.allowExpensiveQueries, this.scriptService, null, null, null, null, false, false);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public ThreadPoolMergeExecutorService getThreadPoolMergeExecutorService() {
        return this.threadPoolMergeExecutorService;
    }

    public BigArrays getBigArrays() {
        return this.bigArrays;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public CircuitBreakerService breakerService() {
        return this.circuitBreakerService;
    }

    List<IndexingOperationListener> getIndexOperationListeners() {
        return this.indexingOperationListeners;
    }

    List<SearchOperationListener> getSearchOperationListener() {
        return this.searchOperationListeners;
    }

    @Override
    public void updateMapping(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) {
        if (this.mapperService != null) {
            this.mapperService.updateMapping(currentIndexMetadata, newIndexMetadata);
        }
    }

    public IndexMetadata getMetadata() {
        return this.indexSettings.getIndexMetadata();
    }

    public void addMetadataListener(Consumer<IndexMetadata> listener) {
        this.metadataListeners.add(listener);
    }

    @Override
    public synchronized void updateMetadata(IndexMetadata currentIndexMetadata, IndexMetadata newIndexMetadata) {
        boolean updateIndexSettings = this.indexSettings.updateIndexMetadata(newIndexMetadata);
        if (Assertions.ENABLED && currentIndexMetadata != null) {
            long newSettingsVersion;
            long currentSettingsVersion = currentIndexMetadata.getSettingsVersion();
            if (currentSettingsVersion == (newSettingsVersion = newIndexMetadata.getSettingsVersion())) {
                assert (!updateIndexSettings) : "No index updates are expected as index settings version has not changed";
            } else {
                assert (updateIndexSettings) : "Index updates are expected as index settings version has changed";
                assert (currentSettingsVersion < newSettingsVersion) : "expected current settings version [" + currentSettingsVersion + "] to be less than new settings version [" + newSettingsVersion + "]";
            }
        }
        if (updateIndexSettings) {
            for (IndexShard shard : this.shards.values()) {
                try {
                    shard.onSettingsChanged();
                }
                catch (Exception e) {
                    this.logger.warn(() -> "[" + shard.shardId().id() + "] failed to notify shard about setting change", (Throwable)e);
                }
            }
            if (!this.refreshTask.getInterval().equals((Object)this.indexSettings.getRefreshInterval())) {
                this.threadPool.executor("refresh").execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        IndexService.this.logger.warn("forced refresh failed after interval change", (Throwable)e);
                    }

                    @Override
                    protected void doRun() {
                        IndexService.this.maybeRefreshEngine(true);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return true;
                    }
                });
                this.rescheduleRefreshTasks();
            }
            this.updateFsyncTaskIfNecessary();
        }
        this.metadataListeners.forEach((Consumer<Consumer<IndexMetadata>>)((Consumer<Consumer>)c -> c.accept(newIndexMetadata)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFsyncTaskIfNecessary() {
        if (this.indexSettings.getTranslogDurability() == Translog.Durability.REQUEST) {
            try {
                if (this.fsyncTask == null) return;
                this.fsyncTask.close();
                return;
            }
            finally {
                this.fsyncTask = null;
            }
        } else if (this.fsyncTask == null) {
            this.fsyncTask = new AsyncTranslogFSync(this);
            return;
        } else {
            this.fsyncTask.updateIfNeeded();
        }
    }

    private void rescheduleRefreshTasks() {
        try {
            this.refreshTask.close();
        }
        finally {
            this.refreshTask = new AsyncRefreshTask(this);
        }
    }

    public static Function<String, String> dateMathExpressionResolverAt() {
        return expression -> IndexNameExpressionResolver.resolveDateMathExpression(expression, System.currentTimeMillis());
    }

    public static Function<String, String> dateMathExpressionResolverAt(long instant) {
        return expression -> IndexNameExpressionResolver.resolveDateMathExpression(expression, instant);
    }

    public final EngineFactory getEngineFactory() {
        return this.engineFactory;
    }

    final CheckedFunction<DirectoryReader, DirectoryReader, IOException> getReaderWrapper() {
        return this.readerWrapper;
    }

    final IndexStorePlugin.DirectoryFactory getDirectoryFactory() {
        return this.directoryFactory;
    }

    private void maybeFSyncTranslogs() {
        if (this.indexSettings.getTranslogDurability() == Translog.Durability.ASYNC) {
            for (IndexShard shard : this.shards.values()) {
                try {
                    if (!shard.isSyncNeeded()) continue;
                    shard.sync();
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (IOException e) {
                    this.logger.warn("failed to sync translog", (Throwable)e);
                }
            }
        }
    }

    private void maybeRefreshEngine(boolean force) {
        if (this.indexSettings.getRefreshInterval().millis() > 0L || force) {
            for (IndexShard shard : this.shards.values()) {
                shard.scheduledRefresh(new ActionListener<Boolean>(){

                    @Override
                    public void onResponse(Boolean ignored) {
                    }

                    @Override
                    public void onFailure(Exception e) {
                        if (!(e instanceof IndexShardClosedException) && !(e instanceof AlreadyClosedException)) {
                            IndexService.this.logger.warn("unexpected exception while performing scheduled refresh", (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    private void maybeTrimTranslog() {
        block6: for (IndexShard shard : this.shards.values()) {
            switch (shard.state()) {
                case CREATED: 
                case RECOVERING: 
                case CLOSED: {
                    continue block6;
                }
                case POST_RECOVERY: 
                case STARTED: {
                    try {
                        shard.trimTranslog();
                    }
                    catch (AlreadyClosedException | IndexShardClosedException throwable) {}
                    continue block6;
                }
            }
            throw new IllegalStateException("unknown state: " + String.valueOf((Object)shard.state()));
        }
    }

    private void maybeSyncGlobalCheckpoints() {
        this.sync(is -> is.maybeSyncGlobalCheckpoint("background"), "global checkpoint");
    }

    private void syncRetentionLeases() {
        this.sync(IndexShard::syncRetentionLeases, "retention lease");
    }

    private void sync(Consumer<IndexShard> sync, String source) {
        block7: for (IndexShard shard : this.shards.values()) {
            if (!shard.routingEntry().active() || !shard.routingEntry().primary()) continue;
            switch (shard.state()) {
                case CREATED: 
                case RECOVERING: 
                case CLOSED: {
                    continue block7;
                }
                case POST_RECOVERY: {
                    assert (false) : "shard " + String.valueOf(shard.shardId()) + " is in post-recovery but marked as active";
                    continue block7;
                }
                case STARTED: {
                    try {
                        shard.runUnderPrimaryPermit(() -> sync.accept(shard), e -> {
                            if (!(e instanceof AlreadyClosedException || e instanceof IndexShardClosedException || e instanceof ShardNotInPrimaryModeException)) {
                                this.logger.warn(() -> Strings.format((String)"%s failed to execute %s sync", (Object[])new Object[]{shard.shardId(), source}), (Throwable)e);
                            }
                        }, EsExecutors.DIRECT_EXECUTOR_SERVICE);
                    }
                    catch (AlreadyClosedException | IndexShardClosedException throwable) {}
                    continue block7;
                }
            }
            throw new IllegalStateException("unknown state [" + String.valueOf((Object)shard.state()) + "]");
        }
    }

    AsyncRefreshTask getRefreshTask() {
        return this.refreshTask;
    }

    AsyncTranslogFSync getFsyncTask() {
        return this.fsyncTask;
    }

    AsyncTrimTranslogTask getTrimTranslogTask() {
        return this.trimTranslogTask;
    }

    public boolean clearCaches(boolean queryCache, boolean fieldDataCache, String ... fields) {
        boolean clearedAtLeastOne = false;
        if (queryCache) {
            clearedAtLeastOne = true;
            this.indexCache.query().clear("api");
        }
        if (fieldDataCache) {
            clearedAtLeastOne = true;
            if (fields.length == 0) {
                this.indexFieldData.clear();
            } else {
                for (String field : fields) {
                    this.indexFieldData.clearField(field);
                }
            }
        }
        if (!clearedAtLeastOne) {
            if (fields.length == 0) {
                this.indexCache.clear("api");
                this.indexFieldData.clear();
            } else {
                for (String field : fields) {
                    this.indexFieldData.clearField(field);
                }
            }
        }
        return clearedAtLeastOne;
    }

    public static Map<String, MappedFieldType> parseRuntimeMappings(Map<String, Object> runtimeMappings, MapperService mapperService, IndexSettings indexSettings, MappingLookup lookup) {
        if (runtimeMappings.isEmpty()) {
            return Collections.emptyMap();
        }
        MappingParserContext parserContext = mapperService.parserContext();
        Map<String, RuntimeField> runtimeFields = RuntimeField.parseRuntimeFields(new HashMap<String, Object>(runtimeMappings), parserContext, false);
        Map<String, MappedFieldType> runtimeFieldTypes = RuntimeField.collectFieldTypes(runtimeFields.values());
        if (!indexSettings.getIndexMetadata().getRoutingPaths().isEmpty()) {
            for (String r : runtimeMappings.keySet()) {
                if (!Regex.simpleMatch(indexSettings.getIndexMetadata().getRoutingPaths(), r)) continue;
                throw new IllegalArgumentException("runtime fields may not match [routing_path] but [" + r + "] matched");
            }
        }
        runtimeFieldTypes.keySet().forEach(lookup::validateDoesNotShadow);
        return runtimeFieldTypes;
    }

    public IndexFieldData<?> loadFielddata(MappedFieldType fieldType, FieldDataContext fieldDataContext) {
        return this.indexFieldData.getForField(fieldType, fieldDataContext);
    }

    public static enum IndexCreationContext {
        CREATE_INDEX,
        METADATA_VERIFICATION,
        RELOAD_ANALYZERS;

    }

    private static final class BitsetCacheListener
    implements BitsetFilterCache.Listener {
        final IndexService indexService;

        private BitsetCacheListener(IndexService indexService) {
            this.indexService = indexService;
        }

        @Override
        public void onCache(ShardId shardId, Accountable accountable) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onCached(ramBytesUsed);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, Accountable accountable) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                long ramBytesUsed = accountable != null ? accountable.ramBytesUsed() : 0L;
                shard.shardBitsetFilterCache().onRemoval(ramBytesUsed);
            }
        }
    }

    private static final class FieldDataCacheListener
    implements IndexFieldDataCache.Listener {
        final IndexService indexService;

        FieldDataCacheListener(IndexService indexService) {
            this.indexService = indexService;
        }

        @Override
        public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                shard.fieldData().onCache(shardId, fieldName, ramUsage);
            }
        }

        @Override
        public void onCache(ShardId shardId, String fieldName, GlobalOrdinalsAccounting info) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                shard.fieldData().onCache(shardId, fieldName, info);
            }
        }

        @Override
        public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
            IndexShard shard;
            if (shardId != null && (shard = this.indexService.getShardOrNull(shardId.id())) != null) {
                shard.fieldData().onRemoval(shardId, fieldName, wasEvicted, sizeInBytes);
            }
        }
    }

    public static interface ShardStoreDeleter {
        public void deleteShardStore(String var1, ShardLock var2, IndexSettings var3, IndexRemovalReason var4) throws IOException;

        public void addPendingDelete(ShardId var1, IndexSettings var2, IndexRemovalReason var3);
    }

    static final class AsyncRefreshTask
    extends BaseAsyncTask {
        AsyncRefreshTask(IndexService indexService) {
            super(indexService, indexService.threadPool.executor("refresh"), indexService.getIndexSettings().getRefreshInterval());
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeRefreshEngine(false);
        }

        public String toString() {
            return "refresh";
        }
    }

    final class AsyncTrimTranslogTask
    extends BaseAsyncTask {
        AsyncTrimTranslogTask(IndexService this$0, IndexService indexService) {
            super(indexService, this$0.threadPool.generic(), indexService.getIndexSettings().getSettings().getAsTime("index.translog.retention.check_interval", TimeValue.timeValueMinutes((long)10L)));
        }

        @Override
        protected boolean mustReschedule() {
            return !this.indexService.closed.get();
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeTrimTranslog();
        }

        public String toString() {
            return "trim_translog";
        }
    }

    private static final class AsyncGlobalCheckpointTask
    extends BaseAsyncTask {
        AsyncGlobalCheckpointTask(IndexService indexService) {
            super(indexService, indexService.getThreadPool().generic(), GLOBAL_CHECKPOINT_SYNC_INTERVAL_SETTING.get(indexService.getIndexSettings().getSettings()));
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeSyncGlobalCheckpoints();
        }

        public String toString() {
            return "global_checkpoint_sync";
        }
    }

    private static final class AsyncRetentionLeaseSyncTask
    extends BaseAsyncTask {
        AsyncRetentionLeaseSyncTask(IndexService indexService) {
            super(indexService, indexService.threadPool.executor("management"), RETENTION_LEASE_SYNC_INTERVAL_SETTING.get(indexService.getIndexSettings().getSettings()));
        }

        @Override
        protected void runInternal() {
            this.indexService.syncRetentionLeases();
        }

        public String toString() {
            return "retention_lease_sync";
        }
    }

    private class StoreCloseListener
    implements Store.OnClose {
        private final ShardId shardId;
        private final Closeable[] toClose;

        StoreCloseListener(ShardId shardId, Closeable ... toClose) {
            this.shardId = shardId;
            this.toClose = toClose;
        }

        @Override
        public void accept(ShardLock lock) {
            try {
                assert (lock.getShardId().equals(this.shardId)) : "shard id mismatch, expected: " + String.valueOf(this.shardId) + " but got: " + String.valueOf(lock.getShardId());
                IndexService.this.onShardClose(lock);
            }
            finally {
                try {
                    IOUtils.close((Closeable[])this.toClose);
                }
                catch (IOException ex) {
                    IndexService.this.logger.debug("failed to close resource", (Throwable)ex);
                }
            }
        }
    }

    static final class AsyncTranslogFSync
    extends BaseAsyncTask {
        AsyncTranslogFSync(IndexService indexService) {
            super(indexService, indexService.threadPool.executor("flush"), indexService.getIndexSettings().getTranslogSyncInterval());
        }

        @Override
        protected void runInternal() {
            this.indexService.maybeFSyncTranslogs();
        }

        void updateIfNeeded() {
            TimeValue newInterval = this.indexService.getIndexSettings().getTranslogSyncInterval();
            if (!newInterval.equals((Object)this.getInterval())) {
                this.setInterval(newInterval);
            }
        }

        public String toString() {
            return "translog_sync";
        }
    }

    static abstract class BaseAsyncTask
    extends AbstractAsyncTask {
        protected final IndexService indexService;

        BaseAsyncTask(IndexService indexService, Executor executor, TimeValue interval) {
            super(indexService.logger, indexService.threadPool, executor, interval, true);
            this.indexService = indexService;
            this.rescheduleIfNecessary();
        }

        @Override
        protected boolean mustReschedule() {
            return !this.indexService.closed.get() && this.indexService.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN;
        }
    }
}

