/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health.node.selection;

import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.TaskId;

public class HealthNode
extends AllocatedPersistentTask {
    public static final String TASK_NAME = "health-node";

    HealthNode(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers) {
        super(id, type, action, description, parentTask, headers);
    }

    @Override
    protected void onCancelled() {
        this.markAsCompleted();
    }

    @Nullable
    public static PersistentTasksCustomMetadata.PersistentTask<?> findTask(ClusterState clusterState) {
        return ClusterPersistentTasksCustomMetadata.getTaskWithId(clusterState, TASK_NAME);
    }

    @Nullable
    public static DiscoveryNode findHealthNode(ClusterState clusterState) {
        PersistentTasksCustomMetadata.PersistentTask<?> task = HealthNode.findTask(clusterState);
        if (task == null || !task.isAssigned()) {
            return null;
        }
        return clusterState.nodes().get(task.getAssignment().getExecutorNode());
    }
}

