/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public class FieldValueFactorFunction
extends ScoreFunction {
    private final String field;
    private final float boostFactor;
    private final Modifier modifier;
    private final Double missing;
    private final IndexNumericFieldData indexFieldData;

    public FieldValueFactorFunction(String field, float boostFactor, Modifier modifierType, Double missing, IndexNumericFieldData indexFieldData) {
        super(CombineFunction.MULTIPLY);
        this.field = field;
        this.boostFactor = boostFactor;
        this.modifier = modifierType;
        this.indexFieldData = indexFieldData;
        this.missing = missing;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) {
        final SortedNumericDoubleValues values = this.indexFieldData == null ? FieldData.emptySortedNumericDoubles() : ((LeafNumericFieldData)this.indexFieldData.load(ctx)).getDoubleValues();
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                double value;
                if (values.advanceExact(docId)) {
                    value = values.nextValue();
                } else if (FieldValueFactorFunction.this.missing != null) {
                    value = FieldValueFactorFunction.this.missing;
                } else {
                    throw new IllegalArgumentException("Missing value for field [" + FieldValueFactorFunction.this.field + "]");
                }
                double val = value * (double)FieldValueFactorFunction.this.boostFactor;
                double result = FieldValueFactorFunction.this.modifier.apply(val);
                if (result < 0.0) {
                    String message = "field value function must not produce negative scores, but got: [" + result + "] for field value: [" + value + "]";
                    if (FieldValueFactorFunction.this.modifier == Modifier.LN) {
                        message = message + "; consider using ln1p or ln2p instead of ln to avoid negative scores";
                    } else if (FieldValueFactorFunction.this.modifier == Modifier.LOG) {
                        message = message + "; consider using log1p or log2p instead of log to avoid negative scores";
                    }
                    throw new IllegalArgumentException(message);
                }
                return result;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                String modifierStr = FieldValueFactorFunction.this.modifier != null ? FieldValueFactorFunction.this.modifier.toString() : "";
                String defaultStr = FieldValueFactorFunction.this.missing != null ? "?:" + FieldValueFactorFunction.this.missing : "";
                double score = this.score(docId, subQueryScore.getValue().floatValue());
                return Explanation.match((Number)Float.valueOf((float)score), (String)String.format(Locale.ROOT, "field value function: %s(doc['%s'].value%s * factor=%s)", modifierStr, FieldValueFactorFunction.this.field, defaultStr, Float.valueOf(FieldValueFactorFunction.this.boostFactor)), (Explanation[])new Explanation[0]);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        FieldValueFactorFunction fieldValueFactorFunction = (FieldValueFactorFunction)other;
        return this.boostFactor == fieldValueFactorFunction.boostFactor && Objects.equals(this.field, fieldValueFactorFunction.field) && Objects.equals(this.modifier, fieldValueFactorFunction.modifier);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Float.valueOf(this.boostFactor), this.field, this.modifier);
    }

    public static enum Modifier implements Writeable
    {
        NONE{

            @Override
            public double apply(double n) {
                return n;
            }
        }
        ,
        LOG{

            @Override
            public double apply(double n) {
                return Math.log10(n);
            }
        }
        ,
        LOG1P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 1.0);
            }
        }
        ,
        LOG2P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 2.0);
            }
        }
        ,
        LN{

            @Override
            public double apply(double n) {
                return Math.log(n);
            }
        }
        ,
        LN1P{

            @Override
            public double apply(double n) {
                return Math.log1p(n);
            }
        }
        ,
        LN2P{

            @Override
            public double apply(double n) {
                return Math.log1p(n + 1.0);
            }
        }
        ,
        SQUARE{

            @Override
            public double apply(double n) {
                return Math.pow(n, 2.0);
            }
        }
        ,
        SQRT{

            @Override
            public double apply(double n) {
                return Math.sqrt(n);
            }
        }
        ,
        RECIPROCAL{

            @Override
            public double apply(double n) {
                return 1.0 / n;
            }
        };


        public abstract double apply(double var1);

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        public static Modifier readFromStream(StreamInput in) throws IOException {
            return in.readEnum(Modifier.class);
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static Modifier fromString(String modifier) {
            return Modifier.valueOf(modifier.toUpperCase(Locale.ROOT));
        }
    }
}

