/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GeoBoundingBox
extends BoundingBox<GeoPoint> {
    public static final ParseField LAT_FIELD = new ParseField("lat", new String[0]);
    public static final ParseField LON_FIELD = new ParseField("lon", new String[0]);

    public GeoBoundingBox(GeoPoint topLeft, GeoPoint bottomRight) {
        super(topLeft, bottomRight);
    }

    public GeoBoundingBox(StreamInput input) throws IOException {
        super(input.readGeoPoint(), input.readGeoPoint());
    }

    @Override
    public GeoPoint topLeft() {
        return (GeoPoint)this.topLeft;
    }

    @Override
    public GeoPoint bottomRight() {
        return (GeoPoint)this.bottomRight;
    }

    @Override
    public XContentBuilder toXContentFragment(XContentBuilder builder) throws IOException {
        builder.startObject(TOP_LEFT_FIELD.getPreferredName());
        builder.field(LAT_FIELD.getPreferredName(), ((GeoPoint)this.topLeft).getY());
        builder.field(LON_FIELD.getPreferredName(), ((GeoPoint)this.topLeft).getX());
        builder.endObject();
        builder.startObject(BOTTOM_RIGHT_FIELD.getPreferredName());
        builder.field(LAT_FIELD.getPreferredName(), ((GeoPoint)this.bottomRight).getY());
        builder.field(LON_FIELD.getPreferredName(), ((GeoPoint)this.bottomRight).getX());
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragmentWithArray(XContentBuilder builder) throws IOException {
        builder.array(TOP_LEFT_FIELD.getPreferredName(), new Object[]{((GeoPoint)this.topLeft).getX(), ((GeoPoint)this.topLeft).getY()});
        builder.array(BOTTOM_RIGHT_FIELD.getPreferredName(), new Object[]{((GeoPoint)this.bottomRight).getX(), ((GeoPoint)this.bottomRight).getY()});
        return builder;
    }

    public boolean pointInBounds(double lon, double lat) {
        if (lat >= this.bottom() && lat <= this.top()) {
            if (this.left() <= this.right()) {
                return lon >= this.left() && lon <= this.right();
            }
            return lon >= this.left() || lon <= this.right();
        }
        return false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeGeoPoint((GeoPoint)this.topLeft);
        out.writeGeoPoint((GeoPoint)this.bottomRight);
    }

    @Override
    public final String getWriteableName() {
        return "GeoBoundingBox";
    }

    @Override
    public final TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public static GeoBoundingBox parseBoundingBox(XContentParser parser) throws IOException, ElasticsearchParseException {
        GeoBoundsParser bounds = new GeoBoundsParser(parser);
        return (GeoBoundingBox)bounds.parseBoundingBox();
    }

    protected static class GeoBoundsParser
    extends BoundingBox.BoundsParser<GeoBoundingBox> {
        GeoBoundsParser(XContentParser parser) {
            super(parser);
        }

        @Override
        protected GeoBoundingBox createWithEnvelope() {
            GeoPoint topLeft = new GeoPoint(this.envelope.getMaxLat(), this.envelope.getMinLon());
            GeoPoint bottomRight = new GeoPoint(this.envelope.getMinLat(), this.envelope.getMaxLon());
            return new GeoBoundingBox(topLeft, bottomRight);
        }

        @Override
        protected GeoBoundingBox createWithBounds() {
            GeoPoint topLeft = new GeoPoint(this.top, this.left);
            GeoPoint bottomRight = new GeoPoint(this.bottom, this.right);
            return new GeoBoundingBox(topLeft, bottomRight);
        }

        @Override
        protected SpatialPoint parsePointWith(XContentParser parser, GeoUtils.EffectivePoint effectivePoint) throws IOException {
            return GeoUtils.parseGeoPoint(parser, false, effectivePoint);
        }
    }
}

