/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.RatioValue;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.IndexingStats;

public class WriteLoadConstraintSettings {
    private static final String SETTING_PREFIX = "cluster.routing.allocation.write_load_decider.";
    private static final FeatureFlag WRITE_LOAD_DECIDER_FEATURE_FLAG = new FeatureFlag("write_load_decider");
    public static final Setting<WriteLoadDeciderStatus> WRITE_LOAD_DECIDER_ENABLED_SETTING = Setting.enumSetting(WriteLoadDeciderStatus.class, "cluster.routing.allocation.write_load_decider.enabled", WRITE_LOAD_DECIDER_FEATURE_FLAG.isEnabled() ? WriteLoadDeciderStatus.ENABLED : WriteLoadDeciderStatus.DISABLED, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<WriteLoadDeciderShardWriteLoadType> WRITE_LOAD_DECIDER_SHARD_WRITE_LOAD_TYPE_SETTING = Setting.enumSetting(WriteLoadDeciderShardWriteLoadType.class, "cluster.routing.allocation.write_load_decider.shard_write_load_type", WriteLoadDeciderShardWriteLoadType.PEAK, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<RatioValue> WRITE_LOAD_DECIDER_HIGH_UTILIZATION_THRESHOLD_SETTING = new Setting<RatioValue>("cluster.routing.allocation.write_load_decider.high_utilization_threshold", "90%", RatioValue::parseRatioValue, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> WRITE_LOAD_DECIDER_HIGH_UTILIZATION_DURATION_SETTING = Setting.timeSetting("cluster.routing.allocation.write_load_decider.high_utilization_duration", TimeValue.timeValueMinutes((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> WRITE_LOAD_DECIDER_QUEUE_LATENCY_THRESHOLD_SETTING = Setting.timeSetting("cluster.routing.allocation.write_load_decider.queue_latency_threshold", TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> WRITE_LOAD_DECIDER_REROUTE_INTERVAL_SETTING = Setting.timeSetting("cluster.routing.allocation.write_load_decider.reroute_interval", TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> WRITE_LOAD_DECIDER_MINIMUM_LOGGING_INTERVAL = Setting.timeSetting("cluster.routing.allocation.write_load_decider.log_interval", TimeValue.timeValueMinutes((long)1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile WriteLoadDeciderStatus writeLoadDeciderStatus;
    private volatile TimeValue minimumRerouteInterval;
    private volatile double highUtilizationThreshold;
    private volatile TimeValue queueLatencyThreshold;

    public WriteLoadConstraintSettings(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(WRITE_LOAD_DECIDER_ENABLED_SETTING, status -> {
            this.writeLoadDeciderStatus = status;
        });
        clusterSettings.initializeAndWatch(WRITE_LOAD_DECIDER_REROUTE_INTERVAL_SETTING, timeValue -> {
            this.minimumRerouteInterval = timeValue;
        });
        clusterSettings.initializeAndWatch(WRITE_LOAD_DECIDER_HIGH_UTILIZATION_THRESHOLD_SETTING, value -> {
            this.highUtilizationThreshold = value.getAsRatio();
        });
        clusterSettings.initializeAndWatch(WRITE_LOAD_DECIDER_QUEUE_LATENCY_THRESHOLD_SETTING, value -> {
            this.queueLatencyThreshold = value;
        });
    }

    public WriteLoadDeciderStatus getWriteLoadConstraintEnabled() {
        return this.writeLoadDeciderStatus;
    }

    public TimeValue getMinimumRerouteInterval() {
        return this.minimumRerouteInterval;
    }

    public TimeValue getQueueLatencyThreshold() {
        return this.queueLatencyThreshold;
    }

    public double getHighUtilizationThreshold() {
        return this.highUtilizationThreshold;
    }

    public static enum WriteLoadDeciderStatus {
        DISABLED,
        LOW_THRESHOLD_ONLY,
        ENABLED;


        public boolean fullyEnabled() {
            return this == ENABLED;
        }

        public boolean notFullyEnabled() {
            return this != ENABLED;
        }

        public boolean atLeastLowThresholdEnabled() {
            return this != DISABLED;
        }

        public boolean disabled() {
            return this == DISABLED;
        }
    }

    public static enum WriteLoadDeciderShardWriteLoadType {
        PEAK,
        RECENT;


        public double getWriteLoad(IndexingStats indexingStats) {
            return this == PEAK ? indexingStats.getTotal().getPeakWriteLoad() : indexingStats.getTotal().getRecentWriteLoad();
        }
    }
}

