/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DataStreamAutoShardingEvent(String triggerIndexName, int targetNumberOfShards, long timestamp) implements SimpleDiffable<DataStreamAutoShardingEvent>,
ToXContentFragment
{
    public static final ParseField TRIGGER_INDEX_NAME = new ParseField("trigger_index_name", new String[0]);
    public static final ParseField TARGET_NUMBER_OF_SHARDS = new ParseField("target_number_of_shards", new String[0]);
    public static final ParseField EVENT_TIME = new ParseField("event_time", new String[0]);
    public static final ParseField EVENT_TIME_MILLIS = new ParseField("event_time_millis", new String[0]);
    public static final ConstructingObjectParser<DataStreamAutoShardingEvent, Void> PARSER = new ConstructingObjectParser("auto_sharding", false, (args, unused) -> new DataStreamAutoShardingEvent((String)args[0], (Integer)args[1], (Long)args[2]));

    DataStreamAutoShardingEvent(StreamInput in) throws IOException {
        this(in.readString(), in.readVInt(), in.readVLong());
    }

    public static DataStreamAutoShardingEvent fromXContent(XContentParser parser) throws IOException {
        return (DataStreamAutoShardingEvent)PARSER.parse(parser, null);
    }

    static Diff<DataStreamAutoShardingEvent> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStreamAutoShardingEvent::new, in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(TRIGGER_INDEX_NAME.getPreferredName(), this.triggerIndexName);
        builder.field(TARGET_NUMBER_OF_SHARDS.getPreferredName(), this.targetNumberOfShards);
        builder.humanReadableField(EVENT_TIME_MILLIS.getPreferredName(), EVENT_TIME.getPreferredName(), (Object)TimeValue.timeValueMillis((long)this.timestamp));
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.triggerIndexName);
        out.writeVInt(this.targetNumberOfShards);
        out.writeVLong(this.timestamp);
    }

    public TimeValue getTimeSinceLastAutoShardingEvent(LongSupplier now) {
        return TimeValue.timeValueMillis((long)Math.max(0L, now.getAsLong() - this.timestamp));
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TRIGGER_INDEX_NAME);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), TARGET_NUMBER_OF_SHARDS);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), EVENT_TIME_MILLIS);
    }
}

