/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import java.io.IOException;
import java.util.Objects;
import java.util.function.IntFunction;
import org.elasticsearch.action.synonyms.AbstractSynonymsPagedResultAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.synonyms.PagedResult;
import org.elasticsearch.synonyms.SynonymRule;

public class GetSynonymsAction
extends AbstractSynonymsPagedResultAction<Response> {
    public static final GetSynonymsAction INSTANCE = new GetSynonymsAction();
    public static final String NAME = "cluster:admin/synonyms/get";

    public GetSynonymsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractSynonymsPagedResultAction.AbstractPagedResultResponse<SynonymRule> {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(PagedResult<SynonymRule> result) {
            super(result);
        }

        @Override
        protected String resultFieldName() {
            return "synonyms_set";
        }

        @Override
        protected Writeable.Reader<SynonymRule> reader() {
            return SynonymRule::new;
        }

        @Override
        protected IntFunction<SynonymRule[]> arraySupplier() {
            return SynonymRule[]::new;
        }

        @Override
        PagedResult<SynonymRule> getResults() {
            return super.getResults();
        }
    }

    public static class Request
    extends AbstractSynonymsPagedResultAction.Request {
        private final String synonymsSetId;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.synonymsSetId = in.readString();
        }

        public Request(String synonymsSetId, int from, int size) {
            super(from, size);
            Objects.requireNonNull(synonymsSetId, "Synonym set ID cannot be null");
            this.synonymsSetId = synonymsSetId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.synonymsSetId);
        }

        public String synonymsSetId() {
            return this.synonymsSetId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.synonymsSetId, request.synonymsSetId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.synonymsSetId);
        }
    }
}

