/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.index.mapper.TimeSeriesParams;

public record IndexFieldCapabilities(String name, String type, boolean isMetadatafield, boolean isSearchable, boolean isAggregatable, boolean isDimension, TimeSeriesParams.MetricType metricType, Map<String, String> meta) implements Writeable
{
    private static final StringLiteralDeduplicator typeStringDeduplicator = new StringLiteralDeduplicator();

    public static IndexFieldCapabilities readFrom(StreamInput in) throws IOException {
        String name = in.readString();
        String type = typeStringDeduplicator.deduplicate(in.readString());
        boolean isMetadatafield = in.readBoolean();
        boolean isSearchable = in.readBoolean();
        boolean isAggregatable = in.readBoolean();
        boolean isDimension = in.readBoolean();
        TimeSeriesParams.MetricType metricType = in.readOptionalEnum(TimeSeriesParams.MetricType.class);
        return new IndexFieldCapabilities(name, type, isMetadatafield, isSearchable, isAggregatable, isDimension, metricType, in.readImmutableMap(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.isMetadatafield);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        out.writeBoolean(this.isDimension);
        out.writeOptionalEnum(this.metricType);
        out.writeMap(this.meta, StreamOutput::writeString);
    }
}

