/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.lifecycle;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.datastreams.lifecycle.ErrorEntry;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExplainIndexDataStreamLifecycle
implements Writeable,
ToXContentObject {
    private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField MANAGED_BY_LIFECYCLE_FIELD = new ParseField("managed_by_lifecycle", new String[0]);
    private static final ParseField INDEX_CREATION_DATE_MILLIS_FIELD = new ParseField("index_creation_date_millis", new String[0]);
    private static final ParseField INDEX_CREATION_DATE_FIELD = new ParseField("index_creation_date", new String[0]);
    private static final ParseField ROLLOVER_DATE_MILLIS_FIELD = new ParseField("rollover_date_millis", new String[0]);
    private static final ParseField ROLLOVER_DATE_FIELD = new ParseField("rollover_date", new String[0]);
    private static final ParseField TIME_SINCE_INDEX_CREATION_FIELD = new ParseField("time_since_index_creation", new String[0]);
    private static final ParseField TIME_SINCE_ROLLOVER_FIELD = new ParseField("time_since_rollover", new String[0]);
    private static final ParseField GENERATION_TIME = new ParseField("generation_time", new String[0]);
    private static final ParseField LIFECYCLE_FIELD = new ParseField("lifecycle", new String[0]);
    private static final ParseField ERROR_FIELD = new ParseField("error", new String[0]);
    private final String index;
    private final boolean managedByLifecycle;
    private final boolean isInternalDataStream;
    @Nullable
    private final Long indexCreationDate;
    @Nullable
    private final Long rolloverDate;
    @Nullable
    private final Long generationDateMillis;
    @Nullable
    private final DataStreamLifecycle lifecycle;
    @Nullable
    private final ErrorEntry error;
    private Supplier<Long> nowSupplier = System::currentTimeMillis;

    public ExplainIndexDataStreamLifecycle(String index, boolean managedByLifecycle, boolean isInternalDataStream, @Nullable Long indexCreationDate, @Nullable Long rolloverDate, @Nullable TimeValue generationDate, @Nullable DataStreamLifecycle lifecycle, @Nullable ErrorEntry error) {
        this.index = index;
        this.managedByLifecycle = managedByLifecycle;
        this.isInternalDataStream = isInternalDataStream;
        this.indexCreationDate = indexCreationDate;
        this.rolloverDate = rolloverDate;
        this.generationDateMillis = generationDate == null ? null : Long.valueOf(generationDate.millis());
        this.lifecycle = lifecycle;
        this.error = error;
    }

    public ExplainIndexDataStreamLifecycle(StreamInput in) throws IOException {
        this.index = in.readString();
        this.managedByLifecycle = in.readBoolean();
        this.isInternalDataStream = in.readBoolean();
        if (this.managedByLifecycle) {
            this.indexCreationDate = in.readOptionalLong();
            this.rolloverDate = in.readOptionalLong();
            this.generationDateMillis = in.readOptionalLong();
            this.lifecycle = in.readOptionalWriteable(DataStreamLifecycle::new);
            this.error = in.readOptionalWriteable(ErrorEntry::new);
        } else {
            this.indexCreationDate = null;
            this.rolloverDate = null;
            this.generationDateMillis = null;
            this.lifecycle = null;
            this.error = null;
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) throws IOException {
        builder.startObject();
        builder.field(INDEX_FIELD.getPreferredName(), this.index);
        builder.field(MANAGED_BY_LIFECYCLE_FIELD.getPreferredName(), this.managedByLifecycle);
        if (this.managedByLifecycle) {
            if (this.indexCreationDate != null) {
                builder.timestampFieldsFromUnixEpochMillis(INDEX_CREATION_DATE_MILLIS_FIELD.getPreferredName(), INDEX_CREATION_DATE_FIELD.getPreferredName(), this.indexCreationDate.longValue());
                builder.field(TIME_SINCE_INDEX_CREATION_FIELD.getPreferredName(), this.getTimeSinceIndexCreation(this.nowSupplier).toHumanReadableString(2));
            }
            if (this.rolloverDate != null) {
                builder.timestampFieldsFromUnixEpochMillis(ROLLOVER_DATE_MILLIS_FIELD.getPreferredName(), ROLLOVER_DATE_FIELD.getPreferredName(), this.rolloverDate.longValue());
                builder.field(TIME_SINCE_ROLLOVER_FIELD.getPreferredName(), this.getTimeSinceRollover(this.nowSupplier).toHumanReadableString(2));
            }
            if (this.generationDateMillis != null) {
                builder.field(GENERATION_TIME.getPreferredName(), this.getGenerationTime(this.nowSupplier).toHumanReadableString(2));
            }
            if (this.lifecycle != null) {
                builder.field(LIFECYCLE_FIELD.getPreferredName());
                this.lifecycle.toXContent(builder, params, rolloverConfiguration, globalRetention, this.isInternalDataStream);
            }
            if (this.error != null) {
                if (this.error.firstOccurrenceTimestamp() != -1L && this.error.recordedTimestamp() != -1L && this.error.retryCount() != -1) {
                    builder.field(ERROR_FIELD.getPreferredName(), (ToXContent)this.error);
                } else {
                    builder.field(ERROR_FIELD.getPreferredName(), this.error.error());
                }
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeBoolean(this.managedByLifecycle);
        out.writeBoolean(this.isInternalDataStream);
        if (this.managedByLifecycle) {
            out.writeOptionalLong(this.indexCreationDate);
            out.writeOptionalLong(this.rolloverDate);
            out.writeOptionalLong(this.generationDateMillis);
            out.writeOptionalWriteable(this.lifecycle);
            out.writeOptionalWriteable(this.error);
        }
    }

    @Nullable
    public TimeValue getGenerationTime(Supplier<Long> now) {
        if (this.generationDateMillis == null) {
            return null;
        }
        return TimeValue.timeValueMillis((long)Math.max(0L, now.get() - this.generationDateMillis));
    }

    @Nullable
    public TimeValue getTimeSinceIndexCreation(Supplier<Long> now) {
        if (this.indexCreationDate == null) {
            return null;
        }
        return TimeValue.timeValueMillis((long)Math.max(0L, now.get() - this.indexCreationDate));
    }

    @Nullable
    public TimeValue getTimeSinceRollover(Supplier<Long> now) {
        if (this.rolloverDate == null) {
            return null;
        }
        return TimeValue.timeValueMillis((long)Math.max(0L, now.get() - this.rolloverDate));
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isManagedByLifecycle() {
        return this.managedByLifecycle;
    }

    public Long getIndexCreationDate() {
        return this.indexCreationDate;
    }

    public Long getRolloverDate() {
        return this.rolloverDate;
    }

    public DataStreamLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public ErrorEntry getError() {
        return this.error;
    }

    public void setNowSupplier(Supplier<Long> nowSupplier) {
        this.nowSupplier = nowSupplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplainIndexDataStreamLifecycle that = (ExplainIndexDataStreamLifecycle)o;
        return this.managedByLifecycle == that.managedByLifecycle && Objects.equals(this.index, that.index) && Objects.equals(this.indexCreationDate, that.indexCreationDate) && Objects.equals(this.rolloverDate, that.rolloverDate) && Objects.equals(this.lifecycle, that.lifecycle) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.managedByLifecycle, this.indexCreationDate, this.rolloverDate, this.lifecycle, this.error);
    }
}

