/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.datastreams.lifecycle.ExplainIndexDataStreamLifecycle;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;

public class ExplainDataStreamLifecycleAction {
    public static final ActionType<Response> INSTANCE = new ActionType("indices:admin/data_stream/lifecycle/explain");

    private ExplainDataStreamLifecycleAction() {
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
        private static final TransportVersion INTRODUCE_FAILURES_DEFAULT_RETENTION = TransportVersion.fromName("introduce_failures_default_retention");
        private final List<ExplainIndexDataStreamLifecycle> indices;
        @Nullable
        private final RolloverConfiguration rolloverConfiguration;
        @Nullable
        private final DataStreamGlobalRetention dataGlobalRetention;
        @Nullable
        private final DataStreamGlobalRetention failureGlobalRetention;

        public Response(List<ExplainIndexDataStreamLifecycle> indices, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention dataGlobalRetention, @Nullable DataStreamGlobalRetention failureGlobalRetention) {
            this.indices = indices;
            this.rolloverConfiguration = rolloverConfiguration;
            this.dataGlobalRetention = dataGlobalRetention;
            this.failureGlobalRetention = failureGlobalRetention;
        }

        public Response(StreamInput in) throws IOException {
            this.indices = in.readCollectionAsList(ExplainIndexDataStreamLifecycle::new);
            this.rolloverConfiguration = in.readOptionalWriteable(RolloverConfiguration::new);
            if (in.getTransportVersion().supports(INTRODUCE_FAILURES_DEFAULT_RETENTION)) {
                TimeValue defaultRetention = in.readOptionalTimeValue();
                TimeValue maxRetention = in.readOptionalTimeValue();
                TimeValue defaultFailuresRetention = in.readOptionalTimeValue();
                this.dataGlobalRetention = DataStreamGlobalRetention.create(defaultRetention, maxRetention);
                this.failureGlobalRetention = DataStreamGlobalRetention.create(defaultFailuresRetention, maxRetention);
            } else {
                this.failureGlobalRetention = this.dataGlobalRetention = in.readOptionalWriteable(DataStreamGlobalRetention::read);
            }
        }

        public List<ExplainIndexDataStreamLifecycle> getIndices() {
            return this.indices;
        }

        public RolloverConfiguration getRolloverConfiguration() {
            return this.rolloverConfiguration;
        }

        public DataStreamGlobalRetention getDataGlobalRetention() {
            return this.dataGlobalRetention;
        }

        public DataStreamGlobalRetention getFailuresGlobalRetention() {
            return this.failureGlobalRetention;
        }

        private DataStreamGlobalRetention getGlobalRetentionForLifecycle(DataStreamLifecycle lifecycle) {
            if (lifecycle == null) {
                return null;
            }
            return lifecycle.targetsFailureStore() ? this.failureGlobalRetention : this.dataGlobalRetention;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.indices);
            out.writeOptionalWriteable(this.rolloverConfiguration);
            if (out.getTransportVersion().supports(INTRODUCE_FAILURES_DEFAULT_RETENTION)) {
                out.writeOptionalTimeValue(this.dataGlobalRetention == null ? null : this.dataGlobalRetention.defaultRetention());
                out.writeOptionalTimeValue(this.dataGlobalRetention == null ? null : this.dataGlobalRetention.maxRetention());
                out.writeOptionalTimeValue(this.failureGlobalRetention == null ? null : this.failureGlobalRetention.defaultRetention());
            } else {
                out.writeOptionalWriteable(this.getDataGlobalRetention());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.indices, response.indices) && Objects.equals(this.rolloverConfiguration, response.rolloverConfiguration) && Objects.equals(this.dataGlobalRetention, response.dataGlobalRetention) && Objects.equals(this.failureGlobalRetention, response.failureGlobalRetention);
        }

        public int hashCode() {
            return Objects.hash(this.indices, this.rolloverConfiguration, this.dataGlobalRetention, this.failureGlobalRetention);
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat(Iterators.single((builder, params) -> {
                builder.startObject();
                builder.startObject(INDICES_FIELD.getPreferredName());
                return builder;
            }), Iterators.map(this.indices.iterator(), explainIndexDataLifecycle -> (builder, params) -> {
                builder.field(explainIndexDataLifecycle.getIndex());
                explainIndexDataLifecycle.toXContent(builder, DataStreamLifecycle.addEffectiveRetentionParams(outerParams), this.rolloverConfiguration, this.getGlobalRetentionForLifecycle(explainIndexDataLifecycle.getLifecycle()));
                return builder;
            }), Iterators.single((builder, params) -> {
                builder.endObject();
                builder.endObject();
                return builder;
            }));
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;
        private boolean includeDefaults;
        private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

        public Request(TimeValue masterNodeTimeout, String[] names) {
            this(masterNodeTimeout, names, false);
        }

        public Request(TimeValue masterNodeTimeout, String[] names, boolean includeDefaults) {
            super(masterNodeTimeout);
            this.names = names;
            this.includeDefaults = includeDefaults;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions(in);
            this.includeDefaults = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
            out.writeBoolean(this.includeDefaults);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.includeDefaults == request.includeDefaults && Arrays.equals(this.names, request.names) && Objects.equals(this.indicesOptions, request.indicesOptions);
        }

        public int hashCode() {
            int result = Objects.hash(this.includeDefaults, this.indicesOptions);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        @Override
        public String[] indices() {
            return this.names;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }
    }
}

