/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.admin.cluster.snapshots.status.TransportSnapshotsStatusAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportNodesSnapshotsStatus
extends TransportNodesAction<Request, NodesSnapshotStatus, NodeRequest, NodeSnapshotStatus, Void> {
    public static final String ACTION_NAME = TransportSnapshotsStatusAction.TYPE.name() + "[nodes]";
    public static final ActionType<NodesSnapshotStatus> TYPE = new ActionType(ACTION_NAME);
    private final SnapshotShardsService snapshotShardsService;

    @Inject
    public TransportNodesSnapshotsStatus(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SnapshotShardsService snapshotShardsService, ActionFilters actionFilters) {
        super(ACTION_NAME, clusterService, transportService, actionFilters, NodeRequest::new, threadPool.executor("generic"));
        this.snapshotShardsService = snapshotShardsService;
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeSnapshotStatus newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeSnapshotStatus(in);
    }

    @Override
    protected NodesSnapshotStatus newResponse(Request request, List<NodeSnapshotStatus> responses, List<FailedNodeException> failures) {
        return new NodesSnapshotStatus(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeSnapshotStatus nodeOperation(NodeRequest request, Task task) {
        HashMap snapshotMapBuilder = new HashMap();
        try {
            String nodeId = this.clusterService.localNode().getId();
            for (Snapshot snapshot : request.snapshots) {
                Map<ShardId, IndexShardSnapshotStatus.Copy> shardsStatus = this.snapshotShardsService.currentSnapshotShards(snapshot);
                if (shardsStatus == null) continue;
                HashMap<ShardId, SnapshotIndexShardStatus> shardMapBuilder = new HashMap<ShardId, SnapshotIndexShardStatus>();
                for (Map.Entry<ShardId, IndexShardSnapshotStatus.Copy> shardEntry : shardsStatus.entrySet()) {
                    ShardId shardId = shardEntry.getKey();
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardEntry.getValue();
                    IndexShardSnapshotStatus.Stage stage = lastSnapshotStatus.getStage();
                    String shardNodeId = null;
                    if (stage != IndexShardSnapshotStatus.Stage.DONE && stage != IndexShardSnapshotStatus.Stage.FAILURE) {
                        shardNodeId = nodeId;
                    }
                    shardMapBuilder.put(shardEntry.getKey(), new SnapshotIndexShardStatus(shardId, lastSnapshotStatus, shardNodeId));
                }
                snapshotMapBuilder.put(snapshot, Collections.unmodifiableMap(shardMapBuilder));
            }
            return new NodeSnapshotStatus(this.clusterService.localNode(), Collections.unmodifiableMap(snapshotMapBuilder));
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        private final List<Snapshot> snapshots;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.snapshots = in.readCollectionAsList(Snapshot::new);
        }

        NodeRequest(Request request) {
            this.snapshots = Arrays.asList(request.snapshots);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.snapshots);
        }
    }

    public static class Request
    extends BaseNodesRequest {
        private final Snapshot[] snapshots;

        public Request(String[] nodesIds, Snapshot[] snapshots) {
            super(nodesIds);
            this.snapshots = snapshots;
        }
    }

    public static class NodeSnapshotStatus
    extends BaseNodeResponse {
        private final Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status;

        public NodeSnapshotStatus(StreamInput in) throws IOException {
            super(in);
            this.status = in.readImmutableMap(Snapshot::new, input -> input.readImmutableOpenMap(ShardId::new, SnapshotIndexShardStatus::new));
        }

        public NodeSnapshotStatus(DiscoveryNode node, Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status) {
            super(node);
            this.status = status;
        }

        public Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status() {
            return this.status;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.status != null) {
                out.writeMap(this.status, StreamOutput::writeWriteable, StreamOutput::writeMap);
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class NodesSnapshotStatus
    extends BaseNodesResponse<NodeSnapshotStatus> {
        public NodesSnapshotStatus(ClusterName clusterName, List<NodeSnapshotStatus> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeSnapshotStatus> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeSnapshotStatus::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeSnapshotStatus> nodes) throws IOException {
            out.writeCollection(nodes);
        }
    }
}

