/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.junit.listeners;

import com.carrotsearch.randomizedtesting.ReproduceErrorMessageBuilder;
import com.carrotsearch.randomizedtesting.SysGlobals;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.test.ESTestCase;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ReproduceInfoPrinter
extends RunListener {
    protected final Logger logger = LogManager.getLogger(ESTestCase.class);

    public void testStarted(Description description) throws Exception {
        this.logger.trace("Test {} started", (Object)description.getDisplayName());
    }

    public void testFinished(Description description) throws Exception {
        this.logger.trace("Test {} finished", (Object)description.getDisplayName());
    }

    static boolean inVerifyPhase() {
        return Booleans.parseBoolean((String)System.getProperty("tests.verify.phase", "false"));
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure.getException() instanceof AssumptionViolatedException) {
            return;
        }
        String gradlew = Constants.WINDOWS ? "gradlew" : "./gradlew";
        StringBuilder b = new StringBuilder("REPRODUCE WITH: " + gradlew + " ");
        String task = System.getProperty("tests.task");
        boolean isBwcTest = Booleans.parseBoolean((String)System.getProperty("tests.bwc", "false")) || System.getProperty("tests.bwc.main.version") != null || System.getProperty("tests.bwc.refspec.main") != null;
        b.append("\"" + task + "\"");
        if (isBwcTest) {
            b.append(" -Dtests.class=\"");
        } else {
            b.append(" --tests \"");
        }
        b.append(failure.getDescription().getClassName());
        String methodName = failure.getDescription().getMethodName();
        if (methodName != null) {
            if (methodName.contains(".") || isBwcTest) {
                b.append("\" -Dtests.method=\"");
                b.append(methodName);
            } else {
                b.append(".");
                b.append(methodName);
            }
        }
        b.append("\"");
        GradleMessageBuilder gradleMessageBuilder = new GradleMessageBuilder(b);
        gradleMessageBuilder.appendAllOpts(failure.getDescription());
        if (ReproduceInfoPrinter.isRestApiCompatibilityTest()) {
            b.append(System.lineSeparator());
            b.append("This is a Rest Api Compatibility Test. See the developers guide for details how to troubleshoot - https://github.com/elastic/elasticsearch/blob/main/REST_API_COMPATIBILITY.md");
        }
        ReproduceInfoPrinter.printToErr(b.toString());
    }

    private static boolean isRestApiCompatibilityTest() {
        return Booleans.parseBoolean((String)System.getProperty("tests.restCompat", "false"));
    }

    @SuppressForbidden(reason="printing repro info")
    private static void printToErr(String s) {
        System.err.println(s);
    }

    protected static class GradleMessageBuilder
    extends ReproduceErrorMessageBuilder {
        public GradleMessageBuilder(StringBuilder b) {
            super(b);
        }

        public ReproduceErrorMessageBuilder appendAllOpts(Description description) {
            super.appendAllOpts(description);
            return this.appendESProperties();
        }

        public ReproduceErrorMessageBuilder appendEnvironmentSettings() {
            return this;
        }

        public ReproduceErrorMessageBuilder appendOpt(String sysPropName, String value) {
            if (sysPropName.equals(SysGlobals.SYSPROP_ITERATIONS())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_TESTCLASS())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_TESTMETHOD())) {
                return this;
            }
            if (sysPropName.equals(SysGlobals.SYSPROP_PREFIX())) {
                return this;
            }
            if (Strings.hasLength((String)value)) {
                return super.appendOpt(sysPropName, value);
            }
            return this;
        }

        private ReproduceErrorMessageBuilder appendESProperties() {
            this.appendProperties("tests.es.logger.level");
            if (ReproduceInfoPrinter.inVerifyPhase()) {
                this.appendProperties("tests.enable_mock_modules");
            }
            this.appendProperties("tests.assertion.disabled", "tests.nightly", "tests.jvms", "tests.client.ratio", "tests.heap.size", "tests.bwc", "tests.bwc.version", "build.snapshot", "tests.configure_test_clusters_with_one_processor", "tests.bwc.main.version", "tests.bwc.refspec.main", "tests.vectorsize");
            if (System.getProperty("tests.jvm.argline") != null && !System.getProperty("tests.jvm.argline").isEmpty()) {
                this.appendOpt("tests.jvm.argline", "\"" + System.getProperty("tests.jvm.argline") + "\"");
            }
            if (!Booleans.parseBoolean((String)System.getProperty("build.snapshot", "true"))) {
                this.appendOpt("license.key", "x-pack/license-tools/src/test/resources/public.key");
            }
            this.appendOpt("tests.locale", Locale.getDefault().toLanguageTag());
            this.appendOpt("tests.timezone", TimeZone.getDefault().getID());
            this.appendOpt("tests.distribution", System.getProperty("tests.distribution"));
            if (Runtime.version().build().isPresent() && ("ea".equalsIgnoreCase(Runtime.version().pre().orElse("")) || "rc".equalsIgnoreCase(Runtime.version().pre().orElse("")))) {
                this.appendOpt("runtime.java", Runtime.version().feature() + "-pre");
                this.appendOpt("runtime.java.build", Integer.toString(Runtime.version().build().get()));
            } else {
                this.appendOpt("runtime.java", Integer.toString(Runtime.version().feature()));
            }
            this.appendOpt("tests.fips.enabled", System.getProperty("tests.fips.enabled"));
            return this;
        }

        protected ReproduceErrorMessageBuilder appendProperties(String ... properties) {
            for (String sysPropName : properties) {
                if (!Strings.hasLength((String)System.getProperty(sysPropName))) continue;
                this.appendOpt(sysPropName, System.getProperty(sysPropName));
            }
            return this;
        }
    }
}

