/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;
import com.carrotsearch.randomizedtesting.annotations.TimeoutSuite;
import com.carrotsearch.randomizedtesting.generators.CodepointSetGenerator;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import com.carrotsearch.randomizedtesting.rules.TestRuleAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.status.StatusConsoleListener;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestRuleMarkFailure;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.SetOnce;
import org.apache.lucene.util.Version;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RequestBuilder;
import org.elasticsearch.action.support.ActionTestUtils;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.TestPlainActionFuture;
import org.elasticsearch.bootstrap.BootstrapForTesting;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.Requests;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.HeaderWarningAppender;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.FormatNames;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.PathUtilsForTesting;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.entitlement.bootstrap.TestEntitlementsRule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.TestEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.logging.internal.spi.LoggerFactory;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.scanners.StablePluginsRegistry;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.MockSearchService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.test.GraalVMThreadsFilter;
import org.elasticsearch.test.IndexSettingsModule;
import org.elasticsearch.test.JnaCleanerThreadsFilter;
import org.elasticsearch.test.MockLog;
import org.elasticsearch.test.NettyGlobalThreadsFilter;
import org.elasticsearch.test.junit.listeners.LoggingListener;
import org.elasticsearch.test.junit.listeners.ReproduceInfoPrinter;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.LeakTracker;
import org.elasticsearch.transport.netty4.Netty4Plugin;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@Listeners(value={ReproduceInfoPrinter.class, LoggingListener.class})
@ThreadLeakScope(value=ThreadLeakScope.Scope.SUITE)
@ThreadLeakLingering(linger=5000)
@TimeoutSuite(millis=1200000)
@ThreadLeakFilters(filters={GraalVMThreadsFilter.class, NettyGlobalThreadsFilter.class, JnaCleanerThreadsFilter.class})
@LuceneTestCase.SuppressSysoutChecks(bugUrl="we log a lot on purpose")
@LuceneTestCase.SuppressCodecs(value={"SimpleText", "Memory", "CheapBastard", "Direct", "Compressing", "FST50", "FSTOrd50", "TestBloomFilteredLucenePostings", "MockRandom", "BlockTreeOrds", "LuceneFixedGap", "LuceneVarGapFixedInterval", "LuceneVarGapDocFreqInterval", "Lucene50"})
@LuceneTestCase.SuppressReproduceLine
public abstract class ESTestCase
extends LuceneTestCase {
    protected static final List<String> JAVA_TIMEZONE_IDS;
    protected static final List<String> JAVA_ZONE_IDS;
    private static final AtomicInteger portGenerator;
    private static final Collection<String> loggedLeaks;
    private HeaderWarningAppender headerWarningAppender;
    public static final String TEST_WORKER_VM_ID;
    public static final String TEST_WORKER_SYS_PROPERTY = "org.gradle.test.worker";
    public static final String DEFAULT_TEST_WORKER_ID = "--not-gradle--";
    public static final String FIPS_SYSPROP = "tests.fips.enabled";
    private static final SetOnce<Boolean> WARN_SECURE_RANDOM_FIPS_NOT_DETERMINISTIC;
    private static final String LOWER_ALPHA_CHARACTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final String UPPER_ALPHA_CHARACTERS;
    private static final String DIGIT_CHARACTERS = "0123456789";
    private static final String ALPHANUMERIC_CHARACTERS;
    protected final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ThreadContext threadContext;
    @Rule
    public RuleChain failureAndSuccessEvents = RuleChain.outerRule((TestRule)new TestRuleAdapter(){

        protected void afterIfSuccessful() throws Throwable {
            ESTestCase.this.afterIfSuccessful();
        }

        protected void afterAlways(List<Throwable> errors) throws Throwable {
            if (errors != null && !errors.isEmpty()) {
                boolean allAssumption = true;
                for (Throwable error : errors) {
                    if (error instanceof AssumptionViolatedException) continue;
                    allAssumption = false;
                    break;
                }
                if (!allAssumption) {
                    ESTestCase.this.afterIfFailed(errors);
                }
            }
            super.afterAlways(errors);
        }
    });
    @ClassRule
    public static final TestEntitlementsRule TEST_ENTITLEMENTS;
    private static org.elasticsearch.logging.Level capturedLogLevel;
    private static final List<CircuitBreaker> breakers;
    private static final List<StatusData> statusData;
    private static final List<String> LOG_4J_MSG_PREFIXES;
    public static final List<Exception> checkIndexFailures;
    public static final BigInteger UNSIGNED_LONG_MAX;
    private static final long AWAIT_BUSY_THRESHOLD = 1000L;
    private static final GeohashGenerator geohashGenerator;
    private static final NamedXContentRegistry DEFAULT_NAMED_X_CONTENT_REGISTRY;
    private static final int PORTS_PER_WORKER = 30;
    protected static final int MIN_PRIVATE_PORT = 13301;
    private static final int MAX_PRIVATE_PORT = Short.MAX_VALUE;
    private static final int MAX_EFFECTIVE_WORKER_ID = 646;
    public static final TimeValue TEST_REQUEST_TIMEOUT;
    public static final TimeValue SAFE_AWAIT_TIMEOUT;

    @AfterClass
    public static void resetPortCounter() {
        portGenerator.set(0);
    }

    protected static Random initTestSeed() {
        long seed;
        String inputSeed = System.getProperty("tests.seed");
        if (inputSeed == null) {
            seed = System.nanoTime();
            ESTestCase.setTestSeed(Long.toHexString(seed));
        } else {
            String[] seedParts = inputSeed.split("[\\:]");
            seed = Long.parseUnsignedLong(seedParts[0], 16);
        }
        if (Booleans.parseBoolean((String)System.getProperty("tests.hackImmutableCollections", "false"))) {
            ESTestCase.forceImmutableCollectionsSeed(seed);
        }
        return new Random(seed);
    }

    @SuppressForbidden(reason="set tests.seed for intellij")
    static void setTestSeed(String seed) {
        System.setProperty("tests.seed", seed);
    }

    private static void forceImmutableCollectionsSeed(long seed) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> collectionsClass = Class.forName("java.util.ImmutableCollections");
            VarHandle salt32l = lookup.findStaticVarHandle(collectionsClass, "SALT32L", Long.TYPE);
            VarHandle reverse = lookup.findStaticVarHandle(collectionsClass, "REVERSE", Boolean.TYPE);
            salt32l.set(seed & 0xFFFFFFFFL);
            reverse.set((seed & 1L) == 0L);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    @SuppressForbidden(reason="force log4j and netty sysprops")
    private static void setTestSysProps(Random random) {
        System.setProperty("log4j.shutdownHookEnabled", "false");
        System.setProperty("log4j2.disable.jmx", "true");
        System.setProperty("io.netty.leakDetection.level", "paranoid");
        if (System.getProperty("es.use_unpooled_allocator") == null) {
            System.setProperty("es.use_unpooled_allocator", "false");
        }
        System.setProperty("es.set.netty.runtime.available.processors", "false");
    }

    public static TransportAddress buildNewFakeTransportAddress() {
        return new TransportAddress(TransportAddress.META_ADDRESS, portGenerator.incrementAndGet());
    }

    protected void afterIfFailed(List<Throwable> errors) {
    }

    protected void afterIfSuccessful() throws Exception {
    }

    @BeforeClass
    public static void setFileSystem() throws Exception {
        PathUtilsForTesting.setup();
    }

    @AfterClass
    public static void restoreFileSystem() throws Exception {
        PathUtilsForTesting.teardown();
    }

    @BeforeClass
    public static void setContentType() throws Exception {
        Requests.INDEX_CONTENT_TYPE = ESTestCase.randomFrom(XContentType.values());
    }

    @AfterClass
    public static void restoreContentType() {
        Requests.INDEX_CONTENT_TYPE = XContentType.JSON;
    }

    @BeforeClass
    public static void ensureSupportedLocale() {
        if (ESTestCase.isUnusableLocale()) {
            Logger logger = LogManager.getLogger(ESTestCase.class);
            logger.warn("Attempting to run tests in an unusable locale in a FIPS JVM. Certificate expiration validation will fail, switching to English. See: https://github.com/bcgit/bc-java/issues/405");
            Locale.setDefault(Locale.ENGLISH);
        }
    }

    @Before
    public void setHeaderWarningAppender() {
        this.headerWarningAppender = HeaderWarningAppender.createAppender((String)"header_warning", null);
        this.headerWarningAppender.start();
        Loggers.addAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.headerWarningAppender);
    }

    @After
    public void removeHeaderWarningAppender() {
        if (this.headerWarningAppender != null) {
            Loggers.removeAppender((Logger)LogManager.getLogger((String)"org.elasticsearch.deprecation"), (Appender)this.headerWarningAppender);
            this.headerWarningAppender = null;
        }
    }

    @BeforeClass
    public static void captureLoggingLevel() {
        capturedLogLevel = LoggerFactory.provider().getRootLevel();
    }

    @AfterClass
    public static void restoreLoggingLevel() {
        if (capturedLogLevel != null) {
            LoggerFactory.provider().setRootLevel(capturedLogLevel);
            capturedLogLevel = null;
        }
    }

    @Before
    public final void before() {
        LeakTracker.setContextHint((String)this.getTestName());
        this.logger.info("{}before test", (Object)this.getTestParamsForLogging());
        ESTestCase.assertNull((String)"Thread context initialized twice", (Object)this.threadContext);
        if (this.enableWarningsCheck()) {
            this.threadContext = new ThreadContext(Settings.EMPTY);
            HeaderWarning.setThreadContext((ThreadContext)this.threadContext);
        }
    }

    protected static CircuitBreaker newLimitedBreaker(ByteSizeValue max) {
        MockBigArrays.LimitedBreaker breaker = new MockBigArrays.LimitedBreaker("<es-test-case>", max);
        breakers.add((CircuitBreaker)breaker);
        return breaker;
    }

    @After
    public final void allBreakersMemoryReleased() {
        ArrayList<CircuitBreaker> breakersToCheck = new ArrayList<CircuitBreaker>(breakers);
        breakers.clear();
        for (CircuitBreaker breaker : breakersToCheck) {
            ESTestCase.assertThat(breaker.getUsed(), Matchers.equalTo((Object)0L));
        }
    }

    protected boolean enableWarningsCheck() {
        return true;
    }

    protected boolean enableBigArraysReleasedCheck() {
        return true;
    }

    @After
    public final void after() throws Exception {
        if (this.enableBigArraysReleasedCheck()) {
            MockBigArrays.ensureAllArraysAreReleased();
        }
        ESTestCase.checkStaticState();
        if (this.threadContext != null) {
            this.ensureNoWarnings();
            HeaderWarning.removeThreadContext((ThreadContext)this.threadContext);
            this.threadContext = null;
        }
        this.ensureAllSearchContextsReleased();
        this.ensureCheckIndexPassed();
        this.logger.info("{}after test", (Object)this.getTestParamsForLogging());
        LeakTracker.setContextHint((String)"");
    }

    private String getTestParamsForLogging() {
        String name = this.getTestName();
        int start = name.indexOf(123);
        if (start < 0) {
            return "";
        }
        int end = name.lastIndexOf(125);
        if (end < 0) {
            return "";
        }
        return "[" + name.substring(start + 1, end) + "] ";
    }

    public void ensureNoWarnings() {
        try {
            List warnings = (List)this.threadContext.getResponseHeaders().get("Warning");
            if (warnings != null) {
                List filteredWarnings = warnings.stream().filter(k -> this.filteredWarnings().stream().noneMatch(s -> k.contains((CharSequence)s))).collect(Collectors.toList());
                ESTestCase.assertThat("unexpected warning headers", filteredWarnings, Matchers.empty());
            } else {
                ESTestCase.assertNull((String)"unexpected warning headers", (Object)warnings);
            }
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    protected List<String> filteredWarnings() {
        ArrayList<String> filtered = new ArrayList<String>();
        filtered.add("Configuring multiple [path.data] paths is deprecated. Use RAID or other system level features for utilizing multiple disks. This feature will be removed in a future release.");
        filtered.add("Configuring [path.data] with a list is deprecated. Instead specify as a string value");
        filtered.add("setting [path.shared_data] is deprecated and will be removed in a future release");
        filtered.add("[cluster.routing.allocation.type] setting was deprecated in Elasticsearch and will be removed in a future release. See the breaking changes documentation for the next major version.");
        return filtered;
    }

    protected final void assertSettingDeprecationsAndWarnings(Setting<?>[] settings, DeprecationWarning ... warnings) {
        this.assertWarnings(true, (DeprecationWarning[])Stream.concat(Arrays.stream(settings).map(setting -> {
            Level level = setting.getProperties().contains(Setting.Property.Deprecated) ? DeprecationLogger.CRITICAL : Level.WARN;
            String warningMessage = Strings.format((String)"[%s] setting was deprecated in Elasticsearch and will be removed in a future release. See the %s documentation for the next major version.", (Object[])new Object[]{setting.getKey(), level == Level.WARN ? "deprecation" : "breaking changes"});
            return new DeprecationWarning(level, warningMessage);
        }), Arrays.stream(warnings)).toArray(DeprecationWarning[]::new));
    }

    protected final void assertWarnings(String ... expectedWarnings) {
        this.assertWarnings(true, (DeprecationWarning[])Arrays.stream(expectedWarnings).map(expectedWarning -> new DeprecationWarning(Level.WARN, (String)expectedWarning)).toArray(DeprecationWarning[]::new));
    }

    protected final void assertCriticalWarnings(String ... expectedWarnings) {
        this.assertWarnings(true, (DeprecationWarning[])Arrays.stream(expectedWarnings).map(expectedWarning -> new DeprecationWarning(DeprecationLogger.CRITICAL, (String)expectedWarning)).toArray(DeprecationWarning[]::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void assertWarnings(boolean stripXContentPosition, DeprecationWarning ... expectedWarnings) {
        if (!this.enableWarningsCheck()) {
            throw new IllegalStateException("unable to check warning headers if the test is not set to do so");
        }
        try {
            List actualWarningStrings = (List)this.threadContext.getResponseHeaders().get("Warning");
            if (expectedWarnings == null || expectedWarnings.length == 0) {
                ESTestCase.assertNull((String)("expected 0 warnings, actual: " + String.valueOf(actualWarningStrings)), (Object)actualWarningStrings);
            } else {
                ESTestCase.assertNotNull((String)("no warnings, expected: " + String.valueOf(Arrays.asList(expectedWarnings))), (Object)actualWarningStrings);
                Set actualDeprecationWarnings = actualWarningStrings.stream().map(warningString -> {
                    Level level;
                    String warningText = HeaderWarning.extractWarningValueFromWarningHeader((String)warningString, (boolean)stripXContentPosition);
                    if (warningString.startsWith(Integer.toString(DeprecationLogger.CRITICAL.intLevel()))) {
                        level = DeprecationLogger.CRITICAL;
                    } else if (warningString.startsWith(Integer.toString(Level.WARN.intLevel()))) {
                        level = Level.WARN;
                    } else {
                        throw new IllegalArgumentException("Unknown level in deprecation message " + warningString);
                    }
                    return new DeprecationWarning(level, warningText);
                }).collect(Collectors.toSet());
                for (DeprecationWarning expectedWarning : expectedWarnings) {
                    DeprecationWarning escapedExpectedWarning = new DeprecationWarning(expectedWarning.level, HeaderWarning.escapeAndEncode((String)expectedWarning.message));
                    ESTestCase.assertThat(actualDeprecationWarnings, Matchers.hasItem((Object)escapedExpectedWarning));
                }
                ESTestCase.assertEquals((String)("Expected " + expectedWarnings.length + " warnings but found " + actualWarningStrings.size() + "\nExpected: " + String.valueOf(Arrays.asList(expectedWarnings)) + "\nActual: " + String.valueOf(actualWarningStrings)), (long)expectedWarnings.length, (long)actualWarningStrings.size());
            }
        }
        finally {
            this.resetDeprecationLogger();
        }
    }

    private void resetDeprecationLogger() {
        this.threadContext.stashContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkStaticState() throws Exception {
        ESTestCase.assertThat(StatusLogger.getLogger().getLevel(), Matchers.equalTo((Object)Level.WARN));
        Collection<Object> collection = statusData;
        synchronized (collection) {
            try {
                ESTestCase.assertThat(statusData.stream().map(status -> status.getMessage().getFormattedMessage()).collect(Collectors.toList()), Matchers.anyOf((Matcher)Matchers.emptyCollectionOf(String.class), (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.startsWith((String)LOG_4J_MSG_PREFIXES.get(0)), Matchers.startsWith((String)LOG_4J_MSG_PREFIXES.get(1))}), (Matcher)Matchers.contains((Matcher)Matchers.startsWith((String)LOG_4J_MSG_PREFIXES.get(1)))));
            }
            finally {
                statusData.clear();
            }
        }
        collection = loggedLeaks;
        synchronized (collection) {
            try {
                ESTestCase.assertThat(loggedLeaks, Matchers.empty());
            }
            finally {
                loggedLeaks.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void assertLeakDetected() {
        Collection<String> collection = loggedLeaks;
        synchronized (collection) {
            ESTestCase.assertFalse((String)"No leaks have been detected", (boolean)loggedLeaks.isEmpty());
            loggedLeaks.clear();
        }
    }

    public final void ensureAllSearchContextsReleased() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> MockSearchService.assertNoInFlightContext()));
    }

    @Before
    public final void resetCheckIndexStatus() throws Exception {
        checkIndexFailures.clear();
    }

    public final void ensureCheckIndexPassed() {
        if (!checkIndexFailures.isEmpty()) {
            AssertionError e = new AssertionError((Object)"at least one shard failed CheckIndex");
            for (Exception failure : checkIndexFailures) {
                ((Throwable)((Object)e)).addSuppressed(failure);
            }
            throw e;
        }
    }

    public static int scaledRandomIntBetween(int min, int max) {
        return RandomizedTest.scaledRandomIntBetween((int)min, (int)max);
    }

    public static int randomIntBetween(int min, int max) {
        return RandomNumbers.randomIntBetween((Random)ESTestCase.random(), (int)min, (int)max);
    }

    public static long randomLongBetween(long min, long max) {
        return RandomNumbers.randomLongBetween((Random)ESTestCase.random(), (long)min, (long)max);
    }

    public static Instant randomInstantBetween(Instant minInstant, Instant maxInstant) {
        long epochSecond = ESTestCase.randomLongBetween(minInstant.getEpochSecond(), maxInstant.getEpochSecond());
        long minNanos = epochSecond == minInstant.getEpochSecond() ? (long)minInstant.getNano() : 0L;
        long maxNanos = epochSecond == maxInstant.getEpochSecond() ? (long)maxInstant.getNano() : 999999999L;
        long nanos = ESTestCase.randomLongBetween(minNanos, maxNanos);
        return Instant.ofEpochSecond(epochSecond, nanos);
    }

    public static BigInteger randomUnsignedLongBetween(BigInteger min, BigInteger max) {
        if (min.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("Must be between [0] and [" + String.valueOf(UNSIGNED_LONG_MAX) + "]");
        }
        if (0 < max.compareTo(UNSIGNED_LONG_MAX)) {
            throw new IllegalArgumentException("Must be between [0] and [" + String.valueOf(UNSIGNED_LONG_MAX) + "]");
        }
        long minShifted = min.add(BigInteger.valueOf(Long.MIN_VALUE)).longValueExact();
        long maxShifted = max.add(BigInteger.valueOf(Long.MIN_VALUE)).longValueExact();
        long randomShifted = ESTestCase.randomLongBetween(minShifted, maxShifted);
        return BigInteger.valueOf(randomShifted).subtract(BigInteger.valueOf(Long.MIN_VALUE));
    }

    public static int iterations(int min, int max) {
        return ESTestCase.scaledRandomIntBetween(min, max);
    }

    public static int between(int min, int max) {
        return ESTestCase.randomIntBetween(min, max);
    }

    public static boolean frequently() {
        return !ESTestCase.rarely();
    }

    public static boolean randomBoolean() {
        return ESTestCase.random().nextBoolean();
    }

    public static Boolean randomOptionalBoolean() {
        return ESTestCase.randomBoolean() ? Boolean.TRUE : ESTestCase.randomFrom(Boolean.FALSE, null);
    }

    public static byte randomByte() {
        return (byte)ESTestCase.random().nextInt();
    }

    public static byte randomNonNegativeByte() {
        byte randomByte = ESTestCase.randomByte();
        return (byte)(randomByte == -128 ? 0 : Math.abs(randomByte));
    }

    public static byte[] randomByteArrayOfLength(int size) {
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = ESTestCase.randomByte();
        }
        return bytes;
    }

    public static byte randomByteBetween(byte minInclusive, byte maxInclusive) {
        return (byte)ESTestCase.randomIntBetween(minInclusive, maxInclusive);
    }

    public static void randomBytesBetween(byte[] bytes, byte minInclusive, byte maxInclusive) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            bytes[i++] = ESTestCase.randomByteBetween(minInclusive, maxInclusive);
        }
    }

    public static BytesReference randomBytesReference(int length) {
        int sliceLen;
        ArrayList<BytesArray> slices = new ArrayList<BytesArray>();
        for (int remaining = length; remaining > 0; remaining -= sliceLen) {
            sliceLen = ESTestCase.between(1, remaining);
            slices.add(new BytesArray(ESTestCase.randomByteArrayOfLength(sliceLen)));
        }
        return CompositeBytesReference.of((BytesReference[])((BytesReference[])slices.toArray(BytesReference[]::new)));
    }

    public ReleasableBytesReference randomReleasableBytesReference(int length) {
        return new ReleasableBytesReference(ESTestCase.randomBytesReference(length), LeakTracker.wrap((RefCounted)new AbstractRefCounted(this){

            protected void closeInternal() {
            }
        }));
    }

    public static short randomShort() {
        return (short)ESTestCase.random().nextInt();
    }

    public static int randomInt() {
        return ESTestCase.random().nextInt();
    }

    public static IntStream randomInts() {
        return ESTestCase.random().ints();
    }

    public static IntStream randomInts(long streamSize) {
        return ESTestCase.random().ints(streamSize);
    }

    public static long randomNonNegativeLong() {
        return ESTestCase.randomLong() & Long.MAX_VALUE;
    }

    public static long randomNegativeLong() {
        return ESTestCase.randomLong() | Long.MIN_VALUE;
    }

    public static int randomNonNegativeInt() {
        return ESTestCase.randomInt() & Integer.MAX_VALUE;
    }

    public static int randomNegativeInt() {
        return ESTestCase.randomInt() | Integer.MIN_VALUE;
    }

    public static float randomFloat() {
        return ESTestCase.random().nextFloat();
    }

    public static float randomFloatBetween(float start, float end, boolean lowerInclusive) {
        float result;
        if (start == -3.4028235E38f || end == Float.MAX_VALUE) {
            result = Float.intBitsToFloat(ESTestCase.randomInt());
            while (result < start || result > end || Double.isNaN(result)) {
                result = Float.intBitsToFloat(ESTestCase.randomInt());
            }
        } else {
            result = ESTestCase.randomFloat();
            if (!lowerInclusive) {
                while (result <= 0.0f) {
                    result = ESTestCase.randomFloat();
                }
            }
            result = result * end + (1.0f - result) * start;
        }
        return result;
    }

    public static double randomDouble() {
        return ESTestCase.random().nextDouble();
    }

    public static DoubleStream randomDoubles() {
        return ESTestCase.random().doubles();
    }

    public static DoubleStream randomDoubles(long streamSize) {
        return ESTestCase.random().doubles(streamSize);
    }

    public static double randomGaussianDouble() {
        return ESTestCase.random().nextGaussian();
    }

    public static double randomDoubleBetween(double start, double end, boolean lowerInclusive) {
        double result = 0.0;
        if (start == -1.7976931348623157E308 || end == Double.MAX_VALUE) {
            result = Double.longBitsToDouble(ESTestCase.randomLong());
            while (result < start || result > end || Double.isNaN(result)) {
                result = Double.longBitsToDouble(ESTestCase.randomLong());
            }
        } else {
            result = ESTestCase.randomDouble();
            if (!lowerInclusive) {
                while (result <= 0.0) {
                    result = ESTestCase.randomDouble();
                }
            }
            result = result * end + (1.0 - result) * start;
        }
        return result;
    }

    public static Double randomOptionalDouble() {
        return ESTestCase.randomFrom(ESTestCase.randomDouble(), null);
    }

    public static long randomLong() {
        return ESTestCase.random().nextLong();
    }

    public static LongStream randomLongs() {
        return ESTestCase.random().longs();
    }

    public static LongStream randomLongs(long streamSize) {
        return ESTestCase.random().longs(streamSize);
    }

    public static BigInteger randomBigInteger() {
        return new BigInteger(64, ESTestCase.random());
    }

    public static int randomInt(int max) {
        return RandomizedTest.randomInt((int)max);
    }

    public static ByteSizeValue randomByteSizeValue() {
        return ByteSizeValue.ofBytes((long)ESTestCase.randomLongBetween(0L, 0x7FFFFFFFFFFFL));
    }

    @SafeVarargs
    public static <T> T randomFrom(T ... array) {
        return ESTestCase.randomFrom(ESTestCase.random(), array);
    }

    @SafeVarargs
    public static <T> T randomFrom(Random random, T ... array) {
        return (T)RandomPicks.randomFrom((Random)random, (Object[])array);
    }

    @SafeVarargs
    public static <T> T randomFrom(Random random, Supplier<T> ... array) {
        Supplier supplier = (Supplier)RandomPicks.randomFrom((Random)random, (Object[])array);
        return supplier.get();
    }

    public static <T> T randomFrom(List<T> list) {
        return (T)RandomPicks.randomFrom((Random)ESTestCase.random(), list);
    }

    public static <T> T randomFrom(Collection<T> collection) {
        return ESTestCase.randomFrom(ESTestCase.random(), collection);
    }

    public static <T> T randomFrom(Random random, Collection<T> collection) {
        return (T)RandomPicks.randomFrom((Random)random, collection);
    }

    public static String randomAlphaOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomAsciiOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomAlphaOfLength(int codeUnits) {
        return RandomizedTest.randomAsciiOfLength((int)codeUnits);
    }

    public static String randomAlphanumericOfLength(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = ESTestCase.random();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHANUMERIC_CHARACTERS.charAt(random.nextInt(ALPHANUMERIC_CHARACTERS.length())));
        }
        return sb.toString();
    }

    public static SecureString randomSecureStringOfLength(int codeUnits) {
        String randomAlpha = ESTestCase.randomAlphaOfLength(codeUnits);
        return new SecureString(randomAlpha.toCharArray());
    }

    public static String randomAlphaOfLengthOrNull(int codeUnits) {
        return ESTestCase.randomBoolean() ? null : ESTestCase.randomAlphaOfLength(codeUnits);
    }

    public static Long randomLongOrNull() {
        return ESTestCase.randomBoolean() ? null : Long.valueOf(ESTestCase.randomLong());
    }

    public static Long randomNonNegativeLongOrNull() {
        return ESTestCase.randomBoolean() ? null : Long.valueOf(ESTestCase.randomNonNegativeLong());
    }

    public static Integer randomIntOrNull() {
        return ESTestCase.randomBoolean() ? null : Integer.valueOf(ESTestCase.randomInt());
    }

    public static Integer randomNonNegativeIntOrNull() {
        return ESTestCase.randomBoolean() ? null : Integer.valueOf(ESTestCase.randomNonNegativeInt());
    }

    public static Float randomFloatOrNull() {
        return ESTestCase.randomBoolean() ? null : Float.valueOf(ESTestCase.randomFloat());
    }

    public static String randomIdentifier() {
        return ESTestCase.randomAlphaOfLengthBetween(8, 12).toLowerCase(Locale.ROOT);
    }

    public static ProjectId randomProjectIdOrDefault() {
        return ESTestCase.randomBoolean() ? Metadata.DEFAULT_PROJECT_ID : ESTestCase.randomUniqueProjectId();
    }

    public static ProjectId randomUniqueProjectId() {
        return ProjectId.fromId((String)ESTestCase.randomUUID());
    }

    public static String randomUUID() {
        return UUIDs.randomBase64UUID((Random)ESTestCase.random());
    }

    public static String randomUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomUnicodeOfLength((int)codeUnits);
    }

    public static String randomUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomUnicodeOfCodepointLength((int)codePoints);
    }

    public static String randomRealisticUnicodeOfLengthBetween(int minCodeUnits, int maxCodeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLengthBetween((int)minCodeUnits, (int)maxCodeUnits);
    }

    public static String randomRealisticUnicodeOfLength(int codeUnits) {
        return RandomizedTest.randomRealisticUnicodeOfLength((int)codeUnits);
    }

    public static String randomRealisticUnicodeOfCodepointLengthBetween(int minCodePoints, int maxCodePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLengthBetween((int)minCodePoints, (int)maxCodePoints);
    }

    public static String randomRealisticUnicodeOfCodepointLength(int codePoints) {
        return RandomizedTest.randomRealisticUnicodeOfCodepointLength((int)codePoints);
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull, boolean allowEmpty) {
        if (allowNull && ESTestCase.random().nextBoolean()) {
            return null;
        }
        int arraySize = ESTestCase.randomIntBetween(allowEmpty ? 0 : 1, maxArraySize);
        String[] array = new String[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = RandomStrings.randomAsciiOfLength((Random)ESTestCase.random(), (int)stringSize);
        }
        return array;
    }

    public static String[] generateRandomStringArray(int maxArraySize, int stringSize, boolean allowNull) {
        return ESTestCase.generateRandomStringArray(maxArraySize, stringSize, allowNull, true);
    }

    public static <T> T[] randomArray(int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        return ESTestCase.randomArray(0, maxArraySize, arrayConstructor, valueConstructor);
    }

    public static <T> T[] randomArray(int minArraySize, int maxArraySize, IntFunction<T[]> arrayConstructor, Supplier<T> valueConstructor) {
        int size = ESTestCase.randomIntBetween(minArraySize, maxArraySize);
        T[] array = arrayConstructor.apply(size);
        for (int i = 0; i < array.length; ++i) {
            array[i] = valueConstructor.get();
        }
        return array;
    }

    public static <T> List<T> randomList(int maxListSize, Supplier<T> valueConstructor) {
        return ESTestCase.randomList(0, maxListSize, valueConstructor);
    }

    public static <T> List<T> randomList(int minListSize, int maxListSize, Supplier<T> valueConstructor) {
        int size = ESTestCase.randomIntBetween(minListSize, maxListSize);
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            list.add(valueConstructor.get());
        }
        return list;
    }

    public static <K, V> Map<K, V> randomMap(int minMapSize, int maxMapSize, Supplier<Tuple<K, V>> entryConstructor) {
        int size = ESTestCase.randomIntBetween(minMapSize, maxMapSize);
        Map list = Maps.newMapWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            Tuple<K, V> entry = entryConstructor.get();
            list.put(entry.v1(), entry.v2());
        }
        return list;
    }

    public static <T> Set<T> randomSet(int minSetSize, int maxSetSize, Supplier<T> valueConstructor) {
        return new HashSet<T>(ESTestCase.randomList(minSetSize, maxSetSize, valueConstructor));
    }

    public static TimeValue randomTimeValue(int lower, int upper, TimeUnit ... units) {
        return new TimeValue((long)ESTestCase.between(lower, upper), ESTestCase.randomFrom(units));
    }

    public static TimeValue randomTimeValue(int lower, int upper) {
        return ESTestCase.randomTimeValue(lower, upper, TimeUnit.values());
    }

    public static TimeValue randomTimeValue() {
        return ESTestCase.randomTimeValue(0, 1000);
    }

    public static TimeValue randomPositiveTimeValue() {
        return ESTestCase.randomTimeValue(1, 1000);
    }

    public static TimeValue randomTimeValueGreaterThan(TimeValue lowerBound) {
        TimeUnit randomUnit = ESTestCase.randomFrom(TimeUnit.values());
        long lowerBoundDuration = randomUnit.convert(lowerBound.duration(), lowerBound.timeUnit());
        long duration = lowerBoundDuration + ESTestCase.randomLongBetween(1L, 1000L);
        return new TimeValue(duration, randomUnit);
    }

    public static long randomMillisUpToYear9999() {
        return ESTestCase.randomLongBetween(1L, 253402300799999L);
    }

    public static TimeZone randomTimeZone() {
        return TimeZone.getTimeZone(ESTestCase.randomFrom(JAVA_TIMEZONE_IDS));
    }

    public static ZoneId randomZone() {
        return ZoneId.of(ESTestCase.randomFrom(JAVA_ZONE_IDS));
    }

    public static String randomDateFormatterPattern() {
        return ESTestCase.randomFrom(FormatNames.values()).getName();
    }

    public static String randomSecretKey() {
        return ESTestCase.randomAlphaOfLengthBetween(14, 20);
    }

    public static Executor randomExecutor(ThreadPool threadPool, String ... otherExecutorNames) {
        int choice = ESTestCase.between(0, otherExecutorNames.length + 1);
        if (choice < otherExecutorNames.length) {
            return threadPool.executor(otherExecutorNames[choice]);
        }
        if (choice == otherExecutorNames.length) {
            return threadPool.generic();
        }
        return EsExecutors.DIRECT_EXECUTOR_SERVICE;
    }

    public static <T> void maybeSet(Consumer<T> consumer, T value) {
        if (ESTestCase.randomBoolean()) {
            consumer.accept(value);
        }
    }

    public static <T> T randomValueOtherThan(T input, Supplier<T> randomSupplier) {
        assert (input == null || !input.getClass().isArray()) : "randomValueOtherThan() does not work as expected with arrays, use randomArrayOtherThan() instead";
        return (T)ESTestCase.randomValueOtherThanMany(v -> Objects.equals(input, v), randomSupplier);
    }

    public static <T> T[] randomArrayOtherThan(T[] input, Supplier<T[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static boolean[] randomArrayOtherThan(boolean[] input, Supplier<boolean[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static byte[] randomArrayOtherThan(byte[] input, Supplier<byte[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static char[] randomArrayOtherThan(char[] input, Supplier<char[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static short[] randomArrayOtherThan(short[] input, Supplier<short[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static int[] randomArrayOtherThan(int[] input, Supplier<int[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static long[] randomArrayOtherThan(long[] input, Supplier<long[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static float[] randomArrayOtherThan(float[] input, Supplier<float[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static double[] randomArrayOtherThan(double[] input, Supplier<double[]> randomSupplier) {
        return ESTestCase.randomValueOtherThanMany(v -> Arrays.equals(input, v), randomSupplier);
    }

    public static <T> T randomValueOtherThanMany(Predicate<T> input, Supplier<T> randomSupplier) {
        T randomValue = null;
        while (input.test(randomValue = (T)randomSupplier.get())) {
        }
        return randomValue;
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock) throws Exception {
        ESTestCase.assertBusy(codeBlock, 10L, TimeUnit.SECONDS);
    }

    public static void assertBusy(CheckedRunnable<Exception> codeBlock, long maxWaitTime, TimeUnit unit) throws Exception {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long iterations = Math.max(Math.round(Math.log10(maxTimeInMillis) / Math.log10(2.0)), 1L);
        long timeInMillis = 1L;
        long sum = 0L;
        ArrayList<AssertionError> failures = new ArrayList<AssertionError>();
        int i = 0;
        while ((long)i < iterations) {
            try {
                codeBlock.run();
                return;
            }
            catch (AssertionError e) {
                failures.add(e);
                sum += timeInMillis;
                Thread.sleep(timeInMillis);
                timeInMillis *= 2L;
                ++i;
            }
        }
        timeInMillis = maxTimeInMillis - sum;
        Thread.sleep(Math.max(timeInMillis, 0L));
        try {
            codeBlock.run();
        }
        catch (AssertionError e) {
            for (AssertionError failure : failures) {
                ((Throwable)((Object)e)).addSuppressed((Throwable)((Object)failure));
            }
            throw e;
        }
    }

    public static boolean waitUntil(BooleanSupplier breakSupplier) {
        return ESTestCase.waitUntil(breakSupplier, 10L, TimeUnit.SECONDS);
    }

    public static boolean waitUntil(BooleanSupplier breakSupplier, long maxWaitTime, TimeUnit unit) {
        long maxTimeInMillis = TimeUnit.MILLISECONDS.convert(maxWaitTime, unit);
        long timeInMillis = 1L;
        long sum = 0L;
        while (sum + timeInMillis < maxTimeInMillis) {
            if (breakSupplier.getAsBoolean()) {
                return true;
            }
            ESTestCase.safeSleep(timeInMillis);
            sum += timeInMillis;
            timeInMillis = Math.min(1000L, timeInMillis * 2L);
        }
        timeInMillis = maxTimeInMillis - sum;
        ESTestCase.safeSleep(Math.max(timeInMillis, 0L));
        return breakSupplier.getAsBoolean();
    }

    protected TestThreadPool createThreadPool(ExecutorBuilder<?> ... executorBuilders) {
        return new TestThreadPool(this.getTestName(), executorBuilders);
    }

    public static boolean terminate(ExecutorService ... services) {
        boolean terminated = true;
        for (ExecutorService service : services) {
            if (service == null) continue;
            terminated &= ThreadPool.terminate((ExecutorService)service, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        return terminated;
    }

    public static boolean terminate(ThreadPool threadPool) {
        return ThreadPool.terminate((ThreadPool)threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    public Path getDataPath(String relativePath) {
        return ESTestCase.getResourceDataPath(((Object)((Object)this)).getClass(), relativePath);
    }

    public static Path getResourceDataPath(Class<?> clazz, String relativePath) {
        URI uri;
        URL resource = Objects.requireNonNullElseGet(clazz.getResource(relativePath), () -> (URL)ESTestCase.fail(null, "resource not found: [%s][%s]", clazz.getCanonicalName(), relativePath));
        try {
            uri = resource.toURI();
        }
        catch (Exception e) {
            return (Path)ESTestCase.fail(null, "resource URI not found: [%s][%s]", clazz.getCanonicalName(), relativePath);
        }
        try {
            return PathUtils.get((URI)uri).toAbsolutePath().normalize();
        }
        catch (Exception e) {
            return (Path)ESTestCase.fail(e, "resource path not found: %s", uri);
        }
    }

    public String[] tmpPaths() {
        int numPaths = TestUtil.nextInt((Random)ESTestCase.random(), (int)1, (int)3);
        String[] absPaths = new String[numPaths];
        for (int i = 0; i < numPaths; ++i) {
            absPaths[i] = ESTestCase.createTempDir().toAbsolutePath().toString();
        }
        return absPaths;
    }

    public NodeEnvironment newNodeEnvironment() throws IOException {
        return this.newNodeEnvironment(Settings.EMPTY);
    }

    public Settings buildEnvSettings(Settings settings) {
        return Settings.builder().put(settings).put(Environment.PATH_HOME_SETTING.getKey(), ESTestCase.createTempDir().toAbsolutePath()).putList(Environment.PATH_DATA_SETTING.getKey(), this.tmpPaths()).build();
    }

    public NodeEnvironment newNodeEnvironment(Settings settings) throws IOException {
        Settings build = this.buildEnvSettings(settings);
        return new NodeEnvironment(build, TestEnvironment.newEnvironment(build));
    }

    public Environment newEnvironment() {
        Settings build = this.buildEnvSettings(Settings.EMPTY);
        return TestEnvironment.newEnvironment(build);
    }

    public Environment newEnvironment(Settings settings) {
        Settings build = this.buildEnvSettings(settings);
        return TestEnvironment.newEnvironment(build);
    }

    public static IndexSettings defaultIndexSettings() {
        IndexMetadata INDEX_METADATA = IndexMetadata.builder((String)"index").settings(Settings.builder().put("index.version.created", (VersionId)IndexVersion.current())).numberOfShards(1).numberOfReplicas(0).build();
        return new IndexSettings(INDEX_METADATA, Settings.EMPTY);
    }

    public static Settings.Builder settings(IndexVersion version) {
        return Settings.builder().put("index.version.created", (VersionId)version);
    }

    public static Settings.Builder indexSettings(IndexVersion indexVersionCreated, int shards, int replicas) {
        return ESTestCase.settings(indexVersionCreated).put("index.number_of_shards", shards).put("index.number_of_replicas", replicas);
    }

    public static Settings.Builder indexSettings(IndexVersion indexVersionCreated, String uuid, int shards, int replicas) {
        return ESTestCase.settings(indexVersionCreated).put("index.uuid", uuid).put("index.number_of_shards", shards).put("index.number_of_replicas", replicas);
    }

    public static Settings.Builder indexSettings(int shards, int replicas) {
        return Settings.builder().put("index.number_of_shards", shards).put("index.number_of_replicas", replicas);
    }

    @SafeVarargs
    public static <T> List<T> randomSubsetOf(int size, T ... values) {
        ArrayList list = CollectionUtils.arrayAsArrayList((Object[])values);
        return ESTestCase.randomSubsetOf(size, list);
    }

    public static <T> List<T> randomSubsetOf(Collection<T> collection) {
        return ESTestCase.randomSubsetOf(ESTestCase.randomInt(collection.size()), collection);
    }

    public static <T> List<T> randomNonEmptySubsetOf(Collection<T> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Can't pick non-empty subset of an empty collection");
        }
        return ESTestCase.randomSubsetOf(ESTestCase.randomIntBetween(1, collection.size()), collection);
    }

    public static <T> List<T> randomSubsetOf(int size, Collection<T> collection) {
        if (size > collection.size()) {
            throw new IllegalArgumentException("Can't pick " + size + " random objects from a collection of " + collection.size() + " objects");
        }
        ArrayList<T> tempList = new ArrayList<T>(collection);
        Collections.shuffle(tempList, ESTestCase.random());
        return tempList.subList(0, size);
    }

    @SafeVarargs
    public static <T> List<T> shuffledList(T ... values) {
        return ESTestCase.shuffledList(Arrays.asList(values));
    }

    public static <T> List<T> shuffledList(List<T> list) {
        return ESTestCase.randomSubsetOf(list.size(), list);
    }

    public static <T> Set<T> randomUnique(Supplier<T> supplier, int targetCount) {
        HashSet<T> things = new HashSet<T>();
        int maxTries = targetCount * 10;
        for (int t = 0; t < maxTries; ++t) {
            if (things.size() == targetCount) {
                return things;
            }
            things.add(supplier.get());
        }
        return things;
    }

    public static String randomGeohash(int minPrecision, int maxPrecision) {
        return geohashGenerator.ofStringLength(ESTestCase.random(), minPrecision, maxPrecision);
    }

    public static String getTestTransportType() {
        return "netty4";
    }

    public static Class<? extends Plugin> getTestTransportPlugin() {
        return Netty4Plugin.class;
    }

    public String randomCompatibleMediaType(RestApiVersion version) {
        XContentType type = ESTestCase.randomFrom(XContentType.VND_JSON, XContentType.VND_SMILE, XContentType.VND_CBOR, XContentType.VND_YAML);
        return this.compatibleMediaType(type, version);
    }

    public String compatibleMediaType(XContentType type, RestApiVersion version) {
        if (type.canonical().equals((Object)type)) {
            throw new IllegalArgumentException("Compatible header is only supported for vendor content types. You requested " + type.name() + "but likely want VND_" + type.name());
        }
        return type.toParsedMediaType().responseContentTypeHeader(Map.of("compatible-with", String.valueOf(version.major)));
    }

    public XContentType randomVendorType() {
        return ESTestCase.randomFrom(XContentType.VND_JSON, XContentType.VND_SMILE, XContentType.VND_CBOR, XContentType.VND_YAML);
    }

    protected final BytesReference toShuffledXContent(ToXContent toXContent, XContentType xContentType, ToXContent.Params params, boolean humanReadable, String ... exceptFieldNames) throws IOException {
        return this.toShuffledXContent(toXContent, xContentType, RestApiVersion.current(), params, humanReadable, exceptFieldNames);
    }

    protected final BytesReference toShuffledXContent(ToXContent toXContent, XContentType xContentType, RestApiVersion restApiVersion, ToXContent.Params params, boolean humanReadable, String ... exceptFieldNames) throws IOException {
        BytesReference bytes = XContentHelper.toXContent((ToXContent)toXContent, (XContentType)xContentType, (RestApiVersion)restApiVersion, (ToXContent.Params)params, (boolean)humanReadable);
        try (XContentParser parser = this.createParser(xContentType.xContent(), bytes);){
            BytesReference bytesReference;
            block12: {
                XContentBuilder builder = ESTestCase.shuffleXContent(parser, ESTestCase.rarely(), exceptFieldNames);
                try {
                    bytesReference = BytesReference.bytes((XContentBuilder)builder);
                    if (builder == null) break block12;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return bytesReference;
        }
    }

    protected final XContentBuilder shuffleXContent(XContentBuilder builder, String ... exceptFieldNames) throws IOException {
        try (XContentParser parser = this.createParser(builder);){
            XContentBuilder xContentBuilder = ESTestCase.shuffleXContent(parser, builder.isPrettyPrint(), exceptFieldNames);
            return xContentBuilder;
        }
    }

    public static XContentBuilder shuffleXContent(XContentParser parser, boolean prettyPrint, String ... exceptFieldNames) throws IOException {
        XContentParser.Token token;
        XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)parser.contentType());
        if (prettyPrint) {
            xContentBuilder.prettyPrint();
        }
        XContentParser.Token token2 = token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            List<Object> shuffledList = ESTestCase.shuffleList(parser.listOrderedMap(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
            return xContentBuilder.value(shuffledList);
        }
        LinkedHashMap<String, Object> shuffledMap = ESTestCase.shuffleMap((LinkedHashMap)parser.mapOrdered(), new HashSet<String>(Arrays.asList(exceptFieldNames)));
        return xContentBuilder.map(shuffledMap);
    }

    private static List<Object> shuffleList(List<Object> list, Set<String> exceptFields) {
        ArrayList<Object> targetList = new ArrayList<Object>();
        for (Object value : list) {
            if (value instanceof Map) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetList.add(ESTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof List) {
                targetList.add(ESTestCase.shuffleList((List)value, exceptFields));
                continue;
            }
            targetList.add(value);
        }
        return targetList;
    }

    public static LinkedHashMap<String, Object> shuffleMap(LinkedHashMap<String, Object> map, Set<String> exceptFields) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        LinkedHashMap<String, Object> targetMap = new LinkedHashMap<String, Object>();
        Collections.shuffle(keys, ESTestCase.random());
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof Map && !exceptFields.contains(key)) {
                LinkedHashMap valueMap = (LinkedHashMap)value;
                targetMap.put(key, ESTestCase.shuffleMap(valueMap, exceptFields));
                continue;
            }
            if (value instanceof List && !exceptFields.contains(key)) {
                targetMap.put(key, ESTestCase.shuffleList((List)value, exceptFields));
                continue;
            }
            targetMap.put(key, value);
        }
        return targetMap;
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        return ESTestCase.copyWriteable(original, namedWriteableRegistry, reader, TransportVersion.current());
    }

    public static <T extends Writeable> T copyWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, TransportVersion version) throws IOException {
        return ESTestCase.copyInstance(original, namedWriteableRegistry, StreamOutput::writeWriteable, reader, version);
    }

    public static <C extends NamedWriteable, T extends C> C copyNamedWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Class<C> categoryClass) throws IOException {
        return ESTestCase.copyNamedWriteable(original, namedWriteableRegistry, categoryClass, TransportVersion.current());
    }

    public static <C extends NamedWriteable, T extends C> C copyNamedWriteable(T original, NamedWriteableRegistry namedWriteableRegistry, Class<C> categoryClass, TransportVersion version) throws IOException {
        return (C)((NamedWriteable)ESTestCase.copyInstance(original, namedWriteableRegistry, StreamOutput::writeNamedWriteable, in -> in.readNamedWriteable(categoryClass), version));
    }

    protected static <T extends Writeable> T copyInstance(T original, NamedWriteableRegistry namedWriteableRegistry, Writeable.Writer<T> writer, Writeable.Reader<T> reader, TransportVersion version) throws IOException {
        Writeable writeable;
        BytesStreamOutput output = new BytesStreamOutput();
        output.setTransportVersion(version);
        writer.write((StreamOutput)output, original);
        if (ESTestCase.randomBoolean()) {
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);
            in.setTransportVersion(version);
            Writeable writeable2 = (Writeable)reader.read((StreamInput)in);
            return (T)writeable2;
            finally {
                in.close();
            }
        }
        BytesReference bytesReference = output.copyBytes();
        output.reset();
        bytesReference.writeTo((OutputStream)output);
        try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);){
            in.setTransportVersion(version);
            writeable = (Writeable)reader.read((StreamInput)in);
        }
        return (T)writeable;
        finally {
            output.close();
        }
    }

    protected final XContentParserConfiguration parserConfig() {
        XContentParserConfiguration config = XContentParserConfiguration.EMPTY.withRegistry(this.xContentRegistry()).withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        return ESTestCase.randomBoolean() ? config : config.withRestApiVersion(RestApiVersion.minimumSupported());
    }

    protected final XContentParser createParser(XContentBuilder builder) throws IOException {
        return this.createParser(builder.contentType().xContent(), BytesReference.bytes((XContentBuilder)builder));
    }

    protected final XContentParser createParser(XContent xContent, String data) throws IOException {
        return xContent.createParser(this.parserConfig(), data);
    }

    protected final XContentParser createParser(XContent xContent, InputStream data) throws IOException {
        return xContent.createParser(this.parserConfig(), data);
    }

    protected final XContentParser createParser(XContent xContent, byte[] data) throws IOException {
        return xContent.createParser(this.parserConfig(), data);
    }

    protected final XContentParser createParser(XContent xContent, BytesReference data) throws IOException {
        return this.createParser(this.parserConfig(), xContent, data);
    }

    protected final XContentParser createParser(XContentParserConfiguration config, XContent xContent, BytesReference data) throws IOException {
        return XContentHelper.createParserNotCompressed((XContentParserConfiguration)config, (BytesReference)data, (XContentType)xContent.type());
    }

    protected final XContentParser createParserWithCompatibilityFor(XContent xContent, String data, RestApiVersion restApiVersion) throws IOException {
        return xContent.createParser(this.parserConfig().withRestApiVersion(restApiVersion), data);
    }

    protected NamedXContentRegistry xContentRegistry() {
        return DEFAULT_NAMED_X_CONTENT_REGISTRY;
    }

    protected NamedWriteableRegistry writableRegistry() {
        return new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }

    public static Script mockScript(String id) {
        return new Script(ScriptType.INLINE, "mockscript", id, Collections.emptyMap());
    }

    public static TestRuleMarkFailure getSuiteFailureMarker() {
        return suiteFailureMarker;
    }

    public static void assertArrayEquals(StackTraceElement[] expected, StackTraceElement[] actual) {
        ESTestCase.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            ESTestCase.assertEquals(expected[i], actual[i]);
        }
    }

    public static void assertEquals(StackTraceElement expected, StackTraceElement actual) {
        ESTestCase.assertEquals((Object)expected.getClassName(), (Object)actual.getClassName());
        ESTestCase.assertEquals((Object)expected.getMethodName(), (Object)actual.getMethodName());
        ESTestCase.assertEquals((Object)expected.getFileName(), (Object)actual.getFileName());
        ESTestCase.assertEquals((long)expected.getLineNumber(), (long)actual.getLineNumber());
        ESTestCase.assertEquals((Object)expected.isNativeMethod(), (Object)actual.isNativeMethod());
    }

    protected static long spinForAtLeastOneMillisecond() {
        return ESTestCase.spinForAtLeastNMilliseconds(1L);
    }

    protected static long spinForAtLeastNMilliseconds(long ms) {
        long elapsed;
        long nanosecondsInMillisecond = TimeUnit.NANOSECONDS.convert(ms, TimeUnit.MILLISECONDS);
        long start = System.nanoTime();
        while ((elapsed = System.nanoTime() - start) < nanosecondsInMillisecond) {
        }
        return elapsed;
    }

    protected IndexAnalyzers createDefaultIndexAnalyzers() {
        return (type, name) -> {
            if (type == IndexAnalyzers.AnalyzerType.ANALYZER && "default".equals(name)) {
                return Lucene.STANDARD_ANALYZER;
            }
            return null;
        };
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings nodeSettings = Settings.builder().put(Environment.PATH_HOME_SETTING.getKey(), ESTestCase.createTempDir()).build();
        return ESTestCase.createTestAnalysis(index, nodeSettings, settings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(Index index, Settings nodeSettings, Settings settings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Settings indexSettings = Settings.builder().put(settings).put("index.version.created", (VersionId)IndexVersion.current()).build();
        return ESTestCase.createTestAnalysis(IndexSettingsModule.newIndexSettings(index, indexSettings, new Setting[0]), nodeSettings, analysisPlugins);
    }

    public static TestAnalysis createTestAnalysis(IndexSettings indexSettings, Settings nodeSettings, AnalysisPlugin ... analysisPlugins) throws IOException {
        Environment env = TestEnvironment.newEnvironment(nodeSettings);
        AnalysisModule analysisModule = new AnalysisModule(env, Arrays.asList(analysisPlugins), new StablePluginsRegistry());
        AnalysisRegistry analysisRegistry = analysisModule.getAnalysisRegistry();
        return new TestAnalysis(analysisRegistry.build(IndexService.IndexCreationContext.CREATE_INDEX, indexSettings), analysisRegistry.buildTokenFilterFactories(indexSettings), analysisRegistry.buildTokenizerFactories(indexSettings), analysisRegistry.buildCharFilterFactories(indexSettings));
    }

    private static boolean isUnusableLocale() {
        return ESTestCase.inFipsJvm() && (Locale.getDefault().toLanguageTag().equals("th-TH") || Locale.getDefault().toLanguageTag().equals("ja-JP-u-ca-japanese-x-lvariant-JP") || Locale.getDefault().toLanguageTag().equals("th-TH-u-nu-thai-x-lvariant-TH"));
    }

    public static boolean inFipsJvm() {
        return Booleans.parseBoolean((String)System.getProperty(FIPS_SYSPROP, "false"));
    }

    public static String getPortRange() {
        int firstPort = ESTestCase.getWorkerBasePort();
        int lastPort = firstPort + 30 - 1;
        assert (13301 <= firstPort && lastPort <= Short.MAX_VALUE);
        return firstPort + "-" + lastPort;
    }

    protected static int getWorkerBasePort() {
        String workerIdStr = System.getProperty(TEST_WORKER_SYS_PROPERTY);
        if (workerIdStr == null) {
            return 13301;
        }
        int workerId = Integer.parseInt(workerIdStr);
        assert (workerId >= 1) : "Non positive gradle worker id: " + workerIdStr;
        return ESTestCase.getWorkerBasePort(workerId % 647);
    }

    private static int getWorkerBasePort(int effectiveWorkerId) {
        assert (0 <= effectiveWorkerId && effectiveWorkerId <= 646);
        return 13331 + effectiveWorkerId * 30;
    }

    public static InetAddress randomIp(boolean v4) {
        try {
            if (v4) {
                byte[] ipv4 = new byte[4];
                ESTestCase.random().nextBytes(ipv4);
                return InetAddress.getByAddress(ipv4);
            }
            byte[] ipv6 = new byte[16];
            ESTestCase.random().nextBytes(ipv6);
            return InetAddress.getByAddress(ipv6);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    protected void skipTestWaitingForLuceneFix(Version luceneVersionWithFix, String message) {
        boolean currentVersionHasFix = IndexVersion.current().luceneVersion().onOrAfter(luceneVersionWithFix);
        ESTestCase.assumeTrue((String)("Skipping test as it is waiting on a Lucene fix: " + message), (boolean)currentVersionHasFix);
        ESTestCase.fail((String)("Remove call of skipTestWaitingForLuceneFix in " + String.valueOf(RandomizedTest.getContext().getTargetMethod())));
    }

    public static SecureRandom secureRandom() throws NoSuchAlgorithmException, NoSuchProviderException {
        return ESTestCase.secureRandom(ESTestCase.randomByteArrayOfLength(32));
    }

    public static SecureRandom secureRandom(byte[] seed) throws NoSuchAlgorithmException, NoSuchProviderException {
        return ESTestCase.inFipsJvm() ? ESTestCase.secureRandomFips(seed) : ESTestCase.secureRandomNonFips(seed);
    }

    protected static SecureRandom secureRandomNonFips() throws NoSuchAlgorithmException {
        return ESTestCase.secureRandomNonFips(ESTestCase.randomByteArrayOfLength(32));
    }

    protected static SecureRandom secureRandomFips() throws NoSuchAlgorithmException {
        return ESTestCase.secureRandomFips(ESTestCase.randomByteArrayOfLength(32));
    }

    protected static SecureRandom secureRandomNonFips(byte[] seed) throws NoSuchAlgorithmException {
        SecureRandom secureRandomNonFips = SecureRandom.getInstance("SHA1PRNG");
        secureRandomNonFips.setSeed(seed);
        return secureRandomNonFips;
    }

    protected static SecureRandom secureRandomFips(byte[] seed) throws NoSuchAlgorithmException {
        SecureRandom secureRandomFips = SecureRandom.getInstance("DEFAULT");
        if (WARN_SECURE_RANDOM_FIPS_NOT_DETERMINISTIC.get() == null) {
            WARN_SECURE_RANDOM_FIPS_NOT_DETERMINISTIC.set((Object)Boolean.TRUE);
            Provider provider = secureRandomFips.getProvider();
            String providerName = provider.getName();
            Logger logger = LogManager.getLogger(ESTestCase.class);
            logger.warn("Returning a non-deterministic secureRandom for use with FIPS. This may result in difficulty reproducing test failures with from a given a seed.");
        }
        secureRandomFips.setSeed(seed);
        return secureRandomFips;
    }

    public static void safeAwait(CyclicBarrier barrier) {
        try {
            barrier.await(SAFE_AWAIT_TIMEOUT.millis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ESTestCase.fail(e, "safeAwait: interrupted waiting for CyclicBarrier release", new Object[0]);
        }
        catch (Exception e) {
            ESTestCase.fail(e, "safeAwait: CyclicBarrier did not release within the timeout", new Object[0]);
        }
    }

    public static void safeAwait(CountDownLatch countDownLatch) {
        ESTestCase.safeAwait(countDownLatch, SAFE_AWAIT_TIMEOUT);
    }

    public static void safeAwait(CountDownLatch countDownLatch, TimeValue timeout) {
        try {
            ESTestCase.assertTrue((String)"safeAwait: CountDownLatch did not reach zero within the timeout", (boolean)countDownLatch.await(timeout.millis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ESTestCase.fail(e, "safeAwait: interrupted waiting for CountDownLatch to reach zero", new Object[0]);
        }
    }

    public static void safeAcquire(Semaphore semaphore) {
        ESTestCase.safeAcquire(1, semaphore);
    }

    public static void safeAcquire(int permits, Semaphore semaphore) {
        try {
            ESTestCase.assertTrue((String)"safeAcquire: Semaphore did not acquire permit within the timeout", (boolean)semaphore.tryAcquire(permits, SAFE_AWAIT_TIMEOUT.millis(), TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ESTestCase.fail(e, "safeAcquire: interrupted waiting for Semaphore to acquire " + permits + " permit(s)", new Object[0]);
        }
    }

    public static <T> T safeAwait(SubscribableListener<T> listener) {
        return ESTestCase.safeAwait(listener, SAFE_AWAIT_TIMEOUT);
    }

    public static <T> T safeAwait(SubscribableListener<T> listener, TimeValue timeout) {
        TestPlainActionFuture future = new TestPlainActionFuture();
        listener.addListener(future);
        return ESTestCase.safeGet(future, timeout);
    }

    public static <T> T safeAwait(CheckedConsumer<ActionListener<T>, ?> consumer) {
        return ESTestCase.safeAwait(SubscribableListener.newForked(consumer));
    }

    public static <T extends ActionResponse> T safeExecute(ElasticsearchClient client, ActionType<T> action, ActionRequest request) {
        return (T)((ActionResponse)ESTestCase.safeAwait(l -> client.execute(action, request, l)));
    }

    public static <T> T safeGet(Future<T> future) {
        return ESTestCase.safeGet(future, SAFE_AWAIT_TIMEOUT);
    }

    private static <T> T safeGet(Future<T> future, TimeValue timeout) {
        try {
            return future.get(timeout.millis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AssertionError("safeGet: interrupted waiting for SubscribableListener", e);
        }
        catch (ExecutionException e) {
            throw new AssertionError("safeGet: listener was completed exceptionally", e);
        }
        catch (TimeoutException e) {
            throw new AssertionError("safeGet: listener was not completed within the timeout", e);
        }
    }

    public static <T> T safeGet(CheckedSupplier<T, ?> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (Exception e) {
            return ESTestCase.fail(e);
        }
    }

    public static Exception safeAwaitFailure(SubscribableListener<?> listener) {
        return (Exception)ESTestCase.safeAwait(exceptionListener -> listener.addListener(ActionTestUtils.assertNoSuccessListener(arg_0 -> ((ActionListener)exceptionListener).onResponse(arg_0))));
    }

    public static <T> Exception safeAwaitFailure(Consumer<ActionListener<T>> consumer) {
        return (Exception)ESTestCase.safeAwait(exceptionListener -> consumer.accept(ActionTestUtils.assertNoSuccessListener(arg_0 -> ((ActionListener)exceptionListener).onResponse(arg_0))));
    }

    public static <T> Exception safeAwaitFailure(Class<T> responseType, Consumer<ActionListener<T>> consumer) {
        return ESTestCase.safeAwaitFailure(consumer);
    }

    public static <Response, ExpectedException extends Exception> ExpectedException safeAwaitFailure(Class<ExpectedException> exceptionType, Class<Response> responseType, Consumer<ActionListener<Response>> consumer) {
        return (ExpectedException)((Exception)ESTestCase.asInstanceOf(exceptionType, ESTestCase.safeAwaitFailure(responseType, consumer)));
    }

    public static <Response, ExpectedException extends Exception> ExpectedException safeAwaitAndUnwrapFailure(Class<ExpectedException> exceptionType, Class<Response> responseType, Consumer<ActionListener<Response>> consumer) {
        return (ExpectedException)((Exception)ESTestCase.asInstanceOf(exceptionType, ExceptionsHelper.unwrapCause((Throwable)ESTestCase.safeAwaitFailure(responseType, consumer))));
    }

    public static void safeSleep(TimeValue timeValue) {
        ESTestCase.safeSleep(timeValue.millis());
    }

    public static void safeSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ESTestCase.fail(e, "safeSleep: interrupted", new Object[0]);
        }
    }

    public static void flushThreadPoolExecutor(ThreadPool threadPool, String executorName) {
        int maxThreads = threadPool.info(executorName).getMax();
        final CyclicBarrier barrier = new CyclicBarrier(maxThreads + 1);
        ExecutorService executor = threadPool.executor(executorName);
        for (int i = 0; i < maxThreads; ++i) {
            executor.execute((Runnable)new AbstractRunnable(){

                protected void doRun() {
                    ESTestCase.safeAwait(barrier);
                }

                public void onFailure(Exception e) {
                    ESTestCase.fail(e, "unexpected", new Object[0]);
                }

                public boolean isForceExecution() {
                    return true;
                }
            });
        }
        ESTestCase.safeAwait(barrier);
    }

    protected static boolean isTurkishLocale() {
        return Locale.getDefault().getLanguage().equals(new Locale("tr").getLanguage()) || Locale.getDefault().getLanguage().equals(new Locale("az").getLanguage());
    }

    public static <T> void assertThat(T actual, Matcher<? super T> matcher) {
        MatcherAssert.assertThat(actual, matcher);
    }

    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        MatcherAssert.assertThat((String)reason, actual, matcher);
    }

    public static <T> T fail(Throwable t, String msg, Object ... args) {
        throw new AssertionError(org.elasticsearch.common.Strings.format((String)msg, (Object[])args), t);
    }

    public static <T> T fail(Throwable t) {
        return ESTestCase.fail(t, "unexpected", new Object[0]);
    }

    public static <T> T asInstanceOf(Class<T> clazz, Object o) {
        ESTestCase.assertThat(o, Matchers.instanceOf(clazz));
        return (T)o;
    }

    public static <T extends Throwable> T expectThrows(Class<T> expectedType, ActionFuture<? extends RefCounted> future) {
        return (T)ESTestCase.expectThrows(expectedType, (String)("Expected exception " + expectedType.getSimpleName() + " but no exception was thrown"), () -> ((RefCounted)future.actionGet()).decRef());
    }

    public static <T extends Throwable> T expectThrows(Class<T> expectedType, RequestBuilder<?, ?> builder) {
        return (T)ESTestCase.expectThrows(expectedType, (String)("Expected exception " + expectedType.getSimpleName() + " but no exception was thrown"), () -> builder.get().decRef());
    }

    public static <T extends Throwable> T expectThrows(Class<T> expectedType, Matcher<String> messageMatcher, LuceneTestCase.ThrowingRunnable runnable) {
        Throwable e = ESTestCase.expectThrows(expectedType, (LuceneTestCase.ThrowingRunnable)runnable);
        ESTestCase.assertThat(e.getMessage(), messageMatcher);
        return (T)e;
    }

    public static <T extends Throwable> T expectThrows(String reason, Class<T> expectedType, Matcher<String> messageMatcher, LuceneTestCase.ThrowingRunnable runnable) {
        Throwable e = ESTestCase.expectThrows(expectedType, (String)reason, (LuceneTestCase.ThrowingRunnable)runnable);
        ESTestCase.assertThat(reason, e.getMessage(), messageMatcher);
        return (T)e;
    }

    public static void startInParallel(int numberOfTasks, IntConsumer taskFactory) {
        CyclicBarrier barrier = new CyclicBarrier(numberOfTasks);
        ESTestCase.runInParallel(numberOfTasks, (int i) -> {
            ESTestCase.safeAwait(barrier);
            taskFactory.accept(i);
        });
    }

    public static void runInParallel(int numberOfTasks, IntConsumer taskFactory) {
        ArrayList<FutureTask<Object>> futures = new ArrayList<FutureTask<Object>>(numberOfTasks);
        Thread[] threads = new Thread[numberOfTasks - 1];
        for (int i = 0; i < numberOfTasks; ++i) {
            int index = i;
            FutureTask<Object> futureTask = new FutureTask<Object>(() -> taskFactory.accept(index), null);
            futures.add(futureTask);
            if (i == numberOfTasks - 1) {
                futureTask.run();
                continue;
            }
            threads[i] = new Thread(futureTask);
            threads[i].setName("TEST-runInParallel-T#" + i);
            threads[i].start();
        }
        Exception e = null;
        try {
            for (Thread thread : threads) {
                thread.join();
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw interruptedException;
                }
                catch (Exception executionException) {
                    e = (Exception)ExceptionsHelper.useOrSuppress((Throwable)e, (Throwable)executionException);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            e = (Exception)ExceptionsHelper.useOrSuppress(e, (Throwable)interruptedException);
        }
        if (e != null) {
            throw new AssertionError((Object)e);
        }
    }

    public static void runInParallel(Runnable ... tasks) {
        ESTestCase.runInParallel(tasks.length, (int i) -> tasks[i].run());
    }

    public static void ensureAllContextsReleased(SearchService searchService) {
        try {
            ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                ESTestCase.assertThat(searchService.getActiveContexts(), Matchers.equalTo((Object)0));
                ESTestCase.assertThat(searchService.getOpenScrollContexts(), Matchers.equalTo((Object)0));
            }));
        }
        catch (Exception e) {
            throw new AssertionError("Failed to verify search contexts", e);
        }
    }

    public static IndexSearcher newSearcher(IndexReader r) {
        return ESTestCase.newSearcher(r, true);
    }

    public static IndexSearcher newSearcher(IndexReader r, boolean maybeWrap) {
        return ESTestCase.newSearcher(r, maybeWrap, true);
    }

    public static IndexSearcher newSearcher(IndexReader r, boolean maybeWrap, boolean wrapWithAssertions) {
        return ESTestCase.newSearcher(r, maybeWrap, wrapWithAssertions, ESTestCase.randomBoolean());
    }

    public static IndexSearcher newSearcher(IndexReader r, boolean maybeWrap, boolean wrapWithAssertions, boolean useThreads) {
        if (useThreads) {
            return ESTestCase.newSearcher((IndexReader)r, (boolean)maybeWrap, (boolean)wrapWithAssertions, (LuceneTestCase.Concurrency)LuceneTestCase.Concurrency.INTER_SEGMENT);
        }
        return ESTestCase.newSearcher((IndexReader)r, (boolean)maybeWrap, (boolean)wrapWithAssertions, (LuceneTestCase.Concurrency)LuceneTestCase.Concurrency.NONE);
    }

    public static ProjectState projectStateFromProject(ProjectMetadata.Builder project) {
        return ClusterState.builder((ClusterName)ClusterName.DEFAULT).putProjectMetadata(project).build().projectState(project.getId());
    }

    public static ProjectState projectStateFromProject(ProjectMetadata project) {
        return ClusterState.builder((ClusterName)ClusterName.DEFAULT).putProjectMetadata(project).build().projectState(project.id());
    }

    public static ProjectState projectStateWithEmptyProject() {
        return ESTestCase.projectStateFromProject(ProjectMetadata.builder((ProjectId)ESTestCase.randomProjectIdOrDefault()));
    }

    public static ProjectMetadata emptyProject() {
        return ProjectMetadata.builder((ProjectId)ESTestCase.randomProjectIdOrDefault()).build();
    }

    static {
        portGenerator = new AtomicInteger();
        loggedLeaks = new ArrayList<String>();
        WARN_SECURE_RANDOM_FIPS_NOT_DETERMINISTIC = new SetOnce();
        UPPER_ALPHA_CHARACTERS = LOWER_ALPHA_CHARACTERS.toUpperCase(Locale.ROOT);
        ALPHANUMERIC_CHARACTERS = LOWER_ALPHA_CHARACTERS + UPPER_ALPHA_CHARACTERS + DIGIT_CHARACTERS;
        Random random = ESTestCase.initTestSeed();
        TEST_WORKER_VM_ID = System.getProperty(TEST_WORKER_SYS_PROPERTY, DEFAULT_TEST_WORKER_ID);
        ESTestCase.setTestSysProps(random);
        LogConfigurator.loadLog4jPlugins();
        LogConfigurator.configureESLogging();
        MockLog.init();
        ArrayList<AbstractAppender> testAppenders = new ArrayList<AbstractAppender>(3);
        for (String leakLoggerName : Arrays.asList("io.netty.util.ResourceLeakDetector", LeakTracker.class.getName())) {
            Logger leakLogger = LogManager.getLogger((String)leakLoggerName);
            AbstractAppender leakAppender = new AbstractAppender(leakLoggerName, null, (Layout)PatternLayout.newBuilder().withPattern("%m").build()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void append(LogEvent event) {
                    String message = event.getMessage().getFormattedMessage();
                    if (Level.ERROR.equals((Object)event.getLevel()) && message.contains("LEAK:")) {
                        Collection<String> collection = loggedLeaks;
                        synchronized (collection) {
                            loggedLeaks.add(message);
                        }
                    }
                }
            };
            leakAppender.start();
            Loggers.addAppender((Logger)leakLogger, (Appender)leakAppender);
            testAppenders.add(leakAppender);
        }
        Logger promiseUncaughtLogger = LogManager.getLogger((String)"io.netty.util.concurrent.DefaultPromise");
        AbstractAppender uncaughtAppender = new AbstractAppender(promiseUncaughtLogger.getName(), null, (Layout)PatternLayout.newBuilder().withPattern("%m").build()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void append(LogEvent event) {
                if (Level.WARN.equals((Object)event.getLevel())) {
                    Collection<String> collection = loggedLeaks;
                    synchronized (collection) {
                        loggedLeaks.add(event.getMessage().getFormattedMessage());
                    }
                }
            }
        };
        uncaughtAppender.start();
        Loggers.addAppender((Logger)promiseUncaughtLogger, (Appender)uncaughtAppender);
        testAppenders.add(uncaughtAppender);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Appender testAppender : testAppenders) {
                testAppender.stop();
            }
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            Configurator.shutdown((LoggerContext)context);
        }));
        BootstrapForTesting.ensureInitialized();
        Set<String> unsupportedJodaTZIds = Set.of("ACT", "AET", "AGT", "ART", "AST", "BET", "BST", "CAT", "CNT", "CST", "CTT", "EAT", "ECT", "EST", "HST", "IET", "IST", "JST", "MIT", "MST", "NET", "NST", "PLT", "PNT", "PRT", "PST", "SST", "VST");
        Predicate<String> unsupportedZoneIdsPredicate = tz -> tz.startsWith("System/") || tz.equals("Eire");
        Predicate<String> unsupportedTZIdsPredicate = unsupportedJodaTZIds::contains;
        JAVA_TIMEZONE_IDS = Arrays.stream(TimeZone.getAvailableIDs()).filter(unsupportedTZIdsPredicate.negate()).filter(unsupportedZoneIdsPredicate.negate()).sorted().toList();
        JAVA_ZONE_IDS = ZoneId.getAvailableZoneIds().stream().filter(unsupportedZoneIdsPredicate.negate()).sorted().toList();
        TEST_ENTITLEMENTS = new TestEntitlementsRule();
        capturedLogLevel = null;
        breakers = Collections.synchronizedList(new ArrayList());
        statusData = new ArrayList<StatusData>();
        StatusLogger.getLogger().setLevel(Level.WARN);
        StatusLogger.getLogger().registerListener((StatusListener)new StatusConsoleListener(Level.WARN){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void log(StatusData data) {
                List<StatusData> list = statusData;
                synchronized (list) {
                    statusData.add(data);
                }
            }
        });
        LOG_4J_MSG_PREFIXES = List.of("JNDI lookup class is not available because this JRE does not support JNDI. JNDI string lookups will not be available, continuing configuration.", "JMX runtime input lookup class is not available because this JRE does not support JMX. JMX lookups will not be available, continuing configuration. ");
        checkIndexFailures = new CopyOnWriteArrayList<Exception>();
        UNSIGNED_LONG_MAX = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
        geohashGenerator = new GeohashGenerator();
        DEFAULT_NAMED_X_CONTENT_REGISTRY = new NamedXContentRegistry(CollectionUtils.concatLists((List)ClusterModule.getNamedXWriteables(), (Collection)IndicesModule.getNamedXContents()));
        assert (ESTestCase.getWorkerBasePort(646) + 30 - 1 <= Short.MAX_VALUE);
        TEST_REQUEST_TIMEOUT = TimeValue.THIRTY_SECONDS;
        SAFE_AWAIT_TIMEOUT = TimeValue.timeValueSeconds((long)10L);
    }

    public static final class DeprecationWarning {
        private final Level level;
        private final String message;

        public DeprecationWarning(Level level, String message) {
            this.level = level;
            this.message = message;
        }

        public int hashCode() {
            return Objects.hash(this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeprecationWarning that = (DeprecationWarning)o;
            return Objects.equals(this.message, that.message);
        }

        public String toString() {
            return Strings.format((String)"%s: %s", (Object[])new Object[]{this.level.name(), this.message});
        }
    }

    public static class GeohashGenerator
    extends CodepointSetGenerator {
        private static final char[] ASCII_SET = "0123456789bcdefghjkmnpqrstuvwxyz".toCharArray();

        public GeohashGenerator() {
            super(ASCII_SET);
        }
    }

    public static final class TestAnalysis {
        public final IndexAnalyzers indexAnalyzers;
        public final Map<String, TokenFilterFactory> tokenFilter;
        public final Map<String, TokenizerFactory> tokenizer;
        public final Map<String, CharFilterFactory> charFilter;

        public TestAnalysis(IndexAnalyzers indexAnalyzers, Map<String, TokenFilterFactory> tokenFilter, Map<String, TokenizerFactory> tokenizer, Map<String, CharFilterFactory> charFilter) {
            this.indexAnalyzers = indexAnalyzers;
            this.tokenFilter = tokenFilter;
            this.tokenizer = tokenizer;
            this.charFilter = charFilter;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface EntitledTestPackages {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface WithEntitlementsOnTestCode {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface WithoutEntitlements {
    }
}

