/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.junit.Assert;

public final class DiffableTestUtils {
    protected static final int NUMBER_OF_DIFF_TEST_RUNS = 20;

    private DiffableTestUtils() {
    }

    public static <T extends Diffable<T>> T assertDiffApplication(T remoteChanges, T localInstance, Diff<T> diffs, BiPredicate<? super T, ? super T> equalsPredicate) {
        Diffable localChanges = (Diffable)diffs.apply(localInstance);
        if (equalsPredicate == null) {
            Assert.assertEquals(remoteChanges, (Object)localChanges);
            Assert.assertEquals((long)remoteChanges.hashCode(), (long)localChanges.hashCode());
        } else if (!equalsPredicate.test(remoteChanges, localChanges)) {
            junit.framework.Assert.failNotEquals(null, remoteChanges, (Object)localChanges);
        }
        Assert.assertNotSame(remoteChanges, (Object)localChanges);
        return (T)localChanges;
    }

    public static <T extends Writeable> T copyInstance(T diffs, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        return DiffableTestUtils.copyInstance(diffs, namedWriteableRegistry, reader, null);
    }

    public static <T extends Writeable> T copyInstance(T diffs, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, @Nullable TransportVersion transportVersion) throws IOException {
        try (BytesStreamOutput output = new BytesStreamOutput();){
            Writeable writeable;
            if (transportVersion != null) {
                output.setTransportVersion(transportVersion);
            }
            diffs.writeTo((StreamOutput)output);
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(output.bytes().streamInput(), namedWriteableRegistry);){
                if (transportVersion != null) {
                    in.setTransportVersion(transportVersion);
                }
                writeable = (Writeable)reader.read((StreamInput)in);
            }
            return (T)writeable;
        }
    }

    public static <T extends Diffable<T>> void testDiffableSerialization(Supplier<T> testInstance, Function<T, T> modifier, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader) throws IOException {
        DiffableTestUtils.testDiffableSerialization(testInstance, modifier, namedWriteableRegistry, reader, diffReader, null, null);
    }

    public static <T extends Diffable<T>> void testDiffableSerialization(Supplier<T> testInstance, Function<T, T> modifier, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader, @Nullable TransportVersion transportVersion, @Nullable BiPredicate<? super T, ? super T> equals) throws IOException {
        Diffable remoteInstance = (Diffable)testInstance.get();
        Object localInstance = DiffableTestUtils.assertSerialization(remoteInstance, namedWriteableRegistry, reader);
        for (int runs = 0; runs < 20; ++runs) {
            Diffable remoteChanges = (Diffable)modifier.apply(remoteInstance);
            Diff remoteDiffs = remoteChanges.diff((Object)remoteInstance);
            Diff<T> localDiffs = DiffableTestUtils.copyInstance(remoteDiffs, namedWriteableRegistry, diffReader, transportVersion);
            localInstance = DiffableTestUtils.assertDiffApplication(remoteChanges, localInstance, localDiffs, equals);
            remoteInstance = remoteChanges;
        }
    }

    public static <T extends Writeable> T assertSerialization(T testInstance, NamedWriteableRegistry namedWriteableRegistry, Writeable.Reader<T> reader) throws IOException {
        T deserializedInstance = DiffableTestUtils.copyInstance(testInstance, namedWriteableRegistry, reader);
        Assert.assertEquals(testInstance, deserializedInstance);
        Assert.assertEquals((long)testInstance.hashCode(), (long)deserializedInstance.hashCode());
        Assert.assertNotSame(testInstance, deserializedInstance);
        return deserializedInstance;
    }
}

