/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.cluster.project.TestProjectResolvers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.MockScriptEngine;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public class TestTemplateService
extends ScriptService {
    private boolean compilationException;

    public static ScriptService instance() {
        return new TestTemplateService(false);
    }

    public static ScriptService instance(boolean compilationException) {
        return new TestTemplateService(compilationException);
    }

    private TestTemplateService(boolean compilationException) {
        super(Settings.EMPTY, Collections.singletonMap("mustache", new MockScriptEngine()), Collections.emptyMap(), () -> 1L, TestProjectResolvers.alwaysThrow());
        this.compilationException = compilationException;
    }

    public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
        if (this.compilationException) {
            throw new RuntimeException("could not compile script");
        }
        return (FactoryType)new MockTemplateScript.Factory(script.getIdOrCode());
    }

    public static class MockTemplateScript
    extends TemplateScript {
        private final String expected;

        MockTemplateScript(String expected) {
            super(Collections.emptyMap());
            this.expected = expected;
        }

        public String execute() {
            return this.expected;
        }

        public static class Factory
        implements TemplateScript.Factory {
            private final String expected;

            public Factory(String expected) {
                this.expected = expected;
            }

            public TemplateScript newInstance(Map<String, Object> params) {
                return new MockTemplateScript(this.expected);
            }
        }
    }
}

