/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.LuceneSyntheticSourceChangesSnapshot;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocValueFetcher;
import org.elasticsearch.index.mapper.DocumentLeafReader;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceTestCase;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.TestBlock;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.TimeSeriesRoutingHashFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.blockloader.docvalues.AbstractDoublesFromDocValuesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.AbstractIntsFromDocValuesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.AbstractLongsFromDocValuesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.termvectors.TermVectorsService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.lookup.LeafStoredFieldsLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.test.index.IndexVersionUtils;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;

public abstract class MapperTestCase
extends MapperServiceTestCase {
    protected abstract void minimalMapping(XContentBuilder var1) throws IOException;

    protected void minimalMapping(XContentBuilder b, IndexVersion indexVersion) throws IOException {
        this.minimalMapping(b);
    }

    protected void writeField(XContentBuilder builder) throws IOException {
        builder.field("field");
        builder.value(this.getSampleValueForDocument());
    }

    protected abstract Object getSampleValueForDocument();

    protected Object getSampleObjectForDocument() {
        throw new UnsupportedOperationException("Field doesn't support object parsing.");
    }

    protected Object getSampleValueForQuery() {
        return this.getSampleValueForDocument();
    }

    public final void testExistsQueryMinimalMapping() throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertExistsQuery(mapperService);
        this.assertParseMinimalWarnings();
    }

    public void testAggregatableConsistency() throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertAggregatableConsistency(mapperService.fieldType("field"));
        this.assertParseMinimalWarnings();
    }

    protected void assertAggregatableConsistency(MappedFieldType ft) {
        if (ft.isAggregatable()) {
            try {
                ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"index", (String)"aggregation_test"));
            }
            catch (Exception e) {
                MapperTestCase.fail((String)("Unexpected exception when fetching field data from aggregatable field type: " + e.getMessage()));
            }
        } else {
            MapperTestCase.expectThrows(IllegalArgumentException.class, () -> ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"index", (String)"aggregation_test")));
        }
    }

    protected abstract boolean supportsIgnoreMalformed();

    protected final ExampleMalformedValue exampleMalformedValue(String value) {
        return this.exampleMalformedValue((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(value)));
    }

    protected final ExampleMalformedValue exampleMalformedValue(CheckedConsumer<XContentBuilder, IOException> value) {
        return new ExampleMalformedValue((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping), value, (Matcher<String>)Matchers.equalTo((Object)"unset"));
    }

    protected List<ExampleMalformedValue> exampleMalformedValues() {
        MapperTestCase.assertFalse((String)"mappers that support ignore_malformed values most override exampleMalformedValues", (boolean)this.supportsIgnoreMalformed());
        return List.of();
    }

    public final void testIgnoreMalformedFalseByDefault() throws IOException {
        for (ExampleMalformedValue example : this.exampleMalformedValues()) {
            this.assertIgnoreMalformedFalse(example.mapping, example.value, example.exceptionMessageMatcher);
        }
    }

    public final void testIgnoreMalformedExplicitlyFalse() throws IOException {
        if (!this.supportsIgnoreMalformed()) {
            Exception e = (Exception)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("ignore_malformed", false);
            }))));
            MapperTestCase.assertThat(e.getMessage(), Matchers.containsString((String)"unknown parameter [ignore_malformed] on mapper [field]"));
            return;
        }
        for (ExampleMalformedValue example : this.exampleMalformedValues()) {
            this.assertIgnoreMalformedFalse((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                example.mapping.accept(b);
                b.field("ignore_malformed", false);
            }), example.value, example.exceptionMessageMatcher);
        }
    }

    private void assertIgnoreMalformedFalse(CheckedConsumer<XContentBuilder, IOException> mapping, CheckedConsumer<XContentBuilder, IOException> value, Matcher<String> exceptionMessageMatcher) throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping(mapping));
        FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
        MapperTestCase.assertFalse((boolean)mapper.ignoreMalformed());
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.field("field");
            value.accept(b);
        }));
        DocumentParsingException e = (DocumentParsingException)MapperTestCase.expectThrows(DocumentParsingException.class, (String)("didn't throw while parsing " + source.source().utf8ToString()), () -> mapperService.documentMapper().parse(source));
        MapperTestCase.assertThat("incorrect exception while parsing " + source.source().utf8ToString(), e.getCause().getMessage(), exceptionMessageMatcher);
    }

    public final void testIgnoreMalformedTrue() throws IOException {
        if (!this.supportsIgnoreMalformed()) {
            Exception e = (Exception)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("ignore_malformed", true);
            }))));
            MapperTestCase.assertThat(e.getMessage(), Matchers.containsString((String)"unknown parameter [ignore_malformed] on mapper [field]"));
            return;
        }
        for (ExampleMalformedValue example : this.exampleMalformedValues()) {
            XContentBuilder mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                example.mapping.accept(b);
                b.field("ignore_malformed", true);
            }));
            MapperService mapperService = this.createMapperService(mapping);
            FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            MapperTestCase.assertTrue((boolean)mapper.ignoreMalformed());
            ParsedDocument doc = mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.field("field");
                example.value.accept(b);
            })));
            List fields = doc.rootDoc().getFields("field");
            MapperTestCase.assertThat(fields, Matchers.empty());
            MapperTestCase.assertThat(TermVectorsService.getValues((List)doc.rootDoc().getFields("_ignored")), Matchers.contains((Object[])new String[]{"field"}));
        }
    }

    protected void assertExistsQuery(MapperService mapperService) throws IOException {
        LuceneDocument fields = mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField))).rootDoc();
        SearchExecutionContext searchExecutionContext = this.createSearchExecutionContext(mapperService);
        MappedFieldType fieldType = mapperService.fieldType("field");
        Query query = fieldType.existsQuery(searchExecutionContext);
        this.assertExistsQuery(fieldType, query, fields);
    }

    protected void assertExistsQuery(MappedFieldType fieldType, Query query, LuceneDocument fields) {
        if (fieldType.hasDocValues() || fieldType.getTextSearchInfo().hasNorms()) {
            MapperTestCase.assertThat(query, Matchers.instanceOf(FieldExistsQuery.class));
            FieldExistsQuery fieldExistsQuery = (FieldExistsQuery)query;
            MapperTestCase.assertEquals((Object)"field", (Object)fieldExistsQuery.getField());
            MapperTestCase.assertNoFieldNamesField(fields);
        } else {
            MapperTestCase.assertThat(query, Matchers.instanceOf(TermQuery.class));
            TermQuery termQuery = (TermQuery)query;
            MapperTestCase.assertEquals((Object)"_field_names", (Object)termQuery.getTerm().field());
            MapperTestCase.assertEquals((Object)"field", (Object)termQuery.getTerm().text());
            MapperTestCase.assertNoDocValuesField(fields, "field");
            IndexType indexType = fieldType.indexType();
            if (indexType.hasPoints() || indexType.hasTerms() || fieldType.isStored()) {
                MapperTestCase.assertNotNull((Object)fields.getField("_field_names"));
            } else {
                MapperTestCase.assertNoFieldNamesField(fields);
            }
        }
    }

    protected static void assertNoFieldNamesField(LuceneDocument fields) {
        MapperTestCase.assertNull((Object)fields.getField("_field_names"));
    }

    protected static void assertHasNorms(LuceneDocument doc, String field) {
        List fields = doc.getFields(field);
        for (IndexableField indexableField : fields) {
            IndexableFieldType indexableFieldType = indexableField.fieldType();
            if (indexableFieldType.indexOptions() == IndexOptions.NONE) continue;
            MapperTestCase.assertFalse((boolean)indexableFieldType.omitNorms());
            return;
        }
        MapperTestCase.fail((String)("field [" + field + "] should be indexed but it isn't"));
    }

    protected static void assertNoDocValuesField(LuceneDocument doc, String field) {
        List fields = doc.getFields(field);
        for (IndexableField indexableField : fields) {
            MapperTestCase.assertEquals((Object)DocValuesType.NONE, (Object)indexableField.fieldType().docValuesType());
        }
    }

    protected <T> void assertDimension(boolean isDimension, Function<T, Boolean> checker) throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", isDimension);
        })));
        MappedFieldType fieldType = mapperService.fieldType("field");
        MapperTestCase.assertThat(checker.apply(fieldType), Matchers.equalTo((Object)isDimension));
    }

    public void assertTimeSeriesIndexing() throws IOException {
        this.assertTimeSeriesIndexing(IndexVersions.TIME_SERIES_DIMENSIONS_USE_SKIPPERS, true, true);
        this.assertTimeSeriesIndexing(IndexVersions.TIME_SERIES_DIMENSIONS_USE_SKIPPERS, false, false);
        this.assertTimeSeriesIndexing(IndexVersions.TIME_SERIES_ALL_FIELDS_USE_SKIPPERS, true, true);
        this.assertTimeSeriesIndexing(IndexVersions.TIME_SERIES_ALL_FIELDS_USE_SKIPPERS, false, true);
        this.assertTimeSeriesIndexing(IndexVersions.TIME_SERIES_USE_SYNTHETIC_ID, true, false);
        this.assertTimeSeriesIndexing(IndexVersions.TIME_SERIES_USE_SYNTHETIC_ID, false, false);
    }

    public void assertTimeSeriesIndexing(IndexVersion indexVersion, boolean isDimension, boolean hasSkippers) throws IOException {
        Settings settings = Settings.builder().put(IndexSettings.USE_DOC_VALUES_SKIPPER.getKey(), true).put(IndexSettings.MODE.getKey(), IndexMode.TIME_SERIES.getName()).put("index.routing_path", "dim").build();
        MapperService mapperService = this.createMapperService(indexVersion, settings, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", isDimension);
        })));
        MapperTestCase.assumeTrue((String)"Skippers disabled by feature flag", (boolean)mapperService.getIndexSettings().useDocValuesSkipper());
        ParsedDocument doc = mapperService.documentMapper().parse(MapperTestCase.source(TimeSeriesRoutingHashFieldMapper.DUMMY_ENCODED_VALUE, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.writeField((XContentBuilder)b);
            b.field("@timestamp", "2025-11-14T12:00:00.000Z");
            b.field("dim", "foo");
        }), null));
        IndexableField field = doc.rootDoc().getField("field");
        if (hasSkippers) {
            MapperTestCase.assertSame((Object)DocValuesSkipIndexType.RANGE, (Object)field.fieldType().docValuesSkipIndexType());
            MapperTestCase.assertSame((Object)IndexOptions.NONE, (Object)field.fieldType().indexOptions());
            MapperTestCase.assertEquals((long)0L, (long)field.fieldType().pointDimensionCount());
            MapperTestCase.assertEquals((Object)IndexType.skippers(), (Object)mapperService.fieldType("field").indexType());
        } else {
            MapperTestCase.assertSame((Object)DocValuesSkipIndexType.NONE, (Object)field.fieldType().docValuesSkipIndexType());
            MapperTestCase.assertTrue((boolean)mapperService.fieldType("field").indexType().hasDenseIndex());
        }
    }

    protected <T> void assertMetricType(String metricType, Function<T, Enum<TimeSeriesParams.MetricType>> checker) throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_metric", metricType);
        })));
        MappedFieldType fieldType = mapperService.fieldType("field");
        MapperTestCase.assertThat(checker.apply(fieldType).toString(), Matchers.equalTo((Object)metricType));
    }

    public final void testEmptyName() {
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("");
            this.minimalMapping((XContentBuilder)b);
            b.endObject();
        }))));
        MapperTestCase.assertThat(e.getMessage(), Matchers.containsString((String)"field name cannot be an empty string"));
    }

    public final void testBlankName() {
        IndexVersion version = this.getVersion();
        MapperTestCase.assumeTrue((String)"blank field names are rejected from 8.6.0 onwards", (boolean)version.onOrAfter((VersionId)IndexVersions.V_8_6_0));
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(version, MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("  ");
            this.minimalMapping((XContentBuilder)b);
            b.endObject();
        }))));
        MapperTestCase.assertThat(e.getMessage(), Matchers.containsString((String)"field name cannot contain only whitespaces"));
    }

    public final void testMinimalSerializesToItself() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, ToXContent.EMPTY_PARAMS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, ToXContent.EMPTY_PARAMS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
        this.assertParseMinimalWarnings();
    }

    public final void testMinimalToMaximal() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, INCLUDE_DEFAULTS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, INCLUDE_DEFAULTS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)Strings.toString((XContentBuilder)orig), (Object)Strings.toString((XContentBuilder)parsedFromOrig));
        this.assertParseMaximalWarnings();
    }

    public final void testTotalFieldsCount() throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        MapperTestCase.assertEquals((long)1L, (long)mapperService.documentMapper().mapping().getRoot().getTotalFieldsCount());
        this.assertParseMinimalWarnings();
    }

    protected final void assertParseMinimalWarnings() {
        String[] warnings = this.getParseMinimalWarnings();
        if (warnings.length > 0) {
            this.assertWarnings(warnings);
        }
    }

    protected final void assertParseMaximalWarnings() {
        String[] warnings = this.getParseMaximalWarnings();
        if (warnings.length > 0) {
            this.assertWarnings(warnings);
        }
    }

    protected String[] getParseMinimalWarnings() {
        return Strings.EMPTY_ARRAY;
    }

    protected String[] getParseMinimalWarnings(IndexVersion indexVersion) {
        return this.getParseMinimalWarnings();
    }

    protected String[] getParseMaximalWarnings() {
        return Strings.EMPTY_ARRAY;
    }

    protected boolean supportsMeta() {
        return true;
    }

    protected boolean supportsCopyTo() {
        return true;
    }

    protected void metaMapping(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
    }

    public final void testMeta() throws IOException {
        MapperTestCase.assumeTrue((String)"Field doesn't support meta", (boolean)this.supportsMeta());
        XContentBuilder mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("foo", "bar"));
        }));
        MapperService mapperService = this.createMapperService(mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::metaMapping));
        MapperTestCase.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
        mapping = MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("baz", "quux"));
        }));
        MapperTestCase.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (XContentType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (XContentType)mapping.contentType()).v2());
    }

    public void testBoostNotAllowed() throws IOException {
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(this.boostNotAllowedIndexVersion(), MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("boost", 2.0);
        }))));
        MapperTestCase.assertThat(e.getMessage(), Matchers.anyOf((Matcher)Matchers.containsString((String)"Unknown parameter [boost]"), (Matcher)Matchers.containsString((String)"[boost : 2.0]")));
        this.assertParseMinimalWarnings();
    }

    protected IndexVersion boostNotAllowedIndexVersion() {
        return IndexVersions.V_8_0_0;
    }

    protected final List<?> fetchFromDocValues(MapperService mapperService, MappedFieldType ft, DocValueFormat format, Object sourceValue) throws IOException {
        SetOnce result = new SetOnce();
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field(ft.name(), sourceValue)))).rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)iw -> {
            SearchLookup lookup = new SearchLookup(arg_0 -> ((MapperService)mapperService).fieldType(arg_0), this.fieldDataLookup(mapperService), SourceProvider.fromLookup((MappingLookup)mapperService.mappingLookup(), null, (SourceFieldMetrics)mapperService.getMapperMetrics().sourceFieldMetrics()));
            DocValueFetcher valueFetcher = new DocValueFetcher(format, lookup.getForField(ft, MappedFieldType.FielddataOperation.SEARCH));
            IndexSearcher searcher = MapperTestCase.newSearcher((IndexReader)iw);
            LeafReaderContext context = (LeafReaderContext)searcher.getIndexReader().leaves().get(0);
            Source source = lookup.getSource(context, 0);
            valueFetcher.setNextReader(context);
            result.set((Object)valueFetcher.fetchValues(source, 0, new ArrayList()));
        }));
        return (List)result.get();
    }

    protected static void assertScriptDocValues(MapperService mapperService, Object sourceValue, Matcher<List<?>> dvMatcher) throws IOException {
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)mapperService.documentMapper().parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("field", sourceValue)))).rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)iw -> {
            IndexSearcher searcher = MapperTestCase.newSearcher((IndexReader)iw);
            MappedFieldType ft = mapperService.fieldType("field");
            SourceProvider sourceProvider = mapperService.mappingLookup().isSourceSynthetic() ? (ctx, doc) -> {
                throw new IllegalArgumentException("Can't load source in scripts in synthetic mode");
            } : SourceProvider.fromLookup((MappingLookup)mapperService.mappingLookup(), null, (SourceFieldMetrics)mapperService.getMapperMetrics().sourceFieldMetrics());
            SearchLookup searchLookup = new SearchLookup(null, null, sourceProvider);
            IndexFieldData sfd = ft.fielddataBuilder(new FieldDataContext("", mapperService.getIndexSettings(), () -> searchLookup, Set::of, MappedFieldType.FielddataOperation.SCRIPT)).build(null, null);
            LeafFieldData lfd = sfd.load(MapperTestCase.getOnlyLeafReader((IndexReader)searcher.getIndexReader()).getContext());
            DocValuesScriptFieldFactory sff = lfd.getScriptFieldFactory("field");
            sff.setNextDocId(0);
            MapperTestCase.assertThat(sff.toScriptDocValues(), dvMatcher);
        }));
    }

    protected abstract void registerParameters(ParameterChecker var1) throws IOException;

    public void testUpdates() throws IOException {
        MapperService mapperService;
        ParameterChecker checker = new ParameterChecker();
        this.registerParameters(checker);
        if (this.supportsIgnoreMalformed()) {
            checker.registerUpdateCheck((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("ignore_malformed", true)), m -> MapperTestCase.assertTrue((boolean)m.ignoreMalformed()));
        } else {
            MapperService mapperService2 = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
            Exception e = (Exception)MapperTestCase.expectThrows(MapperParsingException.class, (String)"No conflict when setting parameter [ignore_malformed]", () -> MapperTestCase.merge(mapperService2, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                this.minimalMapping((XContentBuilder)b);
                b.field("ignore_malformed", true);
            }))));
            MapperTestCase.assertThat(e.getMessage(), Matchers.containsString((String)"unknown parameter [ignore_malformed] on mapper [field]"));
        }
        for (UpdateCheck updateCheck : checker.updateChecks) {
            mapperService = this.createMapperService(updateCheck.init);
            MapperTestCase.merge(mapperService, updateCheck.update);
            FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
            MapperTestCase.merge(mapperService, updateCheck.update);
            mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
        }
        for (String param : checker.conflictChecks.keySet()) {
            mapperService = this.createMapperService(checker.conflictChecks.get((Object)param).init);
            MapperTestCase.merge(mapperService, checker.conflictChecks.get((Object)param).init);
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, (String)("No conflict when updating parameter [" + param + "]"), () -> MapperTestCase.merge(mapperService, checker.conflictChecks.get((Object)param).update));
            MapperTestCase.assertThat(e.getMessage(), Matchers.anyOf((Matcher)Matchers.containsString((String)("Cannot update parameter [" + param + "]")), (Matcher)Matchers.containsString((String)("different [" + param + "]")), (Matcher)Matchers.containsString((String)("[" + param + "] cannot be "))));
        }
        this.assertParseMaximalWarnings();
    }

    public final void testTextSearchInfoConsistency() throws IOException {
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        MappedFieldType fieldType = mapperService.fieldType("field");
        if (fieldType.getTextSearchInfo() == TextSearchInfo.NONE) {
            MapperTestCase.expectThrows(IllegalArgumentException.class, () -> fieldType.termQuery(null, null));
        } else {
            SearchExecutionContext searchExecutionContext = this.createSearchExecutionContext(mapperService);
            MapperTestCase.assertNotNull((Object)fieldType.termQuery(this.getSampleValueForQuery(), searchExecutionContext));
        }
        this.assertSearchable(fieldType);
        this.assertParseMinimalWarnings();
    }

    protected void assertSearchable(MappedFieldType fieldType) {
        MapperTestCase.assertEquals((Object)fieldType.isSearchable(), (Object)(fieldType.getTextSearchInfo() != TextSearchInfo.NONE ? 1 : 0));
    }

    public final void testFetch() throws IOException {
        MapperService mapperService = this.randomFetchTestMapper();
        try {
            MappedFieldType ft = mapperService.fieldType("field");
            this.assertFetch(mapperService, "field", this.generateRandomInputValue(ft), this.randomFetchTestFormat());
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testFetchMany() throws IOException {
        MapperService mapperService = this.randomFetchTestMapper();
        try {
            MappedFieldType ft = mapperService.fieldType("field");
            int count = MapperTestCase.between(2, 10);
            ArrayList<Object> values = new ArrayList<Object>(count);
            while (values.size() < count) {
                values.add(this.generateRandomInputValue(ft));
            }
            this.assertFetchMany(mapperService, "field", values, this.randomFetchTestFormat(), count);
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    protected final MapperService randomFetchTestMapper() throws IOException {
        return this.createMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            this.randomFetchTestFieldConfig((XContentBuilder)b);
            b.endObject();
        })));
    }

    protected void randomFetchTestFieldConfig(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
    }

    protected String randomFetchTestFormat() {
        return null;
    }

    protected void registerDimensionChecks(ParameterChecker checker) throws IOException {
        checker.registerConflictCheck("time_series_dimension", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("time_series_dimension", true)));
        checker.registerConflictCheck("time_series_dimension", (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("time_series_dimension", false)));
        checker.registerConflictCheck("time_series_dimension", MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", false);
        })), MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true);
        })));
        checker.registerConflictCheck("time_series_dimension", MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", true);
        })), MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("time_series_dimension", false);
        })));
    }

    protected abstract Object generateRandomInputValue(MappedFieldType var1);

    protected void assertFetchMany(MapperService mapperService, String field, Object value, String format, int count) throws IOException {
        this.assertFetch(mapperService, field, value, format);
    }

    protected void assertFetch(MapperService mapperService, String field, Object value, String format) throws IOException {
        MappedFieldType ft = mapperService.fieldType(field);
        MappedFieldType.FielddataOperation fdt = MappedFieldType.FielddataOperation.SEARCH;
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field(ft.name(), value)));
        DocValueFetcher docValueFetcher = new DocValueFetcher(ft.docValueFormat(format, null), ft.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"index", (String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()));
        SearchExecutionContext searchExecutionContext = (SearchExecutionContext)Mockito.mock(SearchExecutionContext.class);
        Mockito.when((Object)searchExecutionContext.getIndexSettings()).thenReturn((Object)mapperService.getIndexSettings());
        Mockito.when((Object)searchExecutionContext.isSourceEnabled()).thenReturn((Object)true);
        Mockito.when((Object)searchExecutionContext.sourcePath(field)).thenReturn(Set.of(field));
        Mockito.when((Object)searchExecutionContext.getForField(ft, fdt)).thenAnswer(inv -> this.fieldDataLookup(mapperService).apply((Object)ft, () -> {
            throw new UnsupportedOperationException();
        }, (Object)fdt));
        ValueFetcher nativeFetcher = ft.valueFetcher(searchExecutionContext, format);
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocuments((Iterable)doc.docs())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)arg_0 -> this.lambda$assertFetch$49(mapperService, (ValueFetcher)docValueFetcher, nativeFetcher, value, arg_0)));
    }

    protected boolean dedupAfterFetch() {
        return false;
    }

    protected boolean supportsSearchLookup() {
        return true;
    }

    public final void testIndexTimeFieldData() throws IOException {
        MapperTestCase.assumeTrue((String)"Field type does not support access via search lookup", (boolean)this.supportsSearchLookup());
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertParseMinimalWarnings();
        MappedFieldType fieldType = mapperService.fieldType("field");
        if (!fieldType.isAggregatable()) {
            return;
        }
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField));
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)ir -> {
            LeafReaderContext ctx = (LeafReaderContext)ir.leaves().get(0);
            DocValuesScriptFieldFactory docValuesFieldSource = fieldType.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"index", (String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()).load(ctx).getScriptFieldFactory("test");
            docValuesFieldSource.setNextDocId(0);
            DocumentLeafReader reader = new DocumentLeafReader(doc.rootDoc(), Collections.emptyMap());
            DocValuesScriptFieldFactory indexData = fieldType.fielddataBuilder(FieldDataContext.noRuntimeFields((String)"index", (String)"test")).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService()).load(reader.getContext()).getScriptFieldFactory("test");
            indexData.setNextDocId(0);
            MapperTestCase.assertThat(docValuesFieldSource.toScriptDocValues(), Matchers.equalTo((Object)indexData.toScriptDocValues()));
        }));
    }

    protected boolean supportsStoredFields() {
        return true;
    }

    protected void minimalStoreMapping(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
        b.field("store", true);
    }

    public final void testIndexTimeStoredFieldsAccess() throws IOException {
        MapperTestCase.assumeTrue((String)"Field type does not support stored fields", (boolean)this.supportsStoredFields());
        MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalStoreMapping)));
        this.assertParseMinimalWarnings();
        MappedFieldType fieldType = mapperService.fieldType("field");
        SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField));
        ParsedDocument doc = mapperService.documentMapper().parse(source);
        SearchLookup lookup = new SearchLookup(f -> fieldType, (f, s, t) -> {
            throw new UnsupportedOperationException();
        }, (ctx, docid) -> Source.fromBytes((BytesReference)doc.source()));
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)doc.rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)ir -> {
            LeafReaderContext ctx = (LeafReaderContext)ir.leaves().get(0);
            LeafStoredFieldsLookup storedFields = lookup.getLeafSearchLookup(ctx).fields();
            storedFields.setDocument(0);
            DocumentLeafReader reader = new DocumentLeafReader(doc.rootDoc(), Collections.emptyMap());
            LeafStoredFieldsLookup indexStoredFields = lookup.getLeafSearchLookup(reader.getContext()).fields();
            indexStoredFields.setDocument(0);
            MapperTestCase.assertThat(storedFields.get((Object)"field").getValues(), Matchers.equalTo((Object)indexStoredFields.get((Object)"field").getValues()));
        }));
    }

    public final void testNullInput() throws Exception {
        DocumentMapper mapper = this.createDocumentMapper(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        if (this.allowsNullValues()) {
            ParsedDocument doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.nullField("field"))));
            MapperTestCase.assertThat(((LuceneDocument)doc.docs().get(0)).getFields("field"), Matchers.empty());
            MapperTestCase.assertThat(((LuceneDocument)doc.docs().get(0)).getFields("_field_names"), Matchers.empty());
        } else {
            MapperTestCase.expectThrows(DocumentParsingException.class, () -> mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.nullField("field")))));
        }
        this.assertWarnings(this.getParseMinimalWarnings());
    }

    protected boolean allowsNullValues() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void testMinimalIsInvalidInRoutingPath() throws IOException {
        MapperService mapper = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        try {
            IndexSettings settings = MapperTestCase.createIndexSettings(IndexVersion.current(), Settings.builder().put(IndexSettings.MODE.getKey(), "time_series").put(IndexMetadata.INDEX_ROUTING_PATH.getKey(), "field").put(IndexSettings.TIME_SERIES_START_TIME.getKey(), "2021-04-28T00:00:00Z").put(IndexSettings.TIME_SERIES_END_TIME.getKey(), "2021-04-29T00:00:00Z").build());
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, () -> mapper.documentMapper().validate(settings, false));
            MapperTestCase.assertThat(e.getMessage(), Matchers.equalTo((Object)this.minimalIsInvalidRoutingPathErrorMessage(mapper.mappingLookup().getMapper("field"))));
        }
        finally {
            this.assertParseMinimalWarnings();
        }
    }

    protected String minimalIsInvalidRoutingPathErrorMessage(Mapper mapper) {
        FieldMapper fieldMapper;
        if (mapper instanceof FieldMapper && !(fieldMapper = (FieldMapper)mapper).fieldType().isDimension()) {
            return "All fields that match routing_path must be configured with [time_series_dimension: true] or flattened fields with a list of dimensions in [time_series_dimensions] and without the [script] parameter. [" + mapper.fullPath() + "] was not a dimension.";
        }
        return "All fields that match routing_path must be configured with [time_series_dimension: true] or flattened fields with a list of dimensions in [time_series_dimensions] and without the [script] parameter. [" + mapper.fullPath() + "] was [" + mapper.typeName() + "].";
    }

    protected abstract SyntheticSourceSupport syntheticSourceSupport(boolean var1);

    protected SyntheticSourceSupport syntheticSourceSupport(boolean ignoreMalformed, boolean columnReader) {
        return this.syntheticSourceSupport(ignoreMalformed);
    }

    public final void testSyntheticSource() throws IOException {
        this.assertSyntheticSource(this.syntheticSourceSupport(this.shouldUseIgnoreMalformed()).example(5));
    }

    public final void testSyntheticSourceWithTranslogSnapshot() throws IOException {
        this.assertSyntheticSourceWithTranslogSnapshot(this.syntheticSourceSupport(this.shouldUseIgnoreMalformed()), true);
        this.assertSyntheticSourceWithTranslogSnapshot(this.syntheticSourceSupport(this.shouldUseIgnoreMalformed()), false);
    }

    public void testSyntheticSourceIgnoreMalformedExamples() throws IOException {
        MapperTestCase.assumeTrue((String)"type doesn't support ignore_malformed", (boolean)this.supportsIgnoreMalformed());
        this.syntheticSourceSupport(true);
        for (ExampleMalformedValue v : this.exampleMalformedValues()) {
            CheckedConsumer mapping = b -> {
                v.mapping.accept(b);
                b.field("ignore_malformed", true);
            };
            this.assertSyntheticSource(new SyntheticSourceExample(v.value, v.value, (CheckedConsumer<XContentBuilder, IOException>)mapping));
        }
    }

    private void assertSyntheticSource(SyntheticSourceExample example) throws IOException {
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            example.mapping().accept(b);
            b.endObject();
        }))).documentMapper();
        MapperTestCase.assertThat(this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput)), Matchers.equalTo((Object)example.expected()));
        MapperTestCase.assertThat(this.syntheticSource(mapper, new SourceFilter(new String[]{"field"}, null), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput)), Matchers.equalTo((Object)example.expected()));
        MapperTestCase.assertThat(this.syntheticSource(mapper, new SourceFilter(null, new String[]{"field"}), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput)), Matchers.equalTo((Object)"{}"));
    }

    private void assertSyntheticSourceWithTranslogSnapshot(SyntheticSourceSupport support, boolean doIndexSort) throws IOException {
        SyntheticSourceExample firstExample = support.example(1);
        int maxDocs = MapperTestCase.randomIntBetween(20, 50);
        Settings settings = Settings.builder().put(IndexSettings.INDEX_MAPPER_SOURCE_MODE_SETTING.getKey(), (Enum)SourceFieldMapper.Mode.SYNTHETIC).put(IndexSettings.RECOVERY_USE_SYNTHETIC_SOURCE_SETTING.getKey(), true).build();
        MapperService mapperService = this.createMapperService(this.getVersion(), settings, () -> true, MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            firstExample.mapping().accept(b);
            b.endObject();
        })));
        DocumentMapper docMapper = mapperService.documentMapper();
        try (BaseDirectoryWrapper directory = MapperTestCase.newDirectory();){
            ArrayList<SyntheticSourceExample> examples = new ArrayList<SyntheticSourceExample>();
            IndexWriterConfig config = MapperTestCase.newIndexWriterConfig((Random)MapperTestCase.random(), (Analyzer)new StandardAnalyzer());
            config.setIndexSort(new Sort(new SortField[]{new SortField("sort", SortField.Type.LONG)}));
            try (RandomIndexWriter iw = new RandomIndexWriter(MapperTestCase.random(), (Directory)directory, config);){
                for (int seqNo = 0; seqNo < maxDocs; ++seqNo) {
                    SyntheticSourceExample example = support.example(MapperTestCase.randomIntBetween(1, 5));
                    examples.add(example);
                    ParsedDocument doc = docMapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput)));
                    MapperTestCase.assertNull((Object)doc.dynamicMappingsUpdate());
                    doc.updateSeqID((long)seqNo, 1L);
                    doc.version().setLongValue(0L);
                    if (doIndexSort) {
                        doc.rootDoc().add((IndexableField)new NumericDocValuesField("sort", MapperTestCase.randomLong()));
                    }
                    iw.addDocuments((Iterable)doc.docs());
                    if (!MapperTestCase.frequently()) continue;
                    iw.flush();
                }
            }
            try (DirectoryReader indexReader = MapperTestCase.wrapInMockESDirectoryReader(DirectoryReader.open((Directory)directory));){
                int start = MapperTestCase.randomBoolean() ? 0 : MapperTestCase.randomIntBetween(1, maxDocs - 10);
                LuceneSyntheticSourceChangesSnapshot snapshot = new LuceneSyntheticSourceChangesSnapshot(mapperService, new Engine.Searcher("recovery", (IndexReader)indexReader, (Similarity)new BM25Similarity(), null, (QueryCachingPolicy)new UsageTrackingQueryCachingPolicy(), () -> {}), MapperTestCase.randomIntBetween(1, maxDocs), MapperTestCase.randomLongBetween(0L, ByteSizeValue.ofBytes((long)Integer.MAX_VALUE).getBytes()), (long)start, (long)maxDocs, true, MapperTestCase.randomBoolean(), IndexVersion.current());
                for (int i = start; i < maxDocs; ++i) {
                    SyntheticSourceExample example = (SyntheticSourceExample)examples.get(i);
                    Translog.Operation op = snapshot.next();
                    if (!(op instanceof Translog.Index)) continue;
                    Translog.Index opIndex = (Translog.Index)op;
                    MapperTestCase.assertThat(opIndex.source().utf8ToString(), Matchers.equalTo((Object)example.expected()));
                }
            }
        }
    }

    protected boolean supportsEmptyInputArray() {
        return true;
    }

    public final void testSupportsParsingObject() throws IOException {
        DocumentMapper mapper = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper();
        FieldMapper fieldMapper = (FieldMapper)mapper.mappers().getMapper("field");
        if (fieldMapper.supportsParsingObject()) {
            Object sampleValueForDocument = this.getSampleObjectForDocument();
            MapperTestCase.assertThat(sampleValueForDocument, Matchers.instanceOf(Map.class));
            SourceToParse source = MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)builder -> {
                builder.field("field");
                builder.value(sampleValueForDocument);
            }));
            ParsedDocument doc = mapper.parse(source);
            MapperTestCase.assertNotNull((Object)doc);
        } else {
            MapperTestCase.expectThrows(Exception.class, () -> mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.startObject("field");
                b.endObject();
            }))));
        }
        this.assertParseMinimalWarnings();
    }

    public final void testSyntheticSourceMany() throws IOException {
        boolean ignoreMalformed = this.shouldUseIgnoreMalformed();
        int maxValues = MapperTestCase.randomBoolean() ? 1 : 5;
        SyntheticSourceSupport support = this.syntheticSourceSupport(ignoreMalformed);
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            support.example(maxValues).mapping().accept(b);
            b.endObject();
        }))).documentMapper();
        int count = MapperTestCase.between(2, 1000);
        String[] expected = new String[count];
        try (BaseDirectoryWrapper directory = MapperTestCase.newDirectory();){
            int i;
            try (RandomIndexWriter iw = new RandomIndexWriter(MapperTestCase.random(), (Directory)directory, LuceneTestCase.newIndexWriterConfig((Random)MapperTestCase.random(), (Analyzer)new MockAnalyzer(MapperTestCase.random())).setMergePolicy(NoMergePolicy.INSTANCE));){
                for (i = 0; i < count; ++i) {
                    if (MapperTestCase.rarely() && this.supportsEmptyInputArray()) {
                        expected[i] = support.preservesExactSource() ? "{\"field\":[]}" : "{}";
                        iw.addDocument((Iterable)mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startArray("field").endArray()))).rootDoc());
                        continue;
                    }
                    SyntheticSourceExample example = support.example(maxValues);
                    expected[i] = example.expected();
                    iw.addDocument((Iterable)mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput))).rootDoc());
                }
            }
            try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
                i = 0;
                SourceLoader loader = mapper.mappers().newSourceLoader(null, SourceFieldMetrics.NOOP);
                StoredFieldLoader storedFieldLoader = loader.requiredStoredFields().isEmpty() ? StoredFieldLoader.empty() : StoredFieldLoader.create((boolean)false, (Set)loader.requiredStoredFields());
                for (LeafReaderContext leaf : reader.leaves()) {
                    int[] docIds = IntStream.range(0, leaf.reader().maxDoc()).toArray();
                    SourceLoader.Leaf sourceLoaderLeaf = loader.leaf(leaf.reader(), docIds);
                    LeafStoredFieldLoader storedLeaf = storedFieldLoader.getLoader(leaf, docIds);
                    for (int docId : docIds) {
                        storedLeaf.advanceTo(docId);
                        String source = sourceLoaderLeaf.source(storedLeaf, docId).internalSourceRef().utf8ToString();
                        MapperTestCase.assertThat("doc " + docId, source, Matchers.equalTo((Object)expected[i++]));
                    }
                }
            }
        }
    }

    public final void testNoSyntheticSourceForScript() throws IOException {
        this.ingestScriptSupport();
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            this.minimalMapping((XContentBuilder)b);
            b.field("script", MapperTestCase.randomBoolean() ? "empty" : "non-empty");
            b.endObject();
        }))).documentMapper();
        MapperTestCase.assertThat(this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})), Matchers.equalTo((Object)"{}"));
    }

    public final void testSyntheticSourceInObject() throws IOException {
        boolean ignoreMalformed = this.shouldUseIgnoreMalformed();
        SyntheticSourceExample syntheticSourceExample = this.syntheticSourceSupport(ignoreMalformed).example(5);
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj").startObject("properties").startObject("field");
            syntheticSourceExample.mapping().accept(b);
            b.endObject().endObject().endObject();
        }))).documentMapper();
        MapperTestCase.assertThat(this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), Matchers.equalTo((Object)("{\"obj\":" + syntheticSourceExample.expected() + "}")));
        MapperTestCase.assertThat(this.syntheticSource(mapper, new SourceFilter(new String[]{"obj.field"}, null), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), Matchers.equalTo((Object)("{\"obj\":" + syntheticSourceExample.expected() + "}")));
        MapperTestCase.assertThat(this.syntheticSource(mapper, new SourceFilter(null, new String[]{"obj.field"}), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), Matchers.equalTo((Object)"{}"));
    }

    public final void testSyntheticEmptyList() throws IOException {
        MapperTestCase.assumeTrue((String)"Field does not support [] as input", (boolean)this.supportsEmptyInputArray());
        boolean ignoreMalformed = this.shouldUseIgnoreMalformed();
        SyntheticSourceSupport support = this.syntheticSourceSupport(ignoreMalformed);
        SyntheticSourceExample syntheticSourceExample = support.example(5);
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            syntheticSourceExample.mapping().accept(b);
            b.endObject();
        }))).documentMapper();
        String expected = support.preservesExactSource() ? "{\"field\":[]}" : "{}";
        MapperTestCase.assertThat(this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startArray("field").endArray())), Matchers.equalTo((Object)expected));
    }

    protected boolean shouldUseIgnoreMalformed() {
        return this.supportsIgnoreMalformed() && MapperTestCase.randomDouble() <= 0.05;
    }

    public final void testSyntheticEmptyListNoDocValuesLoader() throws IOException {
        MapperTestCase.assumeTrue((String)"Field does not support [] as input", (boolean)this.supportsEmptyInputArray());
        this.assertNoDocValueLoader((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.startArray("field").endArray()));
    }

    public final void testEmptyDocumentNoDocValueLoader() throws IOException {
        MapperTestCase.assumeFalse((String)"Field will add values even if no fields are supplied", (boolean)this.addsValueWhenNotSupplied());
        this.assertNoDocValueLoader((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {}));
    }

    protected boolean addsValueWhenNotSupplied() {
        return false;
    }

    private void assertNoDocValueLoader(CheckedConsumer<XContentBuilder, IOException> doc) throws IOException {
        boolean ignoreMalformed = this.supportsIgnoreMalformed() ? MapperTestCase.rarely() : false;
        SyntheticSourceExample syntheticSourceExample = this.syntheticSourceSupport(ignoreMalformed).example(5);
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            syntheticSourceExample.mapping().accept(b);
            b.endObject();
        }))).documentMapper();
        try (BaseDirectoryWrapper directory = MapperTestCase.newDirectory();){
            RandomIndexWriter iw = new RandomIndexWriter(MapperTestCase.random(), (Directory)directory);
            iw.addDocument((Iterable)mapper.parse(MapperTestCase.source(doc)).rootDoc());
            iw.close();
            try (DirectoryReader reader = DirectoryReader.open((Directory)directory);){
                LeafReader leafReader = MapperTestCase.getOnlyLeafReader((IndexReader)reader);
                SourceLoader.SyntheticFieldLoader fieldLoader = ((FieldMapper)mapper.mapping().getRoot().getMapper("field")).syntheticFieldLoader();
                MapperTestCase.assertThat(fieldLoader.docValuesLoader(leafReader, new int[]{0}), Matchers.nullValue());
            }
        }
    }

    public final void testSyntheticSourceInvalid() throws IOException {
        boolean ignoreMalformed = this.shouldUseIgnoreMalformed();
        ArrayList<SyntheticSourceInvalidExample> examples = new ArrayList<SyntheticSourceInvalidExample>(this.syntheticSourceSupport(ignoreMalformed).invalidExample());
        for (SyntheticSourceInvalidExample example : examples) {
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, (String)example.toString(), () -> this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.startObject("field");
                example.mapping.accept(b);
                b.endObject();
            }))));
            MapperTestCase.assertThat(e.getMessage(), example.error);
        }
    }

    public final void testSyntheticSourceInNestedObject() throws IOException {
        boolean ignoreMalformed = this.shouldUseIgnoreMalformed();
        SyntheticSourceExample syntheticSourceExample = this.syntheticSourceSupport(ignoreMalformed).example(5);
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj").field("type", "nested").startObject("properties").startObject("field");
            syntheticSourceExample.mapping().accept(b);
            b.endObject().endObject().endObject();
        }))).documentMapper();
        MapperTestCase.assertThat(this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), Matchers.equalTo((Object)("{\"obj\":" + syntheticSourceExample.expected() + "}")));
        MapperTestCase.assertThat(this.syntheticSource(mapper, new SourceFilter(new String[]{"obj.field"}, null), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), Matchers.equalTo((Object)("{\"obj\":" + syntheticSourceExample.expected() + "}")));
        MapperTestCase.assertThat(this.syntheticSource(mapper, new SourceFilter(null, new String[]{"obj.field"}), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), Matchers.equalTo((Object)"{\"obj\":{}}"));
        MapperTestCase.assertThat(this.syntheticSource(mapper, new SourceFilter(null, new String[]{"obj"}), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("obj");
            syntheticSourceExample.buildInput((XContentBuilder)b);
            b.endObject();
        })), Matchers.equalTo((Object)"{}"));
    }

    protected SyntheticSourceSupport syntheticSourceSupportForKeepTests(boolean ignoreMalformed, Mapper.SourceKeepMode keepMode) {
        return this.syntheticSourceSupport(ignoreMalformed);
    }

    public void testSyntheticSourceKeepNone() throws IOException {
        SyntheticSourceExample example = this.syntheticSourceSupportForKeepTests(this.shouldUseIgnoreMalformed(), Mapper.SourceKeepMode.NONE).example(1);
        DocumentMapper mapper = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            b.field("synthetic_source_keep", "none");
            example.mapping().accept(b);
            b.endObject();
        }))).documentMapper();
        MapperTestCase.assertThat(this.syntheticSource(mapper, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput)), Matchers.equalTo((Object)example.expected()));
    }

    public void testSyntheticSourceKeepAll() throws IOException {
        SyntheticSourceExample example = this.syntheticSourceSupportForKeepTests(this.shouldUseIgnoreMalformed(), Mapper.SourceKeepMode.ALL).example(1);
        DocumentMapper mapperAll = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            b.field("synthetic_source_keep", "all");
            example.mapping().accept(b);
            b.endObject();
        }))).documentMapper();
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        example.buildInput(builder);
        builder.endObject();
        String expected = Strings.toString((XContentBuilder)builder);
        MapperTestCase.assertThat(this.syntheticSource(mapperAll, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)example::buildInput)), Matchers.equalTo((Object)expected));
    }

    public void testSyntheticSourceKeepArrays() throws IOException {
        SyntheticSourceExample example = this.syntheticSourceSupportForKeepTests(this.shouldUseIgnoreMalformed(), Mapper.SourceKeepMode.ARRAYS).example(1);
        DocumentMapper mapperAll = this.createSytheticSourceMapperService(MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            b.field("synthetic_source_keep", this.randomSyntheticSourceKeep());
            example.mapping().accept(b);
            b.endObject();
        }))).documentMapper();
        int elementCount = MapperTestCase.randomIntBetween(2, 5);
        CheckedConsumer buildInput = builder -> example.buildInputArray((XContentBuilder)builder, elementCount);
        XContentBuilder builder2 = XContentFactory.jsonBuilder();
        builder2.startObject();
        buildInput.accept((Object)builder2);
        builder2.endObject();
        String expected = Strings.toString((XContentBuilder)builder2);
        String actual = this.syntheticSource(mapperAll, (CheckedConsumer<XContentBuilder, IOException>)buildInput);
        MapperTestCase.assertThat(actual, Matchers.equalTo((Object)expected));
    }

    protected boolean supportsBulkLongBlockReading() {
        return false;
    }

    protected boolean supportsBulkIntBlockReading() {
        return false;
    }

    protected boolean supportsBulkDoubleBlockReading() {
        return false;
    }

    protected Object[] getThreeSampleValues() {
        return new Object[]{1L, 2L, 3L};
    }

    protected Object[] getThreeEncodedSampleValues() {
        return this.getThreeSampleValues();
    }

    public void testSingletonIntBulkBlockReading() throws IOException {
        MapperTestCase.assumeTrue((String)"field type supports bulk singleton int reading", (boolean)this.supportsBulkIntBlockReading());
        this.testSingletonBulkBlockReading(columnAtATimeReader -> (AbstractIntsFromDocValuesBlockLoader.Singleton)columnAtATimeReader);
    }

    public void testSingletonLongBulkBlockReading() throws IOException {
        MapperTestCase.assumeTrue((String)"field type supports bulk singleton long reading", (boolean)this.supportsBulkLongBlockReading());
        this.testSingletonBulkBlockReading(columnAtATimeReader -> (AbstractLongsFromDocValuesBlockLoader.Singleton)columnAtATimeReader);
    }

    public void testSingletonDoubleBulkBlockReading() throws IOException {
        MapperTestCase.assumeTrue((String)"field type supports bulk singleton double reading", (boolean)this.supportsBulkDoubleBlockReading());
        this.testSingletonBulkBlockReading(columnAtATimeReader -> (AbstractDoublesFromDocValuesBlockLoader.Singleton)columnAtATimeReader);
    }

    private void testSingletonBulkBlockReading(Function<BlockLoader.ColumnAtATimeReader, BlockDocValuesReader> readerCast) throws IOException {
        MapperTestCase.assumeTrue((String)"field type supports bulk singleton long reading", (boolean)this.supportsBulkLongBlockReading());
        Settings settings = MapperTestCase.indexSettings(IndexVersion.current(), 1, 1).put("index.mode", "logsdb").build();
        MapperService mapperService = this.createMapperService(settings, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        DocumentMapper mapper = mapperService.documentMapper();
        MappedFieldType.BlockLoaderContext mockBlockContext = (MappedFieldType.BlockLoaderContext)Mockito.mock(MappedFieldType.BlockLoaderContext.class);
        Mockito.when((Object)mockBlockContext.fieldExtractPreference()).thenReturn((Object)MappedFieldType.FieldExtractPreference.DOC_VALUES);
        IndexMetadata indexMetadata = new IndexMetadata.Builder("index").settings(settings).build();
        IndexSettings indexSettings = new IndexSettings(indexMetadata, settings);
        Mockito.when((Object)mockBlockContext.indexSettings()).thenReturn((Object)indexSettings);
        Object[] sampleValuesForIndexing = this.getThreeSampleValues();
        Object[] expectedSampleValues = this.getThreeEncodedSampleValues();
        CheckedConsumer builder = iw -> {
            for (int i = 0; i < 3; ++i) {
                Object value = sampleValuesForIndexing[i];
                LuceneDocument doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("@timestamp", 1L).field("field", String.valueOf(value))))).rootDoc();
                iw.addDocument((Iterable)doc);
            }
        };
        CheckedConsumer test = reader -> {
            MapperTestCase.assertThat(reader.leaves(), Matchers.hasSize((int)1));
            MapperTestCase.assertThat(reader.numDocs(), Matchers.equalTo((Object)3));
            LeafReaderContext context = (LeafReaderContext)reader.leaves().get(0);
            BlockLoader blockLoader = mapperService.fieldType("field").blockLoader(mockBlockContext);
            BlockDocValuesReader columnReader = (BlockDocValuesReader)readerCast.apply(blockLoader.columnAtATimeReader(context));
            MapperTestCase.assertThat(((BlockDocValuesReader.NumericDocValuesAccessor)columnReader).numericDocValues(), Matchers.instanceOf(BlockLoader.OptionalColumnAtATimeReader.class));
            BlockLoader.Docs docBlock = TestBlock.docs(IntStream.range(0, 3).toArray());
            TestBlock block = (TestBlock)columnReader.read(TestBlock.factory(), docBlock, 0, MapperTestCase.randomBoolean());
            for (int i = 0; i < block.size(); ++i) {
                MapperTestCase.assertThat(block.get(i), Matchers.equalTo((Object)expectedSampleValues[i]));
            }
        };
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)builder, (CheckedConsumer<DirectoryReader, IOException>)test);
        builder = iw -> {
            LuceneDocument doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("@timestamp", 1L).field("field", String.valueOf(sampleValuesForIndexing[0]))))).rootDoc();
            iw.addDocument((Iterable)doc);
            doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("@timestamp", 1L)))).rootDoc();
            iw.addDocument((Iterable)doc);
            doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("@timestamp", 1L).field("field", String.valueOf(sampleValuesForIndexing[2]))))).rootDoc();
            iw.addDocument((Iterable)doc);
        };
        test = reader -> {
            MapperTestCase.assertThat(reader.leaves(), Matchers.hasSize((int)1));
            MapperTestCase.assertThat(reader.numDocs(), Matchers.equalTo((Object)3));
            LeafReaderContext context = (LeafReaderContext)reader.leaves().get(0);
            BlockLoader blockLoader = mapperService.fieldType("field").blockLoader(mockBlockContext);
            BlockDocValuesReader columnReader = (BlockDocValuesReader)readerCast.apply(blockLoader.columnAtATimeReader(context));
            BlockLoader.Docs docBlock = TestBlock.docs(IntStream.range(0, 3).toArray());
            TestBlock block = (TestBlock)columnReader.read(TestBlock.factory(), docBlock, 0, false);
            MapperTestCase.assertThat(block.get(0), Matchers.equalTo((Object)expectedSampleValues[0]));
            MapperTestCase.assertThat(block.get(1), Matchers.nullValue());
            MapperTestCase.assertThat(block.get(2), Matchers.equalTo((Object)expectedSampleValues[2]));
            docBlock = TestBlock.docs(0, 2);
            columnReader = (BlockDocValuesReader)readerCast.apply(blockLoader.columnAtATimeReader(context));
            NumericDocValues numeric = ((BlockDocValuesReader.NumericDocValuesAccessor)columnReader).numericDocValues();
            MapperTestCase.assertThat(numeric, Matchers.instanceOf(BlockLoader.OptionalColumnAtATimeReader.class));
            BlockLoader.OptionalColumnAtATimeReader directReader = (BlockLoader.OptionalColumnAtATimeReader)numeric;
            boolean toInt = this.supportsBulkIntBlockReading();
            MapperTestCase.assertNull((Object)directReader.tryRead(TestBlock.factory(), docBlock, 0, false, null, toInt, false));
            block = (TestBlock)directReader.tryRead(TestBlock.factory(), docBlock, 0, true, null, toInt, false);
            MapperTestCase.assertNotNull((Object)block);
            MapperTestCase.assertThat(block.get(0), Matchers.equalTo((Object)expectedSampleValues[0]));
            MapperTestCase.assertThat(block.get(1), Matchers.equalTo((Object)expectedSampleValues[2]));
        };
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)builder, (CheckedConsumer<DirectoryReader, IOException>)test);
        builder = iw -> {
            LuceneDocument doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("@timestamp", 1L).field("field", String.valueOf(sampleValuesForIndexing[0]))))).rootDoc();
            iw.addDocument((Iterable)doc);
            doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("@timestamp", 1L).field("field", List.of(String.valueOf(sampleValuesForIndexing[0]), String.valueOf(sampleValuesForIndexing[1])))))).rootDoc();
            iw.addDocument((Iterable)doc);
            doc = mapper.parse(MapperTestCase.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field("@timestamp", 1L).field("field", String.valueOf(sampleValuesForIndexing[2]))))).rootDoc();
            iw.addDocument((Iterable)doc);
        };
        test = reader -> {
            MapperTestCase.assertThat(reader.leaves(), Matchers.hasSize((int)1));
            MapperTestCase.assertThat(reader.numDocs(), Matchers.equalTo((Object)3));
            LeafReaderContext context = (LeafReaderContext)reader.leaves().get(0);
            BlockLoader blockLoader = mapperService.fieldType("field").blockLoader(mockBlockContext);
            BlockLoader.ColumnAtATimeReader columnReader = blockLoader.columnAtATimeReader(context);
            MapperTestCase.assertThat(columnReader, Matchers.anyOf((Matcher)Matchers.instanceOf(AbstractLongsFromDocValuesBlockLoader.Sorted.class), (Matcher)Matchers.instanceOf(AbstractDoublesFromDocValuesBlockLoader.Sorted.class), (Matcher)Matchers.instanceOf(AbstractIntsFromDocValuesBlockLoader.Singleton.class)));
            BlockLoader.Docs docBlock = TestBlock.docs(IntStream.range(0, 3).toArray());
            TestBlock block = (TestBlock)columnReader.read(TestBlock.factory(), docBlock, 0, false);
            MapperTestCase.assertThat(block.get(0), Matchers.equalTo((Object)expectedSampleValues[0]));
            MapperTestCase.assertThat(block.get(1), Matchers.equalTo(List.of(expectedSampleValues[0], expectedSampleValues[1])));
            MapperTestCase.assertThat(block.get(2), Matchers.equalTo((Object)expectedSampleValues[2]));
        };
        MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)builder, (CheckedConsumer<DirectoryReader, IOException>)test);
    }

    protected String randomSyntheticSourceKeep() {
        return MapperTestCase.randomFrom("all", "arrays");
    }

    @Override
    protected final <T> T compileScript(Script script, ScriptContext<T> context) {
        return this.ingestScriptSupport().compileScript(script, context);
    }

    protected abstract IngestScriptSupport ingestScriptSupport();

    protected abstract List<SortShortcutSupport> getSortShortcutSupport();

    private static Consumer<DocIdSetIterator> checkNotNull(boolean supportsShortcut) {
        if (supportsShortcut) {
            return Assert::assertNotNull;
        }
        return Assert::assertNull;
    }

    public final void testSortShortcuts() throws IOException {
        List<SortShortcutSupport> tests = this.getSortShortcutSupport();
        if (tests == null || tests.isEmpty()) {
            MapperService mapperService = this.createMapperService(MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
            MappedFieldType ft = mapperService.fieldType("field");
            MapperTestCase.expectThrows(IllegalArgumentException.class, () -> ft.fielddataBuilder(new FieldDataContext("", mapperService.getIndexSettings(), () -> null, Set::of, MappedFieldType.FielddataOperation.SEARCH)).build(null, null).sortField(false, IndexVersion.current(), null, MultiValueMode.MIN, null, false));
        } else {
            for (SortShortcutSupport sortShortcutSupport : tests) {
                MapperService mapperService = this.createMapperService(sortShortcutSupport.indexVersion(), sortShortcutSupport.settings, () -> true);
                MapperTestCase.merge(mapperService, MapperTestCase.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                    b.startObject(sortShortcutSupport.fieldname);
                    sortShortcutSupport.fieldMapping.accept(b);
                    b.endObject();
                    sortShortcutSupport.additionalMappings.accept(b);
                })));
                MapperTestCase.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)mapperService.documentParser().parseDocument(MapperTestCase.source(sortShortcutSupport.document()), mapperService.mappingLookup()).rootDoc())), (CheckedConsumer<DirectoryReader, IOException>)((CheckedConsumer)reader -> {
                    IndexSearcher searcher = MapperTestCase.newSearcher((IndexReader)reader);
                    MappedFieldType ft = mapperService.fieldType(sortShortcutSupport.fieldname);
                    SortField sortField = ft.fielddataBuilder(new FieldDataContext("", mapperService.getIndexSettings(), () -> {
                        throw new UnsupportedOperationException();
                    }, Set::of, MappedFieldType.FielddataOperation.SEARCH)).build(null, null).sortField(false, this.getVersion(), null, MultiValueMode.MIN, null, false);
                    FieldComparator comparator = sortField.getComparator(1, Pruning.GREATER_THAN_OR_EQUAL_TO);
                    LeafFieldComparator leafComparator = comparator.getLeafComparator((LeafReaderContext)searcher.getLeafContexts().getFirst());
                    leafComparator.setHitsThresholdReached();
                    leafComparator.setBottom(0);
                    sortShortcutSupport.competitiveIteratorCheck.accept(leafComparator.competitiveIterator());
                }));
            }
        }
        this.assertParseMinimalWarnings();
    }

    protected boolean supportsDocValuesSkippers() {
        return true;
    }

    public void testDocValuesSkippers() throws IOException {
        MapperTestCase.assumeTrue((String)"Mapper does not support doc values skippers", (boolean)this.supportsDocValuesSkippers());
        IndexVersion preSkipperVersion = IndexVersionUtils.randomPreviousCompatibleVersion(MapperTestCase.random(), IndexVersions.STANDARD_INDEXES_USE_SKIPPERS);
        IndexVersion withSkipperVersion = IndexVersions.STANDARD_INDEXES_USE_SKIPPERS;
        Settings skippersDisabled = Settings.builder().put(IndexSettings.USE_DOC_VALUES_SKIPPER.getKey(), false).build();
        Settings skippersEnabled = Settings.builder().put(IndexSettings.USE_DOC_VALUES_SKIPPER.getKey(), true).build();
        MapperService mapperService = this.createMapperService(preSkipperVersion, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", true);
            b.field("index", false);
        })));
        MapperTestCase.assertThat(mapperService.fieldType("field").indexType(), Matchers.equalTo((Object)IndexType.docValuesOnly()));
        mapperService = this.createMapperService(withSkipperVersion, skippersEnabled, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", true);
            b.field("index", false);
        })));
        MapperTestCase.assertThat(mapperService.fieldType("field").indexType(), Matchers.equalTo((Object)IndexType.skippers()));
        mapperService = this.createMapperService(withSkipperVersion, skippersDisabled, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", true);
            b.field("index", false);
        })));
        MapperTestCase.assertThat(mapperService.fieldType("field").indexType(), Matchers.equalTo((Object)IndexType.docValuesOnly()));
        Settings statelessSkipperDefault = Settings.builder().put("stateless.enabled", true).build();
        IndexVersion statelessNoSkipperVersion = IndexVersionUtils.randomPreviousCompatibleVersion(MapperTestCase.random(), IndexVersions.STANDARD_INDEXES_USE_SKIPPERS);
        MapperService mapperService2 = this.createMapperService(statelessNoSkipperVersion, statelessSkipperDefault, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", true);
            b.field("index", false);
        })));
        MapperTestCase.assertThat(mapperService2.fieldType("field").indexType(), Matchers.equalTo((Object)IndexType.docValuesOnly()));
        Settings statelessSkipperTSDB = Settings.builder().put("stateless.enabled", true).put(IndexSettings.MODE.getKey(), (Enum)IndexMode.TIME_SERIES).put(IndexMetadata.INDEX_ROUTING_PATH.getKey(), "foo").build();
        IndexVersion statelessSkipperVersion = IndexVersions.STATELESS_SKIPPERS_ENABLED_FOR_TSDB;
        MapperService mapperService3 = this.createMapperService(statelessSkipperVersion, statelessSkipperTSDB, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", true);
            b.field("index", false);
        })));
        MapperTestCase.assertThat(mapperService3.fieldType("field").indexType(), Matchers.equalTo((Object)IndexType.skippers()));
        Settings statelessSkipperEnabled = Settings.builder().put("stateless.enabled", true).put(IndexSettings.USE_DOC_VALUES_SKIPPER.getKey(), true).build();
        MapperService mapperService4 = this.createMapperService(statelessSkipperVersion, statelessSkipperEnabled, MapperTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("doc_values", true);
            b.field("index", false);
        })));
        MapperTestCase.assertThat(mapperService4.fieldType("field").indexType(), Matchers.equalTo((Object)IndexType.skippers()));
    }

    private /* synthetic */ void lambda$assertFetch$49(MapperService mapperService, ValueFetcher docValueFetcher, ValueFetcher nativeFetcher, Object value, DirectoryReader ir) throws IOException {
        Source s = SourceProvider.fromLookup((MappingLookup)mapperService.mappingLookup(), null, (SourceFieldMetrics)mapperService.getMapperMetrics().sourceFieldMetrics()).getSource((LeafReaderContext)ir.leaves().get(0), 0);
        docValueFetcher.setNextReader((LeafReaderContext)ir.leaves().get(0));
        nativeFetcher.setNextReader((LeafReaderContext)ir.leaves().get(0));
        List fromDocValues = docValueFetcher.fetchValues(s, 0, new ArrayList());
        List fromNative = nativeFetcher.fetchValues(s, 0, new ArrayList());
        fromNative = fromNative.stream().map(o -> {
            if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
                return ((Number)o).longValue();
            }
            if (o instanceof Float) {
                return ((Float)o).doubleValue();
            }
            return o;
        }).collect(Collectors.toList());
        if (this.dedupAfterFetch()) {
            fromNative = fromNative.stream().distinct().collect(Collectors.toList());
        }
        MapperTestCase.assertThat("fetching " + String.valueOf(value), fromNative, Matchers.containsInAnyOrder((Object[])fromDocValues.toArray()));
    }

    public static class ExampleMalformedValue {
        private final CheckedConsumer<XContentBuilder, IOException> mapping;
        private final CheckedConsumer<XContentBuilder, IOException> value;
        private final Matcher<String> exceptionMessageMatcher;

        private ExampleMalformedValue(CheckedConsumer<XContentBuilder, IOException> mapping, CheckedConsumer<XContentBuilder, IOException> value, Matcher<String> exceptionMessageMatcher) {
            this.mapping = mapping;
            this.value = value;
            this.exceptionMessageMatcher = exceptionMessageMatcher;
        }

        public ExampleMalformedValue mapping(CheckedConsumer<XContentBuilder, IOException> newMapping) {
            return new ExampleMalformedValue(newMapping, this.value, this.exceptionMessageMatcher);
        }

        public ExampleMalformedValue errorMatches(String contains) {
            return this.errorMatches((Matcher<String>)Matchers.containsString((String)contains));
        }

        public ExampleMalformedValue errorMatches(Matcher<String> newMatcher) {
            return new ExampleMalformedValue(this.mapping, this.value, newMatcher);
        }
    }

    public class ParameterChecker {
        List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();
        Map<String, ConflictCheck> conflictChecks = new HashMap<String, ConflictCheck>();

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(update, check));
        }

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(init, update, check));
        }

        public void registerConflictCheck(String param, CheckedConsumer<XContentBuilder, IOException> update) throws IOException {
            this.conflictChecks.put(param, new ConflictCheck(MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping)), MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }))));
        }

        public void registerConflictCheck(String param, XContentBuilder init, XContentBuilder update) {
            this.conflictChecks.put(param, new ConflictCheck(init, update));
        }
    }

    private class UpdateCheck {
        final XContentBuilder init;
        final XContentBuilder update;
        final Consumer<FieldMapper> check;

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping));
            this.update = MapperServiceTestCase.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }));
            this.check = check;
        }

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperServiceTestCase.fieldMapping(init);
            this.update = MapperServiceTestCase.fieldMapping(update);
            this.check = check;
        }
    }

    private record ConflictCheck(XContentBuilder init, XContentBuilder update) {
    }

    public static interface SyntheticSourceSupport {
        default public boolean preservesExactSource() {
            return false;
        }

        default public boolean ignoreAbove() {
            return false;
        }

        public SyntheticSourceExample example(int var1) throws IOException;

        public List<SyntheticSourceInvalidExample> invalidExample() throws IOException;
    }

    public record SyntheticSourceExample(CheckedConsumer<XContentBuilder, IOException> inputValue, CheckedConsumer<XContentBuilder, IOException> expectedForSyntheticSource, CheckedConsumer<XContentBuilder, IOException> mapping) {
        public SyntheticSourceExample(Object inputValue, Object result, CheckedConsumer<XContentBuilder, IOException> mapping) {
            this((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(inputValue)), (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.value(result)), mapping);
        }

        public void buildInput(XContentBuilder b) throws IOException {
            b.field("field");
            this.inputValue.accept((Object)b);
        }

        public void buildInputArray(XContentBuilder b, int elementCount) throws IOException {
            b.startArray("field");
            for (int i = 0; i < elementCount; ++i) {
                this.inputValue.accept((Object)b);
            }
            b.endArray();
        }

        private String expected() throws IOException {
            XContentBuilder b = JsonXContent.contentBuilder().startObject().field("field");
            this.expectedForSyntheticSource.accept((Object)b);
            return Strings.toString((XContentBuilder)b.endObject());
        }
    }

    protected abstract class IngestScriptSupport {
        protected IngestScriptSupport(MapperTestCase this$0) {
        }

        private <T> T compileScript(Script script, ScriptContext<T> context) {
            switch (script.getIdOrCode()) {
                case "empty": {
                    return context.factoryClazz.cast(this.emptyFieldScript());
                }
                case "non-empty": {
                    return context.factoryClazz.cast(this.nonEmptyFieldScript());
                }
            }
            return this.compileOtherScript(script, context);
        }

        protected <T> T compileOtherScript(Script script, ScriptContext<T> context) {
            throw new UnsupportedOperationException("Unknown script " + script.getIdOrCode());
        }

        abstract ScriptFactory emptyFieldScript();

        abstract ScriptFactory nonEmptyFieldScript();
    }

    public record SyntheticSourceInvalidExample(Matcher<String> error, CheckedConsumer<XContentBuilder, IOException> mapping) {
    }

    public record SortShortcutSupport(IndexVersion indexVersion, Settings settings, String fieldname, CheckedConsumer<XContentBuilder, IOException> fieldMapping, CheckedConsumer<XContentBuilder, IOException> additionalMappings, CheckedConsumer<XContentBuilder, IOException> document, Consumer<DocIdSetIterator> competitiveIteratorCheck) {
        public SortShortcutSupport(CheckedConsumer<XContentBuilder, IOException> mappings, CheckedConsumer<XContentBuilder, IOException> document, boolean supportsShortcut) {
            this(IndexVersion.current(), MapperServiceTestCase.SETTINGS, "field", mappings, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {}), document, MapperTestCase.checkNotNull(supportsShortcut));
        }

        public SortShortcutSupport(IndexVersion indexVersion, CheckedConsumer<XContentBuilder, IOException> mappings, CheckedConsumer<XContentBuilder, IOException> document, boolean supportsShortcut) {
            this(indexVersion, MapperServiceTestCase.SETTINGS, "field", mappings, (CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {}), document, MapperTestCase.checkNotNull(supportsShortcut));
        }
    }
}

