/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;

public class MetaStateWriterUtils {
    private static final Logger logger = LogManager.getLogger(MetaStateWriterUtils.class);

    private MetaStateWriterUtils() {
        throw new AssertionError((Object)"static methods only");
    }

    public static long writeIndex(NodeEnvironment nodeEnv, String reason, IndexMetadata indexMetadata) throws WriteStateException {
        Index index = indexMetadata.getIndex();
        logger.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            long generation = IndexMetadata.FORMAT.write((Object)indexMetadata, nodeEnv.indexPaths(indexMetadata.getIndex()));
            logger.trace("[{}] state written", (Object)index);
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[" + String.valueOf(index) + "]: failed to write index state", (Exception)((Object)ex));
        }
    }
}

