/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.queries;

import java.util.List;
import java.util.Map;
import org.elasticsearch.datageneration.FieldType;
import org.elasticsearch.datageneration.queries.MappingPredicates;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public interface LeafQueryGenerator {
    public List<QueryBuilder> generate(Map<String, Object> var1, String var2, Object var3);

    public static LeafQueryGenerator buildForType(String type, MappingPredicates mappingPredicates) {
        LeafQueryGenerator noQueries = (fieldMapping, path, value) -> List.of();
        FieldType fieldType = FieldType.tryParse(type);
        if (fieldType == null) {
            return noQueries;
        }
        return switch (fieldType) {
            case FieldType.KEYWORD -> new KeywordQueryGenerator();
            case FieldType.WILDCARD -> new WildcardQueryGenerator();
            case FieldType.TEXT -> new TextQueryGenerator();
            case FieldType.MATCH_ONLY_TEXT -> new MatchOnlyTextQueryGenerator(mappingPredicates);
            default -> noQueries;
        };
    }

    private static boolean extendedDocValuesEnabled(Map<String, Object> fieldMapping) {
        Object configuredValue = fieldMapping.getOrDefault("doc_values", true);
        if (configuredValue instanceof Boolean) {
            Boolean b = (Boolean)configuredValue;
            return b;
        }
        if (configuredValue instanceof Map) {
            return true;
        }
        throw new IllegalArgumentException("Unexpected value [" + String.valueOf(configuredValue) + "] for mapping parameter [doc_values]");
    }

    public static boolean containsHighSurrogates(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isHighSurrogate(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static class KeywordQueryGenerator
    implements LeafQueryGenerator {
        @Override
        public List<QueryBuilder> generate(Map<String, Object> fieldMapping, String path, Object value) {
            if (fieldMapping != null) {
                boolean isIndexed = (Boolean)fieldMapping.getOrDefault("index", true);
                boolean hasDocValues = LeafQueryGenerator.extendedDocValuesEnabled(fieldMapping);
                if (!isIndexed && !hasDocValues) {
                    return List.of();
                }
            }
            return List.of(QueryBuilders.termQuery((String)path, (Object)value), QueryBuilders.matchQuery((String)path, (Object)value));
        }
    }

    public static class WildcardQueryGenerator
    implements LeafQueryGenerator {
        @Override
        public List<QueryBuilder> generate(Map<String, Object> fieldMapping, String path, Object value) {
            if (LeafQueryGenerator.containsHighSurrogates((String)value)) {
                return List.of();
            }
            return List.of(QueryBuilders.termQuery((String)path, (Object)value), QueryBuilders.wildcardQuery((String)path, (String)(String.valueOf(value) + "*")));
        }
    }

    public static class TextQueryGenerator
    implements LeafQueryGenerator {
        @Override
        public List<QueryBuilder> generate(Map<String, Object> fieldMapping, String path, Object value) {
            boolean isIndexed;
            if (fieldMapping != null && !(isIndexed = ((Boolean)fieldMapping.getOrDefault("index", true)).booleanValue())) {
                return List.of();
            }
            return List.of(QueryBuilders.matchQuery((String)path, (Object)value), QueryBuilders.matchPhraseQuery((String)path, (Object)value));
        }
    }

    public record MatchOnlyTextQueryGenerator(MappingPredicates mappingPredicates) implements LeafQueryGenerator
    {
        @Override
        public List<QueryBuilder> generate(Map<String, Object> fieldMapping, String path, Object value) {
            if (this.mappingPredicates.inNestedContext(path)) {
                return List.of(QueryBuilders.matchQuery((String)path, (Object)value));
            }
            return List.of(QueryBuilders.matchQuery((String)path, (Object)value), QueryBuilders.matchPhraseQuery((String)path, (Object)value));
        }
    }
}

